/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.integration.dashboards.web;

import com.netgrif.application.engine.integration.dashboards.service.interfaces.IDashboardService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboard"})
@Tag(name="Dashboard")
public class DashboardController {
    private final IDashboardService dashboardService;

    public DashboardController(IDashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @Operation(summary="Execute Elasticsearch aggregation", description="The provided aggregation is executed and its result is returned", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/json"})
    public String getAggregationByQuery(@RequestBody String query, @RequestParam(value="type") String type) {
        return this.dashboardService.searchByQuery(query, type);
    }
}

