/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.domain;

import com.netgrif.application.engine.auth.domain.Authority;
import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.ldap.domain.LdapUser;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.security.core.GrantedAuthority;

@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class LdapLoggedUser
extends LoggedUser {
    private String dn;
    private String commonName;
    private String uid;
    private Set<String> memberOf;
    private String homeDirectory;

    public LdapLoggedUser(String id, String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(id, username, password, authorities);
    }

    public LdapLoggedUser(String id, String username, String password, String dn, String commonName, Set<String> memberOf, String uid, String homeDirectory, Collection<? extends GrantedAuthority> authorities) {
        super(id, username, password, authorities);
        this.dn = dn;
        this.commonName = commonName;
        this.memberOf = memberOf;
        this.uid = uid;
        this.homeDirectory = homeDirectory;
    }

    @Override
    public IUser transformToUser() {
        LdapUser user = new LdapUser(new ObjectId(this.id));
        user.setEmail(this.getUsername());
        String[] names = this.getFullName().split(" ");
        user.setName(names[0]);
        user.setSurname(names[1]);
        user.setDn(this.dn);
        user.setCommonName(this.commonName);
        user.setUid(this.uid);
        user.setMemberOf(this.memberOf);
        user.setHomeDirectory(this.homeDirectory);
        user.setState(UserState.ACTIVE);
        user.setPassword("n/a");
        user.setAuthorities(this.getAuthorities().stream().map(a -> (Authority)a).collect(Collectors.toSet()));
        user.setProcessRoles(this.getProcessRoles().stream().map(roleId -> {
            ProcessRole role = new ProcessRole();
            role.set_id((String)roleId);
            return role;
        }).collect(Collectors.toSet()));
        if (this.isImpersonating()) {
            user.setImpersonated(this.getImpersonated().transformToUser());
        }
        return user;
    }

    @Generated
    public String getDn() {
        return this.dn;
    }

    @Generated
    public void setDn(String dn) {
        this.dn = dn;
    }

    @Generated
    public String getCommonName() {
        return this.commonName;
    }

    @Generated
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public Set<String> getMemberOf() {
        return this.memberOf;
    }

    @Generated
    public void setMemberOf(Set<String> memberOf) {
        this.memberOf = memberOf;
    }

    @Generated
    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    @Generated
    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }
}

