/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.domain;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.ldap.domain.LdapLoggedUser;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="user")
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class LdapUser
extends User {
    @Indexed
    private String dn;
    private String commonName;
    private String uid;
    private String homeDirectory;
    private Set<String> memberOf;

    public LdapUser() {
    }

    public LdapUser(ObjectId id) {
        this();
        this._id = id;
        this.nextGroups = new HashSet();
    }

    public LdapUser(String dn, String commonName, String uid, String homeDirectory, String email, String name, String surname, Set<String> memberOf, String telNumber) {
        this.setEmail(email);
        this.setName(name);
        this.setSurname(surname);
        this.setDn(dn);
        this.setCommonName(commonName);
        this.setUid(uid);
        this.setHomeDirectory(homeDirectory);
        this.setMemberOf(memberOf);
        this.setTelNumber(telNumber);
    }

    @Override
    public String getStringId() {
        return this._id.toString();
    }

    @Override
    public LoggedUser transformToLoggedUser() {
        LdapLoggedUser loggedUser = new LdapLoggedUser(this.getStringId(), this.getEmail(), this.getPassword(), this.getDn(), this.getCommonName(), this.getMemberOf(), this.getUid(), this.getHomeDirectory(), this.getAuthorities());
        loggedUser.setFullName(this.getFullName());
        if (!this.getProcessRoles().isEmpty()) {
            loggedUser.parseProcessRoles(this.getProcessRoles());
        }
        loggedUser.setGroups(this.getNextGroups());
        if (this.isImpersonating()) {
            loggedUser.impersonate(this.getImpersonated().transformToLoggedUser());
        }
        return loggedUser;
    }

    public void loadFromUser(IUser user) {
        this.setEmail(user.getEmail());
        this.setName(user.getName());
        this.setSurname(user.getSurname());
        this.setAvatar(user.getAvatar());
        this.setTelNumber(user.getTelNumber());
        this.setNextGroups(user.getNextGroups());
        this.setProcessRoles(user.getProcessRoles());
        this.setState(user.getState());
    }

    @Generated
    public String getDn() {
        return this.dn;
    }

    @Generated
    public String getCommonName() {
        return this.commonName;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    @Generated
    public Set<String> getMemberOf() {
        return this.memberOf;
    }

    @Generated
    public void setDn(String dn) {
        this.dn = dn;
    }

    @Generated
    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Generated
    public void setMemberOf(Set<String> memberOf) {
        this.memberOf = memberOf;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LdapUser)) {
            return false;
        }
        LdapUser other = (LdapUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dn = this.getDn();
        String other$dn = other.getDn();
        if (this$dn == null ? other$dn != null : !this$dn.equals(other$dn)) {
            return false;
        }
        String this$commonName = this.getCommonName();
        String other$commonName = other.getCommonName();
        if (this$commonName == null ? other$commonName != null : !this$commonName.equals(other$commonName)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$homeDirectory = this.getHomeDirectory();
        String other$homeDirectory = other.getHomeDirectory();
        if (this$homeDirectory == null ? other$homeDirectory != null : !this$homeDirectory.equals(other$homeDirectory)) {
            return false;
        }
        Set<String> this$memberOf = this.getMemberOf();
        Set<String> other$memberOf = other.getMemberOf();
        return !(this$memberOf == null ? other$memberOf != null : !((Object)this$memberOf).equals(other$memberOf));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LdapUser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dn = this.getDn();
        result = result * 59 + ($dn == null ? 43 : $dn.hashCode());
        String $commonName = this.getCommonName();
        result = result * 59 + ($commonName == null ? 43 : $commonName.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $homeDirectory = this.getHomeDirectory();
        result = result * 59 + ($homeDirectory == null ? 43 : $homeDirectory.hashCode());
        Set<String> $memberOf = this.getMemberOf();
        result = result * 59 + ($memberOf == null ? 43 : ((Object)$memberOf).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LdapUser(dn=" + this.getDn() + ", commonName=" + this.getCommonName() + ", uid=" + this.getUid() + ", homeDirectory=" + this.getHomeDirectory() + ", memberOf=" + this.getMemberOf() + ")";
    }
}

