/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.filters;

import com.netgrif.application.engine.configuration.ApplicationContextProvider;
import com.netgrif.application.engine.configuration.security.AuthenticationService;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.GenericFilterBean;

public class LoginAttemptsFilter
extends GenericFilterBean {
    private final String[] PERMIT_ALL_STATIC_PATTERNS = new String[]{"/bower_components/", "/scripts/", "/assets/", "/styles/", "/views/", "/favicon.ico", "/manifest.json", "/configuration/", "/swagger-resources/", "/swagger-ui.html", "/webjars/", "/index.html", "/login", "/signup/", "/recover/", "/api/auth/signup", "/api/auth/token/verify", "/api/auth/reset", "/api/auth/recover", "/v2/api-docs", "/swagger-ui.html"};

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (((HttpServletRequest)request).getRequestURI().equalsIgnoreCase("/") || this.isPermitted(((HttpServletRequest)request).getRequestURI())) {
            chain.doFilter(request, response);
        } else {
            String clientIP;
            AuthenticationService service = (AuthenticationService)ApplicationContextProvider.getBean("authenticationService");
            if (service.isIPBlocked(clientIP = AuthenticationService.getClientIP((HttpServletRequest)request))) {
                ((HttpServletResponse)response).sendError(401, "Account is temporary blocked due to exceeding the number of unsuccessful login attempts. Please wait a moment and then try again.");
                return;
            }
            chain.doFilter(request, response);
        }
    }

    private boolean isPermitted(String url) {
        return Arrays.stream(this.PERMIT_ALL_STATIC_PATTERNS).anyMatch(url::startsWith);
    }
}

