/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.configuration.ldap.LdapConfiguration;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import com.netgrif.application.engine.ldap.domain.LdapGroup;
import com.netgrif.application.engine.ldap.domain.LdapGroupRef;
import com.netgrif.application.engine.ldap.domain.repository.LdapGroupRoleRepository;
import com.netgrif.application.engine.ldap.service.interfaces.ILdapGroupRefService;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class LdapGroupRefService
implements ILdapGroupRefService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapGroupRefService.class);
    private final LdapConfiguration ldapConfiguration;
    private final LdapGroupRoleRepository ldapGroupRoleRepository;
    private final IProcessRoleService processRoleService;
    private final NaeLdapProperties ldapProperties;

    public LdapGroupRefService(LdapConfiguration ldapConfiguration, LdapGroupRoleRepository ldapGroupRoleRepository, IProcessRoleService processRoleService, NaeLdapProperties ldapProperties) {
        this.ldapConfiguration = ldapConfiguration;
        this.ldapGroupRoleRepository = ldapGroupRoleRepository;
        this.processRoleService = processRoleService;
        this.ldapProperties = ldapProperties;
    }

    @Override
    public List<LdapGroupRef> findAllGroups() {
        LdapQuery findAllGroupsQuery = (LdapQuery)Arrays.stream(this.ldapProperties.getGroupClass()).map(it -> LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupObjectClass()).is(it)).reduce(ContainerCriteria::and).orElse(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupObjectClass()).is(this.ldapProperties.getGroupClass()[0]));
        return this.searchGroups(findAllGroupsQuery);
    }

    @Override
    public List<LdapGroupRef> searchGroups(String fulltext) {
        ContainerCriteria searchQuerry = Arrays.stream(this.ldapProperties.getGroupClass()).map(it -> LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupObjectClass()).is(it)).reduce(ContainerCriteria::and).orElse(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupObjectClass()).is(this.ldapProperties.getGroupClass()[0])).and(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupCn()).whitespaceWildcardsLike(fulltext).or(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupDescription()).whitespaceWildcardsLike(fulltext)));
        return this.searchGroups((LdapQuery)searchQuerry);
    }

    @Override
    public List<LdapGroupRef> searchGroups(LdapQuery ldapQuery) {
        List ldapGroups = this.ldapConfiguration.ldapTemplate().search(ldapQuery, ctx -> (DirContextAdapter)ctx);
        return ldapGroups.stream().map(ldapGroup -> new LdapGroupRef(ldapGroup.getDn(), ldapGroup.getStringAttribute(this.ldapProperties.getMapGroupCn()), ldapGroup.getStringAttributes(this.ldapProperties.getMapGroupMember()), ldapGroup.getStringAttributes(this.ldapProperties.getMapGroupObjectClass()), ldapGroup.getStringAttribute(this.ldapProperties.getMapGroupDescription()))).collect(Collectors.toList());
    }

    @Override
    public List<LdapGroup> getAllLdapGroupRoles() {
        return this.ldapGroupRoleRepository.findAll();
    }

    @Override
    public void deleteProcessRoleByPetrinet(String petriNet) {
        this.ldapGroupRoleRepository.findAll().stream().filter(ldapGroup -> ldapGroup.getProcessesRoles().stream().anyMatch(processRole -> processRole.getNetId().equals(petriNet))).forEach(it -> this.deleteProcessRole((LdapGroup)it, petriNet));
    }

    @Override
    public void deleteProcessRole(LdapGroup ldapGroup, String petriNet) {
        Set<ProcessRole> processRoles = ldapGroup.getProcessesRoles();
        processRoles.forEach(it -> {
            if (it.getNetId().equals(petriNet)) {
                processRoles.remove(it);
            }
        });
        ldapGroup.setProcessesRoles(processRoles);
        this.ldapGroupRoleRepository.save(ldapGroup);
    }

    @Override
    public Set<ProcessRole> getProcessRoleByLdapGroup(Set<String> groupDn) {
        return this.ldapGroupRoleRepository.findAllByDnIn(groupDn).stream().map(LdapGroup::getProcessesRoles).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public void setRoleToLdapGroup(String groupDn, Set<String> requestedRolesIds, LoggedUser loggedUser) {
        Set<ProcessRole> requestedRoles = this.processRoleService.findByIds(requestedRolesIds);
        if (requestedRoles.isEmpty() && !requestedRolesIds.isEmpty()) {
            throw new IllegalArgumentException("No process roles found.");
        }
        if (requestedRoles.size() != requestedRolesIds.size()) {
            throw new IllegalArgumentException("Not all process roles were found!");
        }
        LdapGroup ldapGroup = this.ldapGroupRoleRepository.findByDn(groupDn);
        if (ldapGroup == null) {
            LdapGroup newLdapGroup = new LdapGroup();
            newLdapGroup.setDn(groupDn);
            newLdapGroup.setProcessesRoles(requestedRoles);
            this.ldapGroupRoleRepository.save(newLdapGroup);
        } else {
            ldapGroup.setProcessesRoles(requestedRoles);
            this.ldapGroupRoleRepository.save(ldapGroup);
        }
    }
}

