/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.service;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.UserState;
import com.netgrif.application.engine.auth.service.interfaces.ILdapUserRefService;
import com.netgrif.application.engine.configuration.ldap.LdapConfiguration;
import com.netgrif.application.engine.configuration.properties.NaeLdapProperties;
import com.netgrif.application.engine.event.events.user.UserRegistrationEvent;
import com.netgrif.application.engine.ldap.domain.LdapUser;
import com.netgrif.application.engine.ldap.domain.LdapUserRef;
import com.netgrif.application.engine.ldap.domain.repository.LdapUserRefRepository;
import com.netgrif.application.engine.ldap.service.LdapUserService;
import com.netgrif.application.engine.ldap.service.interfaces.ILdapGroupRefService;
import com.netgrif.application.engine.orgstructure.groups.config.GroupConfigurationProperties;
import com.netgrif.application.engine.orgstructure.groups.interfaces.INextGroupService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.naming.Name;
import lombok.Generated;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class LdapUserRefService
implements ILdapUserRefService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapUserRefService.class);
    @Autowired
    protected ILdapGroupRefService ldapGroupRefService;
    @Autowired
    private LdapUserRefRepository repository;
    @Autowired
    private LdapUserService ldapUserService;
    @Autowired
    private INextGroupService groupService;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private GroupConfigurationProperties groupProperties;
    @Autowired
    private NaeLdapProperties ldapProperties;
    @Autowired
    private LdapConfiguration ldapUserConfiguration;

    @Override
    public IUser createUser(LdapUserRef ldapUserRef) {
        LdapUser ldapUser = new LdapUser(ldapUserRef.getDn().toString(), ldapUserRef.getCn(), ldapUserRef.getUid(), ldapUserRef.getHomeDirectory(), ldapUserRef.getMail(), ldapUserRef.getFirstName(), ldapUserRef.getSurname(), ldapUserRef.getMemberOf(), ldapUserRef.getTelNumber());
        ldapUser.setToken(null);
        ldapUser.setExpirationDate(null);
        ldapUser.setState(UserState.ACTIVE);
        String generatedString = RandomStringUtils.randomAlphanumeric((int)35);
        ldapUser.setPassword(generatedString);
        LdapUser savedUser = (LdapUser)this.ldapUserService.saveNew(ldapUser);
        savedUser.setNextGroups(this.groupService.getAllGroupsOfUser(savedUser));
        if (this.groupProperties.isDefaultEnabled()) {
            this.groupService.createGroup(savedUser);
        }
        if (this.groupProperties.isSystemEnabled()) {
            this.groupService.addUserToDefaultGroup(savedUser);
        }
        this.publisher.publishEvent((ApplicationEvent)new UserRegistrationEvent(savedUser));
        savedUser.setPassword("n/a");
        return this.ldapUserService.save(savedUser);
    }

    @Override
    public LdapUserRef findById(Name id) {
        DirContextOperations context = this.ldapUserConfiguration.ldapTemplate().lookupContext(id);
        LdapUserRef user = new LdapUserRef();
        user.setDn(context.getDn());
        user.setCn(this.verificationData(context, this.ldapProperties.getMapCn()));
        user.setUid(this.verificationData(context, this.ldapProperties.getMapUid()));
        user.setMail(this.verificationData(context, this.ldapProperties.getMapMail()));
        user.setFirstName(this.verificationData(context, this.ldapProperties.getMapFirstName()));
        user.setSurname(this.verificationData(context, this.ldapProperties.getMapSurname()));
        user.setFullName(this.verificationData(context, this.ldapProperties.getMapDisplayName()));
        user.setTelNumber(this.verificationData(context, this.ldapProperties.getMapTelNumber()));
        user.setHomeDirectory(this.verificationData(context, this.ldapProperties.getMapHomeDirectory()));
        ContainerCriteria findAllGroupsGetMemberQuery = Arrays.stream(this.ldapProperties.getGroupClass()).map(it -> LdapQueryBuilder.query().where("objectclass").is(it)).reduce(ContainerCriteria::and).orElse(LdapQueryBuilder.query().where("objectclass").is(this.ldapProperties.getGroupClass()[0])).and(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupMember()).is(((DirContextAdapter)context).getDn().toString() + "," + this.ldapUserConfiguration.contextSource().getBaseLdapPathAsString()));
        List ldapGroups = this.ldapUserConfiguration.ldapTemplate().search((LdapQuery)findAllGroupsGetMemberQuery, ctx -> (DirContextAdapter)ctx);
        user.setMemberOf(ldapGroups.stream().map(DirContextAdapter::getDn).map(Objects::toString).collect(Collectors.toSet()));
        return user;
    }

    private String verificationData(DirContextOperations context, String attribute) {
        if (attribute != null && !attribute.equals("")) {
            try {
                return context.getStringAttribute(attribute);
            }
            catch (Exception e) {
                log.warn("");
                return null;
            }
        }
        return null;
    }

    @Override
    public IUser updateById(Name id, IUser savedUser) {
        DirContextOperations context = this.ldapUserConfiguration.ldapTemplate().lookupContext(id);
        context.setAttributeValues("objectClass", (Object[])this.ldapProperties.getPeopleClass());
        LdapUserRef user = new LdapUserRef();
        user.setUid(this.verificationData(context, this.ldapProperties.getMapUid()));
        user.setMail(this.verificationData(context, this.ldapProperties.getMapMail()));
        user.setFirstName(this.verificationData(context, this.ldapProperties.getMapFirstName()));
        user.setSurname(this.verificationData(context, this.ldapProperties.getMapSurname()));
        user.setTelNumber(this.verificationData(context, this.ldapProperties.getMapTelNumber()));
        user.setCn(this.verificationData(context, this.ldapProperties.getMapCn()));
        user.setFullName(this.verificationData(context, this.ldapProperties.getMapDisplayName()));
        ContainerCriteria findAllGroupsGetMemberQuery = Arrays.stream(this.ldapProperties.getGroupClass()).map(it -> LdapQueryBuilder.query().where("objectclass").is(it)).reduce(ContainerCriteria::and).orElse(LdapQueryBuilder.query().where("objectclass").is(this.ldapProperties.getGroupClass()[0])).and(LdapQueryBuilder.query().where(this.ldapProperties.getMapGroupMember()).is(((DirContextAdapter)context).getDn().toString() + "," + this.ldapUserConfiguration.contextSource().getBaseLdapPathAsString()));
        List ldapGroups = this.ldapUserConfiguration.ldapTemplate().search((LdapQuery)findAllGroupsGetMemberQuery, ctx -> (DirContextAdapter)ctx);
        user.setMemberOf(ldapGroups.stream().map(DirContextAdapter::getDn).map(Objects::toString).collect(Collectors.toSet()));
        user.setHomeDirectory(this.verificationData(context, this.ldapProperties.getMapHomeDirectory()));
        LdapUser ldapUser = (LdapUser)savedUser;
        ldapUser.setCommonName(user.getCn());
        ldapUser.setUid(user.getUid());
        ldapUser.setHomeDirectory(user.getHomeDirectory());
        ldapUser.setEmail(user.getMail());
        ldapUser.setTelNumber(user.getTelNumber());
        ldapUser.setName(user.getFirstName());
        ldapUser.setMemberOf(user.getMemberOf());
        ldapUser.setSurname(user.getSurname());
        return this.ldapUserService.save(ldapUser);
    }

    @Override
    public LdapUserRef findUserByDn(String dn) {
        return this.repository.findByDn(dn);
    }

    @Override
    public LdapUserRef findUserByCn(String cn) {
        return this.repository.findByCn(cn);
    }
}

