/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.ldap.service;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.User;
import com.netgrif.application.engine.auth.service.UserService;
import com.netgrif.application.engine.ldap.domain.LdapUser;
import com.netgrif.application.engine.ldap.domain.repository.LdapUserRepository;
import com.netgrif.application.engine.ldap.service.LdapGroupRefService;
import javax.naming.Name;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
@ConditionalOnExpression(value="${nae.ldap.enabled:false}")
public class LdapUserService
extends UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapUserService.class);
    @Autowired
    private LdapUserRepository ldapUserRepository;
    @Autowired
    private LdapGroupRefService ldapGroupRefService;

    public LdapUser findByDn(Name dn) {
        return this.ldapUserRepository.findByDn(dn.toString());
    }

    @Override
    public IUser findByEmail(String email, boolean small) {
        User user = this.userRepository.findByEmail(email);
        if (user instanceof LdapUser && ((LdapUser)user).getMemberOf() != null && !((LdapUser)user).getMemberOf().isEmpty()) {
            this.ldapGroupRefService.getProcessRoleByLdapGroup(((LdapUser)user).getMemberOf()).forEach(user::addProcessRole);
        }
        return user;
    }

    protected LdapUser getUserFromLdap(IUser user) {
        if (user instanceof LdapUser) {
            return (LdapUser)user;
        }
        return this.transformToUserFromLdap(user);
    }

    public LdapUser transformToUserFromLdap(IUser user) {
        LdapUser userFromLdap = this.ldapUserRepository.findByEmail(user.getEmail());
        if (userFromLdap == null && user.getStringId() != null) {
            userFromLdap = new LdapUser(new ObjectId(user.getStringId()));
        } else if (userFromLdap == null) {
            userFromLdap = new LdapUser();
        }
        userFromLdap.loadFromUser(user);
        return userFromLdap;
    }
}

