/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.mail;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netgrif.application.engine.configuration.properties.SecurityLimitsProperties;
import com.netgrif.application.engine.mail.interfaces.IMailAttemptService;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailAttemptService
implements IMailAttemptService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailAttemptService.class);
    private SecurityLimitsProperties securityLimitsProperties;
    private LoadingCache<String, Integer> attemptsCache;

    @Autowired
    public MailAttemptService(SecurityLimitsProperties securityLimitsProperties) {
        this.securityLimitsProperties = securityLimitsProperties;
        this.attemptsCache = CacheBuilder.newBuilder().expireAfterWrite((long)securityLimitsProperties.getEmailBlockDuration(), securityLimitsProperties.getEmailBlockTimeType()).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) {
                return 0;
            }
        });
    }

    @Override
    public void mailAttempt(String key) {
        int attempts = 0;
        try {
            attempts = (Integer)this.attemptsCache.get((Object)key);
        }
        catch (ExecutionException e) {
            log.error("Error reading mail attempts cache for key " + key, (Throwable)e);
            attempts = 0;
        }
        this.attemptsCache.put((Object)key, (Object)(++attempts));
    }

    @Override
    public boolean isBlocked(String key) {
        try {
            return (Integer)this.attemptsCache.get((Object)key) >= this.securityLimitsProperties.getEmailSendsAttempts();
        }
        catch (ExecutionException e) {
            log.error("Error reading mail attempts cache for key " + key, (Throwable)e);
            return false;
        }
    }
}

