/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.mail;

import com.netgrif.application.engine.auth.domain.RegisteredUser;
import com.netgrif.application.engine.auth.service.interfaces.IRegistrationService;
import com.netgrif.application.engine.configuration.properties.ServerAuthProperties;
import com.netgrif.application.engine.mail.EmailType;
import com.netgrif.application.engine.mail.domain.MailDraft;
import com.netgrif.application.engine.mail.interfaces.IMailService;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class MailService
implements IMailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailService.class);
    public static final String TOKEN = "token";
    public static final String VALIDITY = "validity";
    public static final String EXPIRATION = "expiration";
    public static final String SERVER = "server";
    public static final String NAME = "name";
    @Value(value="${nae.mail.redirect-to.port}")
    protected String port;
    @Value(value="${nae.mail.redirect-to.host}")
    protected String domain;
    @Value(value="${nae.mail.redirect-to.ssl}")
    protected boolean ssl;
    @Value(value="${nae.mail.from}")
    protected String mailFrom;
    protected JavaMailSender mailSender;
    protected Configuration configuration;
    @Autowired
    private IRegistrationService registrationService;
    @Autowired
    private ServerAuthProperties serverAuthProperties;

    @Override
    public void sendRegistrationEmail(RegisteredUser user) throws MessagingException, IOException, TemplateException {
        LinkedList<String> recipients = new LinkedList<String>();
        HashMap<String, Object> model = new HashMap<String, Object>();
        recipients.add(user.getEmail());
        model.put(TOKEN, this.registrationService.encodeToken(user.getEmail(), user.getToken()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        model.put(VALIDITY, "" + this.serverAuthProperties.getTokenValidityPeriod());
        model.put(EXPIRATION, this.registrationService.generateExpirationDate().format(formatter));
        model.put(SERVER, this.getServerURL());
        MailDraft mailDraft = MailDraft.builder(this.mailFrom, recipients).subject(EmailType.REGISTRATION.getSubject()).body(this.configuration.getTemplate(EmailType.REGISTRATION.template).toString()).model(model).build();
        MimeMessage email = this.buildEmail(mailDraft);
        this.mailSender.send(email);
        log.info("Registration email sent to [" + user.getEmail() + "] with token [" + model.get(TOKEN) + "], expiring on [" + model.get(EXPIRATION) + "]");
    }

    @Override
    public void sendPasswordResetEmail(RegisteredUser user) throws MessagingException, IOException, TemplateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(NAME, user.getName());
        model.put(TOKEN, this.registrationService.encodeToken(user.getEmail(), user.getToken()));
        model.put(VALIDITY, "" + this.serverAuthProperties.getTokenValidityPeriod());
        model.put(EXPIRATION, this.registrationService.generateExpirationDate().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
        model.put(SERVER, this.getServerURL());
        MailDraft mailDraft = MailDraft.builder(this.mailFrom, Collections.singletonList(user.getEmail())).subject(EmailType.PASSWORD_RESET.getSubject()).body(this.configuration.getTemplate(EmailType.PASSWORD_RESET.template).toString()).model(model).build();
        MimeMessage email = this.buildEmail(mailDraft);
        this.mailSender.send(email);
        log.info("Reset email sent to [" + user.getEmail() + "] with token [" + model.get(TOKEN) + "], expiring on [" + model.get(EXPIRATION) + "]");
    }

    @Override
    public void testConnection() {
    }

    @Override
    public void sendMail(MailDraft mailDraft) throws MessagingException, IOException, TemplateException {
        MimeMessage email = this.buildEmail(mailDraft);
        this.mailSender.send(email);
        String formattedRecipients = StringUtils.join(mailDraft.getTo(), (String)", ");
        log.info("Email sent to [" + formattedRecipients + "]");
    }

    protected MimeMessage buildEmail(MailDraft draft) throws MessagingException, IOException, TemplateException {
        MimeMessage message = this.mailSender.createMimeMessage();
        message.setSubject(draft.getSubject());
        MimeMessageHelper helper = new MimeMessageHelper(message, true, StandardCharsets.UTF_8.name());
        helper.setFrom(draft.getFrom());
        helper.setTo(draft.getTo().toArray(new String[draft.getTo().size()]));
        helper.setCc(draft.getCc().toArray(new String[draft.getCc().size()]));
        helper.setBcc(draft.getBcc().toArray(new String[draft.getBcc().size()]));
        helper.setSubject(draft.getSubject());
        if (!draft.getModel().isEmpty()) {
            Template template = new Template("mailTemplate", (Reader)new StringReader(draft.getBody()), this.configuration);
            helper.setText(FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, draft.getModel()), true);
        } else {
            helper.setText(draft.getBody(), draft.isHtml());
        }
        draft.getAttachments().forEach((s, inputStream) -> {
            try {
                helper.addAttachment(s, inputStream);
            }
            catch (MessagingException e) {
                log.error("Building email failed: ", (Throwable)e);
            }
        });
        return message;
    }

    protected String getServerURL() {
        String encryptedHttp = this.ssl ? "https://" : "http://";
        String usedPort = this.port != null && !this.port.isEmpty() ? ":" + this.port : "";
        return encryptedHttp + this.domain + usedPort;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public boolean isSsl() {
        return this.ssl;
    }

    @Generated
    public String getMailFrom() {
        return this.mailFrom;
    }

    @Generated
    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    @Generated
    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

