/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.manager.service;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.manager.service.interfaces.ISessionManagerService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.stereotype.Service;

@Service
public class SessionManagerService
implements ISessionManagerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManagerService.class);
    protected final RedisIndexedSessionRepository repository;
    protected final SessionRegistry sessionRegistry;
    protected final String redisUsernameKey;

    public SessionManagerService(RedisIndexedSessionRepository repository, SessionRegistry sessionRegistry, @Value(value="${spring.session.redis.namespace}") String redisNamespace) {
        this.repository = repository;
        this.sessionRegistry = sessionRegistry;
        this.redisUsernameKey = "spring:session:" + redisNamespace + ":index:org.springframework.session.FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME:";
    }

    public List<LoggedUser> getAllLoggedUsers() {
        RedisOperations redisOps = this.repository.getSessionRedisOperations();
        if (redisOps == null) {
            throw new IllegalStateException("Redis session management is not configured!");
        }
        ArrayList<LoggedUser> activeUsers = new ArrayList<LoggedUser>();
        Set keys = redisOps.keys((Object)(this.redisUsernameKey + "*"));
        if (keys == null || keys.isEmpty()) {
            return activeUsers;
        }
        keys.forEach(username -> {
            LoggedUser user;
            SecurityContextImpl impl;
            Session session = this.repository.findByPrincipalName(username.toString().replace(this.redisUsernameKey, "")).values().stream().findFirst().orElse(null);
            if (session != null && (impl = (SecurityContextImpl)session.getAttribute("SPRING_SECURITY_CONTEXT")) != null && (user = (LoggedUser)((Object)((Object)impl.getAuthentication().getPrincipal()))) != null) {
                activeUsers.add(user);
            }
        });
        return activeUsers;
    }

    @Override
    public void logoutSessionByUsername(String username) {
        this.repository.findByPrincipalName(username).keySet().forEach(arg_0 -> ((RedisIndexedSessionRepository)this.repository).deleteById(arg_0));
    }

    @Override
    public void logoutAllSession() {
        Collection users = this.getAllLoggedUsers();
        users.forEach(loggedUser -> this.repository.findByPrincipalName(loggedUser.getEmail()).keySet().forEach(arg_0 -> ((RedisIndexedSessionRepository)this.repository).deleteById(arg_0)));
    }
}

