/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.manager.web;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.manager.service.interfaces.ISessionManagerService;
import com.netgrif.application.engine.manager.web.body.request.LogoutRequest;
import com.netgrif.application.engine.manager.web.body.response.AllLoggedUsersResponse;
import com.netgrif.application.engine.manager.web.body.response.MessageLogoutResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/manager/session"})
@ConditionalOnProperty(value={"nae.session.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="Session Manager")
public class SessionManagerController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManagerController.class);
    @Autowired
    private ISessionManagerService sessionManagerService;

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Get All logged users", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/all"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public AllLoggedUsersResponse getAllSessions() {
        Collection<LoggedUser> loggedUsers = this.sessionManagerService.getAllLoggedUsers();
        return new AllLoggedUsersResponse(loggedUsers);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Logout current user", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/logout"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public MessageLogoutResponse logoutCurrentSession(@RequestBody LogoutRequest requestBody) {
        requestBody.getUsers().forEach(user -> this.sessionManagerService.logoutSessionByUsername((String)user));
        return new MessageLogoutResponse(true);
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @Operation(summary="Logout all user", description="Caller must have the ADMIN role", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/logout/all"}, produces={"application/hal+json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    public MessageLogoutResponse logoutAllSession() {
        this.sessionManagerService.logoutAllSession();
        return new MessageLogoutResponse(true);
    }
}

