/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.orgstructure.groups;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.RegisteredUser;
import com.netgrif.application.engine.auth.service.interfaces.IRegistrationService;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.auth.web.requestbodies.NewUserRequest;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticCaseService;
import com.netgrif.application.engine.elastic.web.requestbodies.CaseSearchRequest;
import com.netgrif.application.engine.mail.interfaces.IMailAttemptService;
import com.netgrif.application.engine.mail.interfaces.IMailService;
import com.netgrif.application.engine.orgstructure.groups.interfaces.INextGroupService;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.throwable.TransitionNotExecutableException;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import com.netgrif.application.engine.startup.ImportHelper;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.QCase;
import com.netgrif.application.engine.workflow.domain.QDataField;
import com.netgrif.application.engine.workflow.domain.Task;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.caseoutcomes.CreateCaseEventOutcome;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import com.netgrif.application.engine.workflow.web.responsebodies.TaskReference;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.bson.types.QObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class NextGroupService
implements INextGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NextGroupService.class);
    @Autowired
    protected IWorkflowService workflowService;
    @Autowired
    protected IMailService mailService;
    @Autowired
    protected IMailAttemptService mailAttemptService;
    @Autowired
    protected IUserService userService;
    @Autowired
    protected IDataService dataService;
    @Autowired
    protected IRegistrationService registrationService;
    @Autowired
    protected IPetriNetService petriNetService;
    @Autowired
    protected ITaskService taskService;
    @Autowired
    protected IElasticCaseService elasticCaseService;
    @Autowired
    protected ISecurityContextService securityContextService;
    protected static final String GROUP_NET_IDENTIFIER = "org_group";
    protected static final String GROUP_INIT_TASK_ID = "2";
    protected static final String GROUP_CASE_IDENTIFIER = "org_group";
    protected static final String GROUP_MEMBERS_FIELD = "members";
    protected static final String GROUP_AUTHOR_FIELD = "author";
    protected static final String GROUP_TITLE_FIELD = "group_name";

    @Override
    public CreateCaseEventOutcome createDefaultSystemGroup(IUser author) {
        if (this.findDefaultGroup() != null) {
            log.info("Default system group has already been created.");
            return null;
        }
        return this.createGroup("Default system group", author);
    }

    @Override
    public CreateCaseEventOutcome createGroup(IUser author) {
        return this.createGroup(author.getFullName(), author);
    }

    @Override
    public CreateCaseEventOutcome createGroup(String title, IUser author) {
        Case userDefaultGroup = this.findUserDefaultGroup(author);
        if (userDefaultGroup != null && userDefaultGroup.getTitle().equals(title)) {
            return null;
        }
        PetriNet orgGroupNet = this.petriNetService.getNewestVersionByIdentifier("org_group");
        CreateCaseEventOutcome outcome = this.workflowService.createCase(orgGroupNet.getStringId(), title, "", author.transformToLoggedUser());
        Map<String, Map<String, String>> taskData = this.getInitialGroupData(author, title, outcome.getCase());
        Task initTask = this.getGroupInitTask(outcome.getCase());
        this.dataService.setData(initTask.getStringId(), ImportHelper.populateDataset(taskData));
        try {
            this.taskService.assignTask(author.transformToLoggedUser(), initTask.getStringId());
            this.taskService.finishTask(author.transformToLoggedUser(), initTask.getStringId());
        }
        catch (TransitionNotExecutableException e) {
            log.error(e.getMessage());
        }
        author.addGroup(outcome.getCase().getStringId());
        this.userService.save(author);
        return outcome;
    }

    @Override
    public Case findGroup(String groupID) {
        Case result = this.workflowService.searchOne((Predicate)NextGroupService.groupCase().and((Predicate)QCase.case$._id.eq(new ObjectId(groupID))));
        if (!this.isGroupCase(result)) {
            return null;
        }
        return result;
    }

    @Override
    public Case findDefaultGroup() {
        return this.findByName("Default system group");
    }

    @Override
    public Case findByName(String name) {
        CaseSearchRequest request = new CaseSearchRequest();
        request.query = "title.keyword:\"" + name + "\"";
        List result = this.elasticCaseService.search(Collections.singletonList(request), this.userService.getSystem().transformToLoggedUser(), (Pageable)PageRequest.of((int)0, (int)1), LocaleContextHolder.getLocale(), false).getContent();
        return !result.isEmpty() ? (Case)result.get(0) : null;
    }

    @Override
    public List<Case> findByPredicate(Predicate predicate) {
        return this.workflowService.searchAll(predicate).getContent();
    }

    @Override
    public List<Case> findByIds(Collection<String> groupIds) {
        List<BooleanExpression> groupQueries = groupIds.stream().map(ObjectId::new).map(arg_0 -> ((QObjectId)QCase.case$._id).eq(arg_0)).collect(Collectors.toList());
        BooleanBuilder builder = new BooleanBuilder();
        groupQueries.forEach(arg_0 -> ((BooleanBuilder)builder).or(arg_0));
        return this.workflowService.searchAll((Predicate)NextGroupService.groupCase().and((Predicate)builder)).getContent();
    }

    @Override
    public List<Case> findAllGroups() {
        return this.workflowService.searchAll((Predicate)NextGroupService.groupCase()).getContent();
    }

    @Override
    public Map<String, I18nString> inviteUser(String email, Map<String, I18nString> existingUsers, Case groupCase) {
        if (!this.isGroupCase(groupCase)) {
            return null;
        }
        IUser user = this.userService.findByEmail(email, true);
        if (user != null && user.isActive()) {
            log.info("User [" + user.getFullName() + "] has already been registered.");
            user.addGroup(groupCase.getStringId());
            this.userService.save(user);
            return this.addUser(user, existingUsers);
        }
        log.info("Inviting new user to group.");
        NewUserRequest newUserRequest = new NewUserRequest();
        newUserRequest.email = email;
        RegisteredUser regUser = this.registrationService.createNewUser(newUserRequest);
        regUser.addGroup(groupCase.getStringId());
        this.userService.save(regUser);
        try {
            this.mailService.sendRegistrationEmail(regUser);
            this.mailAttemptService.mailAttempt(newUserRequest.email);
        }
        catch (TemplateException | IOException | MessagingException e) {
            log.error(e.getMessage());
        }
        return this.addUser((IUser)regUser, existingUsers);
    }

    @Override
    public void addUserToDefaultGroup(IUser user) {
        this.addUser(user, this.findDefaultGroup());
    }

    @Override
    public void addUser(IUser user, String groupId) {
        Case groupCase = this.findGroup(groupId);
        if (groupCase != null) {
            this.addUser(user, groupCase);
        }
    }

    @Override
    public void addUser(IUser user, Case groupCase) {
        Map<String, I18nString> existingUsers = groupCase.getDataField(GROUP_MEMBERS_FIELD).getOptions();
        if (existingUsers == null) {
            existingUsers = new HashMap<String, I18nString>();
        }
        groupCase.getDataField(GROUP_MEMBERS_FIELD).setOptions(this.addUser(user, existingUsers));
        this.workflowService.save(groupCase);
        user.addGroup(groupCase.getStringId());
        this.userService.save(user);
        this.securityContextService.saveToken(user.getStringId());
    }

    @Override
    public Map<String, I18nString> addUser(IUser user, Map<String, I18nString> existingUsers) {
        existingUsers.put(user.getStringId(), new I18nString(user.getEmail()));
        return existingUsers;
    }

    @Override
    public void removeUser(IUser user, Case groupCase) {
        HashSet<String> userIds = new HashSet<String>();
        Map<String, I18nString> existingUsers = groupCase.getDataField(GROUP_MEMBERS_FIELD).getOptions();
        userIds.add(user.getStringId());
        groupCase.getDataField(GROUP_MEMBERS_FIELD).setOptions(this.removeUser(userIds, existingUsers, groupCase));
        this.workflowService.save(groupCase);
    }

    @Override
    public Map<String, I18nString> removeUser(HashSet<String> usersToRemove, Map<String, I18nString> existingUsers, Case groupCase) {
        String authorId = this.getGroupOwnerId(groupCase);
        usersToRemove.forEach(user -> {
            if (user.equals(authorId)) {
                log.error("Author with id [" + authorId + "] cannot be removed from group with ID [" + groupCase.get_id().toString() + "]");
            } else {
                existingUsers.remove(user);
                this.securityContextService.saveToken((String)user);
            }
        });
        this.userService.findAllByIds(usersToRemove, false).forEach(user -> {
            if (!user.getStringId().equals(authorId)) {
                user.getNextGroups().remove(groupCase.getStringId());
                this.userService.save((IUser)user);
            }
        });
        return existingUsers;
    }

    @Override
    public Set<String> getAllCoMembers(IUser user) {
        Set users = this.workflowService.searchAll((Predicate)NextGroupService.groupCase().and((Predicate)((QDataField)QCase.case$.dataSet.get((Object)GROUP_MEMBERS_FIELD)).options.containsKey((Object)user.getStringId()))).map(it -> it.getDataSet().get(GROUP_MEMBERS_FIELD).getOptions().keySet()).stream().collect(HashSet::new, Set::addAll, Set::addAll);
        users.remove(user.getStringId());
        users.remove(this.userService.getSystem().getStringId());
        return users;
    }

    @Override
    public List<IUser> getMembers(Case groupCase) {
        if (!this.isGroupCase(groupCase)) {
            return null;
        }
        Set<String> userIds = groupCase.getDataSet().get(GROUP_MEMBERS_FIELD).getOptions().keySet();
        ArrayList<IUser> resultList = new ArrayList<IUser>();
        userIds.forEach(id -> resultList.add(this.userService.resolveById((String)id, true)));
        return resultList;
    }

    @Override
    public Set<String> getAllGroupsOfUser(IUser groupUser) {
        List groupList = this.workflowService.searchAll((Predicate)NextGroupService.groupCase().and((Predicate)((QDataField)QCase.case$.dataSet.get((Object)GROUP_MEMBERS_FIELD)).options.containsKey((Object)groupUser.getStringId()))).map(aCase -> aCase.get_id().toString()).getContent();
        return new HashSet<String>(groupList);
    }

    @Override
    public String getGroupOwnerId(String groupId) {
        return this.getGroupOwnerId(this.findGroup(groupId));
    }

    @Override
    public Collection<String> getGroupsOwnerIds(Collection<String> groupIds) {
        return this.findByIds(groupIds).stream().map(this::getGroupOwnerId).collect(Collectors.toList());
    }

    @Override
    public String getGroupOwnerEmail(String groupId) {
        return this.getGroupOwnerEmail(this.findGroup(groupId));
    }

    @Override
    public Collection<String> getGroupsOwnerEmails(Collection<String> groupIds) {
        return this.findByIds(groupIds).stream().map(this::getGroupOwnerEmail).collect(Collectors.toList());
    }

    protected static BooleanExpression groupCase() {
        return QCase.case$.processIdentifier.eq((Object)"org_group");
    }

    protected boolean isGroupCase(Case aCase) {
        if (aCase == null) {
            log.error("The input case is a null object.");
            return false;
        }
        if (!aCase.getProcessIdentifier().equals("org_group")) {
            log.error("Case [" + aCase.getTitle() + "] is not an organization group case.");
            return false;
        }
        return true;
    }

    protected boolean authorHasDefaultGroup(IUser author) {
        List<Case> allGroups = this.findAllGroups();
        for (Case group : allGroups) {
            if (!group.getAuthor().getId().equals(author.getStringId())) continue;
            return true;
        }
        return false;
    }

    protected String getGroupOwnerId(Case groupCase) {
        return groupCase.getAuthor().getId();
    }

    protected Case findUserDefaultGroup(IUser author) {
        return this.workflowService.searchOne((Predicate)QCase.case$.author.id.eq((Object)author.getStringId()).and((Predicate)QCase.case$.title.eq((Object)author.getFullName())));
    }

    protected Task getGroupInitTask(Case groupCase) {
        List<TaskReference> taskList = this.taskService.findAllByCase(groupCase.getStringId(), LocaleContextHolder.getLocale());
        Optional<TaskReference> initTaskReference = taskList.stream().filter(taskReference -> taskReference.getTransitionId().equals(GROUP_INIT_TASK_ID)).findFirst();
        if (initTaskReference.isEmpty()) {
            log.error("Initial task of group case is not present!");
            return null;
        }
        String initTaskId = initTaskReference.get().getStringId();
        return this.taskService.findById(initTaskId);
    }

    protected Map<String, Map<String, String>> getInitialGroupData(IUser author, String title, Case groupCase) {
        HashMap<String, Map<String, String>> taskData = new HashMap<String, Map<String, String>>();
        groupCase.getDataField(GROUP_MEMBERS_FIELD).setOptions(this.addUser(author, new HashMap<String, I18nString>()));
        this.workflowService.save(groupCase);
        HashMap<String, String> authorData = new HashMap<String, String>();
        authorData.put("type", "user");
        authorData.put("value", author.getStringId());
        HashMap<String, String> titleData = new HashMap<String, String>();
        titleData.put("type", "text");
        titleData.put("value", title);
        taskData.put(GROUP_TITLE_FIELD, titleData);
        taskData.put(GROUP_AUTHOR_FIELD, authorData);
        return taskData;
    }

    protected String getGroupOwnerEmail(Case groupCase) {
        return groupCase.getAuthor().getEmail();
    }
}

