/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.config;

import com.netgrif.application.engine.pdf.generator.config.types.PdfBooleanFormat;
import com.netgrif.application.engine.pdf.generator.config.types.PdfDateFormat;
import com.netgrif.application.engine.pdf.generator.config.types.PdfPageNumberFormat;
import java.time.ZoneId;
import java.util.Locale;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="nae.pdf.properties")
@Component
public class PdfProperties {
    protected int unit = 20;
    protected PDRectangle pageSize = PDRectangle.A4;
    protected int pageWidth = 600;
    protected int pageHeight = 820;
    protected int lineHeight = 17;
    protected int marginTitle = 0;
    protected int marginTop = this.unit;
    protected int marginBottom = 4 * this.unit;
    protected int marginLeft = (int)(0.5 * (double)this.unit);
    protected int marginRight = (int)(0.5 * (double)this.unit);
    protected int padding = 4;
    protected int boxPadding = 2;
    protected String colorString = "#666666";
    protected String colorLabelString = "#888888";
    protected String colorDataGroup = "#2297F2";
    protected int baseX = this.marginLeft;
    protected int baseY;
    protected int pageDrawableWidth = this.pageWidth - this.marginLeft - this.marginRight;
    protected int fontTitleSize = 13;
    protected int fontGroupSize = 13;
    protected int fontLabelSize = 10;
    protected int fontValueSize = 10;
    protected int formGridCols = 4;
    protected int formGridRows = 30;
    protected int formGridColWidth = this.pageDrawableWidth / this.formGridCols;
    protected int formGridRowHeight = (this.pageHeight - this.marginBottom - this.marginTop) / this.formGridRows;
    protected int rowGridFree = this.formGridCols;
    protected float strokeWidth = 0.5f;
    protected int boxSize = 10;
    protected float sizeMultiplier = 1.65f;
    protected int pageNumberPosition = (int)(0.5 * (double)this.pageWidth);
    protected String documentTitle = "";
    protected boolean textFieldStroke = true;
    protected boolean booleanFieldStroke = false;
    protected PdfDateFormat dateFormat = PdfDateFormat.SLOVAK1;
    protected PdfDateFormat dateTimeFormat = PdfDateFormat.SLOVAK1_DATETIME;
    protected Locale numberFormat = new Locale("sk", "SK");
    protected Locale textLocale = new Locale("sk", "SK");
    protected ZoneId dateZoneId = ZoneId.systemDefault();
    protected PdfBooleanFormat booleanFormat = PdfBooleanFormat.DOUBLE_BOX_WITH_TEXT_SK;
    protected PdfPageNumberFormat pageNumberFormat = PdfPageNumberFormat.SLASH;

    public void updateProperties() {
        this.pageDrawableWidth = this.pageWidth - this.marginLeft - this.marginRight;
        this.formGridColWidth = this.pageDrawableWidth / this.formGridCols;
        this.formGridRowHeight = (this.pageHeight - this.marginBottom - this.marginTop) / this.formGridRows;
        this.rowGridFree = this.formGridCols;
        this.baseX = this.marginLeft;
    }

    @Generated
    public PdfProperties() {
    }

    @Generated
    public int getUnit() {
        return this.unit;
    }

    @Generated
    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    @Generated
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Generated
    public int getPageHeight() {
        return this.pageHeight;
    }

    @Generated
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Generated
    public int getMarginTitle() {
        return this.marginTitle;
    }

    @Generated
    public int getMarginTop() {
        return this.marginTop;
    }

    @Generated
    public int getMarginBottom() {
        return this.marginBottom;
    }

    @Generated
    public int getMarginLeft() {
        return this.marginLeft;
    }

    @Generated
    public int getMarginRight() {
        return this.marginRight;
    }

    @Generated
    public int getPadding() {
        return this.padding;
    }

    @Generated
    public int getBoxPadding() {
        return this.boxPadding;
    }

    @Generated
    public String getColorString() {
        return this.colorString;
    }

    @Generated
    public String getColorLabelString() {
        return this.colorLabelString;
    }

    @Generated
    public String getColorDataGroup() {
        return this.colorDataGroup;
    }

    @Generated
    public int getBaseX() {
        return this.baseX;
    }

    @Generated
    public int getBaseY() {
        return this.baseY;
    }

    @Generated
    public int getPageDrawableWidth() {
        return this.pageDrawableWidth;
    }

    @Generated
    public int getFontTitleSize() {
        return this.fontTitleSize;
    }

    @Generated
    public int getFontGroupSize() {
        return this.fontGroupSize;
    }

    @Generated
    public int getFontLabelSize() {
        return this.fontLabelSize;
    }

    @Generated
    public int getFontValueSize() {
        return this.fontValueSize;
    }

    @Generated
    public int getFormGridCols() {
        return this.formGridCols;
    }

    @Generated
    public int getFormGridRows() {
        return this.formGridRows;
    }

    @Generated
    public int getFormGridColWidth() {
        return this.formGridColWidth;
    }

    @Generated
    public int getFormGridRowHeight() {
        return this.formGridRowHeight;
    }

    @Generated
    public int getRowGridFree() {
        return this.rowGridFree;
    }

    @Generated
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Generated
    public int getBoxSize() {
        return this.boxSize;
    }

    @Generated
    public float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    @Generated
    public int getPageNumberPosition() {
        return this.pageNumberPosition;
    }

    @Generated
    public String getDocumentTitle() {
        return this.documentTitle;
    }

    @Generated
    public boolean isTextFieldStroke() {
        return this.textFieldStroke;
    }

    @Generated
    public boolean isBooleanFieldStroke() {
        return this.booleanFieldStroke;
    }

    @Generated
    public PdfDateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public PdfDateFormat getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Generated
    public Locale getNumberFormat() {
        return this.numberFormat;
    }

    @Generated
    public Locale getTextLocale() {
        return this.textLocale;
    }

    @Generated
    public ZoneId getDateZoneId() {
        return this.dateZoneId;
    }

    @Generated
    public PdfBooleanFormat getBooleanFormat() {
        return this.booleanFormat;
    }

    @Generated
    public PdfPageNumberFormat getPageNumberFormat() {
        return this.pageNumberFormat;
    }

    @Generated
    public void setUnit(int unit) {
        this.unit = unit;
    }

    @Generated
    public void setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    @Generated
    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    @Generated
    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    @Generated
    public void setMarginTitle(int marginTitle) {
        this.marginTitle = marginTitle;
    }

    @Generated
    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    @Generated
    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    @Generated
    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    @Generated
    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    @Generated
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Generated
    public void setBoxPadding(int boxPadding) {
        this.boxPadding = boxPadding;
    }

    @Generated
    public void setColorString(String colorString) {
        this.colorString = colorString;
    }

    @Generated
    public void setColorLabelString(String colorLabelString) {
        this.colorLabelString = colorLabelString;
    }

    @Generated
    public void setColorDataGroup(String colorDataGroup) {
        this.colorDataGroup = colorDataGroup;
    }

    @Generated
    public void setBaseX(int baseX) {
        this.baseX = baseX;
    }

    @Generated
    public void setBaseY(int baseY) {
        this.baseY = baseY;
    }

    @Generated
    public void setPageDrawableWidth(int pageDrawableWidth) {
        this.pageDrawableWidth = pageDrawableWidth;
    }

    @Generated
    public void setFontTitleSize(int fontTitleSize) {
        this.fontTitleSize = fontTitleSize;
    }

    @Generated
    public void setFontGroupSize(int fontGroupSize) {
        this.fontGroupSize = fontGroupSize;
    }

    @Generated
    public void setFontLabelSize(int fontLabelSize) {
        this.fontLabelSize = fontLabelSize;
    }

    @Generated
    public void setFontValueSize(int fontValueSize) {
        this.fontValueSize = fontValueSize;
    }

    @Generated
    public void setFormGridCols(int formGridCols) {
        this.formGridCols = formGridCols;
    }

    @Generated
    public void setFormGridRows(int formGridRows) {
        this.formGridRows = formGridRows;
    }

    @Generated
    public void setFormGridColWidth(int formGridColWidth) {
        this.formGridColWidth = formGridColWidth;
    }

    @Generated
    public void setFormGridRowHeight(int formGridRowHeight) {
        this.formGridRowHeight = formGridRowHeight;
    }

    @Generated
    public void setRowGridFree(int rowGridFree) {
        this.rowGridFree = rowGridFree;
    }

    @Generated
    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Generated
    public void setBoxSize(int boxSize) {
        this.boxSize = boxSize;
    }

    @Generated
    public void setSizeMultiplier(float sizeMultiplier) {
        this.sizeMultiplier = sizeMultiplier;
    }

    @Generated
    public void setPageNumberPosition(int pageNumberPosition) {
        this.pageNumberPosition = pageNumberPosition;
    }

    @Generated
    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    @Generated
    public void setTextFieldStroke(boolean textFieldStroke) {
        this.textFieldStroke = textFieldStroke;
    }

    @Generated
    public void setBooleanFieldStroke(boolean booleanFieldStroke) {
        this.booleanFieldStroke = booleanFieldStroke;
    }

    @Generated
    public void setDateFormat(PdfDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Generated
    public void setDateTimeFormat(PdfDateFormat dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    @Generated
    public void setNumberFormat(Locale numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Generated
    public void setTextLocale(Locale textLocale) {
        this.textLocale = textLocale;
    }

    @Generated
    public void setDateZoneId(ZoneId dateZoneId) {
        this.dateZoneId = dateZoneId;
    }

    @Generated
    public void setBooleanFormat(PdfBooleanFormat booleanFormat) {
        this.booleanFormat = booleanFormat;
    }

    @Generated
    public void setPageNumberFormat(PdfPageNumberFormat pageNumberFormat) {
        this.pageNumberFormat = pageNumberFormat;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfProperties)) {
            return false;
        }
        PdfProperties other = (PdfProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUnit() != other.getUnit()) {
            return false;
        }
        if (this.getPageWidth() != other.getPageWidth()) {
            return false;
        }
        if (this.getPageHeight() != other.getPageHeight()) {
            return false;
        }
        if (this.getLineHeight() != other.getLineHeight()) {
            return false;
        }
        if (this.getMarginTitle() != other.getMarginTitle()) {
            return false;
        }
        if (this.getMarginTop() != other.getMarginTop()) {
            return false;
        }
        if (this.getMarginBottom() != other.getMarginBottom()) {
            return false;
        }
        if (this.getMarginLeft() != other.getMarginLeft()) {
            return false;
        }
        if (this.getMarginRight() != other.getMarginRight()) {
            return false;
        }
        if (this.getPadding() != other.getPadding()) {
            return false;
        }
        if (this.getBoxPadding() != other.getBoxPadding()) {
            return false;
        }
        if (this.getBaseX() != other.getBaseX()) {
            return false;
        }
        if (this.getBaseY() != other.getBaseY()) {
            return false;
        }
        if (this.getPageDrawableWidth() != other.getPageDrawableWidth()) {
            return false;
        }
        if (this.getFontTitleSize() != other.getFontTitleSize()) {
            return false;
        }
        if (this.getFontGroupSize() != other.getFontGroupSize()) {
            return false;
        }
        if (this.getFontLabelSize() != other.getFontLabelSize()) {
            return false;
        }
        if (this.getFontValueSize() != other.getFontValueSize()) {
            return false;
        }
        if (this.getFormGridCols() != other.getFormGridCols()) {
            return false;
        }
        if (this.getFormGridRows() != other.getFormGridRows()) {
            return false;
        }
        if (this.getFormGridColWidth() != other.getFormGridColWidth()) {
            return false;
        }
        if (this.getFormGridRowHeight() != other.getFormGridRowHeight()) {
            return false;
        }
        if (this.getRowGridFree() != other.getRowGridFree()) {
            return false;
        }
        if (Float.compare(this.getStrokeWidth(), other.getStrokeWidth()) != 0) {
            return false;
        }
        if (this.getBoxSize() != other.getBoxSize()) {
            return false;
        }
        if (Float.compare(this.getSizeMultiplier(), other.getSizeMultiplier()) != 0) {
            return false;
        }
        if (this.getPageNumberPosition() != other.getPageNumberPosition()) {
            return false;
        }
        if (this.isTextFieldStroke() != other.isTextFieldStroke()) {
            return false;
        }
        if (this.isBooleanFieldStroke() != other.isBooleanFieldStroke()) {
            return false;
        }
        PDRectangle this$pageSize = this.getPageSize();
        PDRectangle other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !this$pageSize.equals(other$pageSize)) {
            return false;
        }
        String this$colorString = this.getColorString();
        String other$colorString = other.getColorString();
        if (this$colorString == null ? other$colorString != null : !this$colorString.equals(other$colorString)) {
            return false;
        }
        String this$colorLabelString = this.getColorLabelString();
        String other$colorLabelString = other.getColorLabelString();
        if (this$colorLabelString == null ? other$colorLabelString != null : !this$colorLabelString.equals(other$colorLabelString)) {
            return false;
        }
        String this$colorDataGroup = this.getColorDataGroup();
        String other$colorDataGroup = other.getColorDataGroup();
        if (this$colorDataGroup == null ? other$colorDataGroup != null : !this$colorDataGroup.equals(other$colorDataGroup)) {
            return false;
        }
        String this$documentTitle = this.getDocumentTitle();
        String other$documentTitle = other.getDocumentTitle();
        if (this$documentTitle == null ? other$documentTitle != null : !this$documentTitle.equals(other$documentTitle)) {
            return false;
        }
        PdfDateFormat this$dateFormat = this.getDateFormat();
        PdfDateFormat other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !((Object)((Object)this$dateFormat)).equals((Object)other$dateFormat)) {
            return false;
        }
        PdfDateFormat this$dateTimeFormat = this.getDateTimeFormat();
        PdfDateFormat other$dateTimeFormat = other.getDateTimeFormat();
        if (this$dateTimeFormat == null ? other$dateTimeFormat != null : !((Object)((Object)this$dateTimeFormat)).equals((Object)other$dateTimeFormat)) {
            return false;
        }
        Locale this$numberFormat = this.getNumberFormat();
        Locale other$numberFormat = other.getNumberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !((Object)this$numberFormat).equals(other$numberFormat)) {
            return false;
        }
        Locale this$textLocale = this.getTextLocale();
        Locale other$textLocale = other.getTextLocale();
        if (this$textLocale == null ? other$textLocale != null : !((Object)this$textLocale).equals(other$textLocale)) {
            return false;
        }
        ZoneId this$dateZoneId = this.getDateZoneId();
        ZoneId other$dateZoneId = other.getDateZoneId();
        if (this$dateZoneId == null ? other$dateZoneId != null : !((Object)this$dateZoneId).equals(other$dateZoneId)) {
            return false;
        }
        PdfBooleanFormat this$booleanFormat = this.getBooleanFormat();
        PdfBooleanFormat other$booleanFormat = other.getBooleanFormat();
        if (this$booleanFormat == null ? other$booleanFormat != null : !((Object)((Object)this$booleanFormat)).equals((Object)other$booleanFormat)) {
            return false;
        }
        PdfPageNumberFormat this$pageNumberFormat = this.getPageNumberFormat();
        PdfPageNumberFormat other$pageNumberFormat = other.getPageNumberFormat();
        return !(this$pageNumberFormat == null ? other$pageNumberFormat != null : !((Object)((Object)this$pageNumberFormat)).equals((Object)other$pageNumberFormat));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PdfProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUnit();
        result = result * 59 + this.getPageWidth();
        result = result * 59 + this.getPageHeight();
        result = result * 59 + this.getLineHeight();
        result = result * 59 + this.getMarginTitle();
        result = result * 59 + this.getMarginTop();
        result = result * 59 + this.getMarginBottom();
        result = result * 59 + this.getMarginLeft();
        result = result * 59 + this.getMarginRight();
        result = result * 59 + this.getPadding();
        result = result * 59 + this.getBoxPadding();
        result = result * 59 + this.getBaseX();
        result = result * 59 + this.getBaseY();
        result = result * 59 + this.getPageDrawableWidth();
        result = result * 59 + this.getFontTitleSize();
        result = result * 59 + this.getFontGroupSize();
        result = result * 59 + this.getFontLabelSize();
        result = result * 59 + this.getFontValueSize();
        result = result * 59 + this.getFormGridCols();
        result = result * 59 + this.getFormGridRows();
        result = result * 59 + this.getFormGridColWidth();
        result = result * 59 + this.getFormGridRowHeight();
        result = result * 59 + this.getRowGridFree();
        result = result * 59 + Float.floatToIntBits(this.getStrokeWidth());
        result = result * 59 + this.getBoxSize();
        result = result * 59 + Float.floatToIntBits(this.getSizeMultiplier());
        result = result * 59 + this.getPageNumberPosition();
        result = result * 59 + (this.isTextFieldStroke() ? 79 : 97);
        result = result * 59 + (this.isBooleanFieldStroke() ? 79 : 97);
        PDRectangle $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : $pageSize.hashCode());
        String $colorString = this.getColorString();
        result = result * 59 + ($colorString == null ? 43 : $colorString.hashCode());
        String $colorLabelString = this.getColorLabelString();
        result = result * 59 + ($colorLabelString == null ? 43 : $colorLabelString.hashCode());
        String $colorDataGroup = this.getColorDataGroup();
        result = result * 59 + ($colorDataGroup == null ? 43 : $colorDataGroup.hashCode());
        String $documentTitle = this.getDocumentTitle();
        result = result * 59 + ($documentTitle == null ? 43 : $documentTitle.hashCode());
        PdfDateFormat $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : ((Object)((Object)$dateFormat)).hashCode());
        PdfDateFormat $dateTimeFormat = this.getDateTimeFormat();
        result = result * 59 + ($dateTimeFormat == null ? 43 : ((Object)((Object)$dateTimeFormat)).hashCode());
        Locale $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : ((Object)$numberFormat).hashCode());
        Locale $textLocale = this.getTextLocale();
        result = result * 59 + ($textLocale == null ? 43 : ((Object)$textLocale).hashCode());
        ZoneId $dateZoneId = this.getDateZoneId();
        result = result * 59 + ($dateZoneId == null ? 43 : ((Object)$dateZoneId).hashCode());
        PdfBooleanFormat $booleanFormat = this.getBooleanFormat();
        result = result * 59 + ($booleanFormat == null ? 43 : ((Object)((Object)$booleanFormat)).hashCode());
        PdfPageNumberFormat $pageNumberFormat = this.getPageNumberFormat();
        result = result * 59 + ($pageNumberFormat == null ? 43 : ((Object)((Object)$pageNumberFormat)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PdfProperties(unit=" + this.getUnit() + ", pageSize=" + this.getPageSize() + ", pageWidth=" + this.getPageWidth() + ", pageHeight=" + this.getPageHeight() + ", lineHeight=" + this.getLineHeight() + ", marginTitle=" + this.getMarginTitle() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", padding=" + this.getPadding() + ", boxPadding=" + this.getBoxPadding() + ", colorString=" + this.getColorString() + ", colorLabelString=" + this.getColorLabelString() + ", colorDataGroup=" + this.getColorDataGroup() + ", baseX=" + this.getBaseX() + ", baseY=" + this.getBaseY() + ", pageDrawableWidth=" + this.getPageDrawableWidth() + ", fontTitleSize=" + this.getFontTitleSize() + ", fontGroupSize=" + this.getFontGroupSize() + ", fontLabelSize=" + this.getFontLabelSize() + ", fontValueSize=" + this.getFontValueSize() + ", formGridCols=" + this.getFormGridCols() + ", formGridRows=" + this.getFormGridRows() + ", formGridColWidth=" + this.getFormGridColWidth() + ", formGridRowHeight=" + this.getFormGridRowHeight() + ", rowGridFree=" + this.getRowGridFree() + ", strokeWidth=" + this.getStrokeWidth() + ", boxSize=" + this.getBoxSize() + ", sizeMultiplier=" + this.getSizeMultiplier() + ", pageNumberPosition=" + this.getPageNumberPosition() + ", documentTitle=" + this.getDocumentTitle() + ", textFieldStroke=" + this.isTextFieldStroke() + ", booleanFieldStroke=" + this.isBooleanFieldStroke() + ", dateFormat=" + this.getDateFormat() + ", dateTimeFormat=" + this.getDateTimeFormat() + ", numberFormat=" + this.getNumberFormat() + ", textLocale=" + this.getTextLocale() + ", dateZoneId=" + this.getDateZoneId() + ", booleanFormat=" + this.getBooleanFormat() + ", pageNumberFormat=" + this.getPageNumberFormat() + ")";
    }
}

