/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.domain;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.Renderer;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public abstract class PdfField
implements Comparable<PdfField> {
    protected String fieldId;
    protected DataGroup dataGroup;
    protected FieldType type;
    protected String label;
    protected List<String> values;
    protected int layoutX;
    protected int layoutY;
    protected int x;
    protected int originalTopY;
    protected int topY;
    protected Integer originalBottomY;
    protected int bottomY;
    protected int width;
    protected int height;
    protected boolean changedSize = false;
    protected boolean changedPosition = false;
    protected boolean dgField = false;
    protected PdfResource resource;
    protected Renderer renderer;

    public PdfField() {
    }

    public PdfField(PdfResource resource) {
        this();
        this.resource = resource;
    }

    public void countMultiLineHeight(int fontSize, PdfResource resource) {
        int padding = resource.getPadding();
        int lineHeight = resource.getLineHeight();
        int maxLabelLineLength = this.getMaxLabelLineSize(this.width, fontSize, padding);
        int maxValueLineLength = this.getMaxValueLineSize(this.width - 3 * padding, resource.getFontValueSize(), padding);
        int multiLineHeight = 0;
        List<String> splitLabel = FieldBuilder.generateMultiLineText(Collections.singletonList(this.label), maxLabelLineLength);
        multiLineHeight += splitLabel.size() * lineHeight + padding;
        if (this.values != null) {
            List<String> splitText = FieldBuilder.generateMultiLineText(this.values, maxValueLineLength);
            multiLineHeight += splitText.size() * lineHeight + padding;
        }
        this.changedSize = this.changeHeight(multiLineHeight);
    }

    protected boolean changeHeight(int multiLineHeight) {
        if (multiLineHeight <= this.height) {
            return false;
        }
        this.height = multiLineHeight;
        return true;
    }

    @Override
    public int compareTo(PdfField pdfField) {
        return this.getOriginalBottomY().compareTo(pdfField.getOriginalBottomY());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfField field = (PdfField)o;
        return this.fieldId == field.fieldId && this.type == field.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldId, this.type});
    }

    protected int getMaxLabelLineSize(int fieldWidth, int fontSize, int padding) {
        return (int)((float)(fieldWidth - padding) * this.resource.getSizeMultiplier() / (float)fontSize);
    }

    protected int getMaxValueLineSize(int fieldWidth, int fontSize, int padding) {
        return (int)((float)(fieldWidth - padding) * this.resource.getSizeMultiplier() / (float)fontSize);
    }

    @Generated
    public String getFieldId() {
        return this.fieldId;
    }

    @Generated
    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    @Generated
    public DataGroup getDataGroup() {
        return this.dataGroup;
    }

    @Generated
    public void setDataGroup(DataGroup dataGroup) {
        this.dataGroup = dataGroup;
    }

    @Generated
    public FieldType getType() {
        return this.type;
    }

    @Generated
    public void setType(FieldType type) {
        this.type = type;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }

    @Generated
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Generated
    public int getLayoutX() {
        return this.layoutX;
    }

    @Generated
    public void setLayoutX(int layoutX) {
        this.layoutX = layoutX;
    }

    @Generated
    public int getLayoutY() {
        return this.layoutY;
    }

    @Generated
    public void setLayoutY(int layoutY) {
        this.layoutY = layoutY;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public void setX(int x) {
        this.x = x;
    }

    @Generated
    public int getOriginalTopY() {
        return this.originalTopY;
    }

    @Generated
    public void setOriginalTopY(int originalTopY) {
        this.originalTopY = originalTopY;
    }

    @Generated
    public int getTopY() {
        return this.topY;
    }

    @Generated
    public void setTopY(int topY) {
        this.topY = topY;
    }

    @Generated
    public Integer getOriginalBottomY() {
        return this.originalBottomY;
    }

    @Generated
    public void setOriginalBottomY(Integer originalBottomY) {
        this.originalBottomY = originalBottomY;
    }

    @Generated
    public int getBottomY() {
        return this.bottomY;
    }

    @Generated
    public void setBottomY(int bottomY) {
        this.bottomY = bottomY;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public void setWidth(int width) {
        this.width = width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public void setHeight(int height) {
        this.height = height;
    }

    @Generated
    public boolean isChangedSize() {
        return this.changedSize;
    }

    @Generated
    public void setChangedSize(boolean changedSize) {
        this.changedSize = changedSize;
    }

    @Generated
    public boolean isChangedPosition() {
        return this.changedPosition;
    }

    @Generated
    public void setChangedPosition(boolean changedPosition) {
        this.changedPosition = changedPosition;
    }

    @Generated
    public boolean isDgField() {
        return this.dgField;
    }

    @Generated
    public void setDgField(boolean dgField) {
        this.dgField = dgField;
    }

    @Generated
    public PdfResource getResource() {
        return this.resource;
    }

    @Generated
    public void setResource(PdfResource resource) {
        this.resource = resource;
    }

    @Generated
    public Renderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }
}

