/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.domain;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public abstract class PdfSelectionField
extends PdfField {
    protected List<String> choices = null;

    public PdfSelectionField(PdfResource resource) {
        super(resource);
    }

    @Override
    public void countMultiLineHeight(int fontSize, PdfResource resource) {
        int padding = resource.getPadding();
        int lineHeight = resource.getLineHeight();
        int maxLabelLineLength = this.getMaxLabelLineSize(this.width, fontSize, padding);
        int maxValueLineLength = this.getMaxValueLineSize(this.width - 2 * padding, resource.getFontValueSize(), padding);
        int multiLineHeight = 0;
        List<String> splitLabel = FieldBuilder.generateMultiLineText(Collections.singletonList(this.label), maxLabelLineLength);
        multiLineHeight += splitLabel.size() * lineHeight + padding;
        if (this.choices != null) {
            List<String> splitText = FieldBuilder.generateMultiLineText(this.choices, maxValueLineLength);
            multiLineHeight += splitText.size() * lineHeight + padding;
        }
        this.changedSize = this.changeHeight(multiLineHeight);
    }

    @Generated
    public List<String> getChoices() {
        return this.choices;
    }

    @Generated
    public void setChoices(List<String> choices) {
        this.choices = choices;
    }
}

