/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.DataGroupFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.EnumerationFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.EnumerationMapFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.I18nDividerFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.MultiChoiceFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.MultiChoiceMapFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.TextFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.TitleFieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfDataHelper;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.QTask;
import com.netgrif.application.engine.workflow.service.interfaces.IDataService;
import com.netgrif.application.engine.workflow.service.interfaces.ITaskService;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedEnumerationField;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedEnumerationMapField;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedField;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedI18nStringField;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedMultichoiceField;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedMultichoiceMapField;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfDataHelper
implements IPdfDataHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfDataHelper.class);
    private static final String DIVIDER = "divider";
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IDataService dataService;
    private PetriNet petriNet;
    private String taskId;
    private List<DataGroup> dataGroups;
    private List<PdfField> pdfFields;
    private List<String> excludedFields;
    private PdfResource resource;
    private Stack<PdfField> changedPdfFields;
    private int lastX;
    private int lastY;
    private int originalCols;

    @Override
    public void setupDataHelper(PdfResource resource) {
        log.info("Setting up data helper for PDF generator...");
        this.resource = resource;
        this.pdfFields = new ArrayList<PdfField>();
        this.dataGroups = new ArrayList<DataGroup>();
        this.changedPdfFields = new Stack();
        this.excludedFields = new ArrayList<String>();
    }

    @Override
    public void setTaskId(Case useCase, Transition transition) {
        if (transition.getLayout() != null && transition.getLayout().getCols() != null) {
            this.resource.setFormGridCols(transition.getLayout().getCols());
        }
        QTask qTask = new QTask("task");
        this.taskId = this.taskService.searchOne((Predicate)qTask.transitionId.eq((Object)transition.getStringId()).and((Predicate)qTask.caseId.eq((Object)useCase.get_id().toString()))).getStringId();
        this.originalCols = this.resource.getFormGridCols();
    }

    @Override
    public void generateTitleField() {
        log.info("Setting title field for PDF");
        this.resource.setBaseY(this.resource.getPageHeight() - this.resource.getMarginTitle());
        PdfField titleField = new TitleFieldBuilder(this.resource).createTitleField();
        this.pdfFields.add(titleField);
        this.resource.setBaseY(this.resource.getBaseY() - titleField.getHeight());
    }

    @Override
    public void generatePdfFields() {
        log.info("Generating PDF fields from data fields.");
        this.lastX = Integer.MAX_VALUE;
        this.lastY = 0;
        this.dataGroups = this.dataService.getDataGroups(this.taskId, this.resource.getTextLocale()).getData();
        this.dataGroups.forEach(dataGroup -> {
            if (dataGroup.getParentTaskRefId() == null) {
                this.refreshGrid((DataGroup)dataGroup);
                this.generateFromDataGroup((DataGroup)dataGroup);
                this.lastX = Integer.MAX_VALUE;
            }
        });
        Collections.sort(this.pdfFields);
    }

    private void generateFromDataGroup(DataGroup dataGroup) {
        Collection fields = dataGroup.getFields().getContent();
        if (dataGroup.getLayout() != null && dataGroup.getLayout().getType() != null && dataGroup.getLayout().getType().equals("grid")) {
            fields = fields.stream().sorted(Comparator.comparing(f -> f.getLayout().getY()).thenComparing(f -> f.getLayout().getX())).collect(Collectors.toList());
        }
        fields.forEach(field -> {
            if (field.getType().equals((Object)FieldType.TASK_REF)) {
                Optional<DataGroup> taskRefGroup = this.dataGroups.stream().filter(dg -> Objects.equals(dg.getParentTaskRefId(), field.getStringId())).findFirst();
                taskRefGroup.ifPresent(this::generateFromDataGroup);
            } else {
                this.generateField(dataGroup, (LocalisedField)field);
            }
        });
    }

    @Override
    public void correctFieldsPosition() {
        log.info("Correcting field positions for correct export to PDF.");
        this.pdfFields.forEach(pdfField -> {
            if (pdfField.isChangedSize()) {
                pdfField.setBottomY(this.updateBottomY((PdfField)pdfField));
                this.changedPdfFields.push((PdfField)pdfField);
            }
        });
        while (!this.changedPdfFields.empty()) {
            PdfField pdfField2 = this.changedPdfFields.pop();
            if (pdfField2.isChangedSize()) {
                this.shiftFields(pdfField2);
            }
            if (!pdfField2.isChangedPosition()) continue;
            this.shiftFields(pdfField2);
        }
    }

    protected void generateField(DataGroup dataGroup, LocalisedField field) {
        if (this.isNotHidden(field) && this.isNotExcluded(field.getStringId())) {
            PdfField pdfField = null;
            switch (field.getType()) {
                case BUTTON: 
                case TASK_REF: {
                    break;
                }
                case ENUMERATION_MAP: {
                    pdfField = this.createEnumMapField(dataGroup, (LocalisedEnumerationMapField)field);
                    this.pdfFields.add(pdfField);
                    break;
                }
                case ENUMERATION: {
                    pdfField = this.createEnumField(dataGroup, (LocalisedEnumerationField)field);
                    this.pdfFields.add(pdfField);
                    break;
                }
                case MULTICHOICE_MAP: {
                    pdfField = this.createMultiChoiceMapField(dataGroup, (LocalisedMultichoiceMapField)field);
                    this.pdfFields.add(pdfField);
                    break;
                }
                case MULTICHOICE: {
                    pdfField = this.createMultiChoiceField(dataGroup, (LocalisedMultichoiceField)field);
                    this.pdfFields.add(pdfField);
                    break;
                }
                case I18N: {
                    if (field.getComponent() == null || !Objects.equals(field.getComponent().getName(), DIVIDER)) break;
                    pdfField = this.createI18nDividerField(dataGroup, (LocalisedI18nStringField)field);
                    this.pdfFields.add(pdfField);
                    break;
                }
                default: {
                    pdfField = this.createPdfTextField(dataGroup, field);
                    this.pdfFields.add(pdfField);
                }
            }
            if (pdfField != null) {
                this.generatePdfDataGroup(dataGroup, pdfField);
            }
        }
    }

    protected PdfField createPdfTextField(DataGroup dataGroup, LocalisedField field) {
        TextFieldBuilder builder = new TextFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected PdfField createEnumField(DataGroup dataGroup, LocalisedEnumerationField field) {
        EnumerationFieldBuilder builder = new EnumerationFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected PdfField createMultiChoiceField(DataGroup dataGroup, LocalisedMultichoiceField field) {
        MultiChoiceFieldBuilder builder = new MultiChoiceFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected PdfField createEnumMapField(DataGroup dataGroup, LocalisedEnumerationMapField field) {
        EnumerationMapFieldBuilder builder = new EnumerationMapFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected PdfField createMultiChoiceMapField(DataGroup dataGroup, LocalisedMultichoiceMapField field) {
        MultiChoiceMapFieldBuilder builder = new MultiChoiceMapFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected PdfField createI18nDividerField(DataGroup dataGroup, LocalisedI18nStringField field) {
        I18nDividerFieldBuilder builder = new I18nDividerFieldBuilder(this.resource);
        PdfField pdfField = builder.buildField(dataGroup, field, this.lastX, this.lastY);
        this.updateLastCoordinates(builder.getLastX(), builder.getLastY());
        return pdfField;
    }

    protected void updateLastCoordinates(int lastX, int lastY) {
        this.lastX = lastX;
        this.lastY = lastY;
    }

    protected int updateBottomY(PdfField pdfField) {
        return FieldBuilder.countBottomPosY(pdfField, pdfField.getResource());
    }

    protected void shiftFields(PdfField currentField) {
        this.pdfFields.forEach(field -> {
            if (currentField != field) {
                this.shiftField(currentField, (PdfField)field);
            }
        });
    }

    protected void shiftField(PdfField currentField, PdfField fieldBelow) {
        int belowTopY = fieldBelow.getTopY();
        int cFieldBottomY = currentField.getBottomY();
        if ((this.isCoveredByDataField(currentField, fieldBelow) || this.isCoveredByDataGroup(currentField, fieldBelow)) && cFieldBottomY > belowTopY) {
            this.shiftDown(belowTopY, cFieldBottomY, fieldBelow, currentField.getResource());
        }
    }

    protected void generatePdfDataGroup(DataGroup dataGroup, PdfField pdfField) {
        PdfField dgField;
        if (dataGroup != null && dataGroup.getTitle() != null && !this.pdfFields.contains(dgField = new DataGroupFieldBuilder(this.resource).buildField(dataGroup, pdfField))) {
            this.pdfFields.add(dgField);
        }
    }

    protected void shiftDown(int belowTopY, int cFieldBottomY, PdfField fieldBelow, PdfResource resource) {
        int currentDiff = cFieldBottomY - belowTopY + resource.getPadding();
        fieldBelow.setTopY(belowTopY + currentDiff);
        fieldBelow.setBottomY(fieldBelow.getBottomY() + currentDiff);
        fieldBelow.setChangedPosition(true);
        if (!this.changedPdfFields.contains(fieldBelow)) {
            this.changedPdfFields.push(fieldBelow);
        }
    }

    protected boolean isCoveredByDataGroup(PdfField currentField, PdfField fieldBelow) {
        return currentField.isDgField() && currentField.getOriginalTopY() <= fieldBelow.getOriginalTopY();
    }

    protected boolean isCoveredByDataField(PdfField currentField, PdfField fieldBelow) {
        return currentField.getOriginalBottomY() < fieldBelow.getOriginalTopY();
    }

    protected void refreshGrid(DataGroup dataGroup) {
        log.info("Refreshing grid for data group in PDF...");
        if (dataGroup.getLayout() != null && dataGroup.getLayout().getCols() != null) {
            Integer cols = dataGroup.getLayout().getCols();
            this.resource.setFormGridCols(cols == null ? this.originalCols : cols);
        } else {
            this.resource.setFormGridCols(this.originalCols);
        }
        this.resource.updateProperties();
    }

    protected boolean isNotHidden(LocalisedField field) {
        return !field.getBehavior().has("hidden") || !field.getBehavior().get("hidden").asBoolean();
    }

    protected boolean isNotExcluded(String fieldId) {
        return !this.excludedFields.contains(fieldId);
    }

    @Generated
    public PetriNet getPetriNet() {
        return this.petriNet;
    }

    @Override
    @Generated
    public void setPetriNet(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public List<DataGroup> getDataGroups() {
        return this.dataGroups;
    }

    @Generated
    public void setDataGroups(List<DataGroup> dataGroups) {
        this.dataGroups = dataGroups;
    }

    @Override
    @Generated
    public List<PdfField> getPdfFields() {
        return this.pdfFields;
    }

    @Override
    @Generated
    public void setPdfFields(List<PdfField> pdfFields) {
        this.pdfFields = pdfFields;
    }

    @Generated
    public List<String> getExcludedFields() {
        return this.excludedFields;
    }

    @Override
    @Generated
    public void setExcludedFields(List<String> excludedFields) {
        this.excludedFields = excludedFields;
    }

    @Generated
    public PdfResource getResource() {
        return this.resource;
    }

    @Generated
    public void setResource(PdfResource resource) {
        this.resource = resource;
    }

    @Generated
    public Stack<PdfField> getChangedPdfFields() {
        return this.changedPdfFields;
    }

    @Generated
    public void setChangedPdfFields(Stack<PdfField> changedPdfFields) {
        this.changedPdfFields = changedPdfFields;
    }

    @Generated
    public int getLastX() {
        return this.lastX;
    }

    @Generated
    public int getLastY() {
        return this.lastY;
    }

    @Generated
    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(int lastY) {
        this.lastY = lastY;
    }

    @Generated
    public int getOriginalCols() {
        return this.originalCols;
    }

    @Generated
    public void setOriginalCols(int originalCols) {
        this.originalCols = originalCols;
    }
}

