/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.config.types.PdfBooleanFormat;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfDrawer;
import com.netgrif.application.engine.pdf.generator.service.renderer.BooleanFieldRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.DataGroupFieldRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.EnumerationRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.I18nDividerFieldRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.MultiChoiceRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.PageNumberRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.Renderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.TextFieldRenderer;
import com.netgrif.application.engine.pdf.generator.service.renderer.TitleRenderer;
import com.netgrif.application.engine.petrinet.domain.dataset.FieldType;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.multipdf.PDFCloneUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Matrix;
import org.springframework.stereotype.Service;

@Service
public class PdfDrawer
implements IPdfDrawer {
    private PDDocument pdf;
    private PDDocument templatePdf;
    private PDPageContentStream contentStream;
    private List<PDPage> pageList;
    private PDPage currentPage = null;
    private PdfResource resource;
    private int marginBottom;
    private int lineHeight;
    private int padding;
    private int boxSize;

    @Override
    public void setupDrawer(PDDocument pdf, PdfResource pdfResource) {
        this.pdf = pdf;
        this.resource = pdfResource;
        this.pageList = new ArrayList<PDPage>();
        this.marginBottom = this.resource.getMarginBottom();
        this.lineHeight = this.resource.getLineHeight();
        this.padding = this.resource.getPadding();
        this.boxSize = this.resource.getBoxSize();
    }

    @Override
    public void closeContentStream() throws IOException {
        this.contentStream.close();
        this.contentStream = null;
    }

    @Override
    public void closeTemplate() throws IOException {
        if (this.templatePdf != null) {
            this.templatePdf.close();
            this.templatePdf = null;
        }
    }

    @Override
    public void newPage() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
        }
        PDFCloneUtility cloneUtility = new PDFCloneUtility(this.templatePdf);
        if (!this.isOnLastPage()) {
            this.currentPage = this.pageList.get(this.pageList.indexOf(this.currentPage) + 1);
            this.contentStream = new PDPageContentStream(this.pdf, this.currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
        } else if (this.templatePdf != null || this.isOnLastPage()) {
            PDPage emptyPage;
            if (this.templatePdf != null && this.pageList.size() == 0) {
                emptyPage = this.templatePdf.getPage(0);
            } else if (this.templatePdf != null && this.templatePdf.getPages().getCount() > 1) {
                COSDictionary dictionary = (COSDictionary)cloneUtility.cloneForNewDocument((Object)this.templatePdf.getPage(1));
                emptyPage = new PDPage(dictionary);
            } else {
                emptyPage = new PDPage(this.resource.getPageSize());
            }
            this.pageList.add(emptyPage);
            this.pdf.addPage(emptyPage);
            this.currentPage = emptyPage;
            this.contentStream = new PDPageContentStream(this.pdf, this.currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
        }
    }

    private boolean isOnLastPage() {
        return this.pageList.indexOf(this.currentPage) == this.pageList.size() - 1;
    }

    @Override
    public void checkOpenPages() throws IOException {
        if (!this.currentPage.equals((Object)this.pageList.get(0))) {
            this.contentStream.close();
            this.currentPage = this.pageList.get(0);
            this.contentStream = new PDPageContentStream(this.pdf, this.currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
        }
    }

    @Override
    public void drawPageNumber() throws IOException {
        PageNumberRenderer pageNumberRenderer = new PageNumberRenderer();
        pageNumberRenderer.setupRenderer(this, this.resource);
        pageNumberRenderer.setFormat(this.resource.getPageNumberFormat());
        for (PDPage page : this.pageList) {
            this.contentStream.close();
            this.contentStream = new PDPageContentStream(this.pdf, page, PDPageContentStream.AppendMode.APPEND, true, true);
            pageNumberRenderer.renderPageNumber(this.pageList.indexOf(page) + 1, this.pageList.size());
        }
    }

    @Override
    public void drawTitleField(PdfField field) throws IOException {
        TitleRenderer titleFieldRenderer = new TitleRenderer();
        titleFieldRenderer.setupRenderer(this, this.resource);
        titleFieldRenderer.renderLabel(field);
    }

    @Override
    public void drawDataGroupField(PdfField field) throws IOException {
        DataGroupFieldRenderer dataGroupRenderer = new DataGroupFieldRenderer();
        dataGroupRenderer.setupRenderer(this, this.resource);
        dataGroupRenderer.renderLabel(field);
    }

    @Override
    public void drawTextField(PdfField field) throws IOException {
        TextFieldRenderer textFieldRenderer = new TextFieldRenderer();
        textFieldRenderer.setupRenderer(this, this.resource);
        int lineCounter = textFieldRenderer.renderLabel(field);
        textFieldRenderer.renderValue(field, lineCounter);
    }

    @Override
    public void drawI18nDividerField(PdfField field) throws IOException {
        I18nDividerFieldRenderer i18nDividerFieldRenderer = new I18nDividerFieldRenderer();
        i18nDividerFieldRenderer.setupRenderer(this, this.resource);
        i18nDividerFieldRenderer.renderValue(field, 0);
    }

    @Override
    public void drawBooleanField(PdfField field) throws IOException {
        BooleanFieldRenderer booleanFieldRenderer = new BooleanFieldRenderer();
        booleanFieldRenderer.setupRenderer(this, this.resource);
        int lineCounter = booleanFieldRenderer.renderLabel(field);
        booleanFieldRenderer.renderValue(field, lineCounter);
    }

    @Override
    public void drawEnumerationField(PdfField field) throws IOException {
        EnumerationRenderer enumerationRenderer = new EnumerationRenderer();
        enumerationRenderer.setupRenderer(this, this.resource);
        int lineCounter = enumerationRenderer.renderLabel(field);
        enumerationRenderer.renderValue(field, lineCounter);
    }

    @Override
    public void drawMultiChoiceField(PdfField field) throws IOException {
        MultiChoiceRenderer multiChoiceRenderer = new MultiChoiceRenderer();
        multiChoiceRenderer.setupRenderer(this, this.resource);
        int lineCounter = multiChoiceRenderer.renderLabel(field);
        multiChoiceRenderer.renderValue(field, lineCounter);
    }

    @Override
    public void drawBooleanBox(List<String> values, String text, int x, int y) throws IOException {
        if (this.checkBooleanValue(values, text)) {
            this.drawSvg(this.resource.getBooleanChecked(), x, y);
        } else {
            this.drawSvg(this.resource.getBooleanUnchecked(), x, y);
        }
    }

    @Override
    public boolean drawSelectionButton(List<String> values, String choice, int x, int y, FieldType fieldType) throws IOException {
        if (values.contains(choice)) {
            if (fieldType == FieldType.MULTICHOICE || fieldType == FieldType.MULTICHOICE_MAP) {
                this.drawSvg(this.resource.getCheckboxChecked(), x, y);
            } else if (fieldType == FieldType.ENUMERATION || fieldType == FieldType.ENUMERATION_MAP) {
                this.drawSvg(this.resource.getRadioChecked(), x, y);
            }
        } else if (fieldType == FieldType.MULTICHOICE || fieldType == FieldType.MULTICHOICE_MAP) {
            this.drawSvg(this.resource.getCheckboxUnchecked(), x, y);
        } else if (fieldType == FieldType.ENUMERATION || fieldType == FieldType.ENUMERATION_MAP) {
            this.drawSvg(this.resource.getRadioUnchecked(), x, y);
        }
        return true;
    }

    @Override
    public void drawStroke(int x, int y, int fieldPosY, int width, int lineCounter, float strokeWidth) throws IOException {
        int height = this.lineHeight * lineCounter - this.padding;
        this.contentStream.setStrokingColor(Color.LIGHT_GRAY);
        this.contentStream.setLineWidth(strokeWidth);
        if (fieldPosY >= this.marginBottom || height > 0) {
            this.contentStream.moveTo((float)(x += 8), (float)(y -= 8));
            this.contentStream.lineTo((float)(x + (width -= 50)), (float)y);
            this.contentStream.curveTo((float)(x + width) + 5.9f, (float)y + 0.14f, (float)(x + width) + 11.06f, (float)y + 5.16f, (float)(x + width) + 10.96f, (float)y + 10.0f);
            this.contentStream.lineTo((float)(x + width) + 10.96f, (float)(y + height));
            this.contentStream.curveTo((float)(x + width) + 11.06f, (float)(y + height) - 5.16f + 10.0f, (float)(x + width) + 5.9f, (float)(y + height) + 0.14f + 10.0f, (float)(x + width), (float)(y + height) + 10.0f);
            this.contentStream.lineTo((float)x, (float)(y + height) + 10.0f);
            this.contentStream.curveTo((float)x - 5.9f, (float)(y + height) + 0.14f + 10.0f, (float)x - 11.06f, (float)(y + height) - 5.16f + 10.0f, (float)x - 10.96f, (float)(y + height));
            this.contentStream.lineTo((float)x - 10.96f, (float)y + 10.0f);
            this.contentStream.curveTo((float)x - 11.06f, (float)y + 5.16f, (float)x - 5.9f, (float)y + 0.14f, (float)x, (float)y);
            this.contentStream.closePath();
        }
        this.contentStream.stroke();
    }

    @Override
    public void drawLine(int x, int y, int fieldPosY, int width, int lineCounter, float strokeWidth, Color color) throws IOException {
        this.contentStream.setStrokingColor(color);
        this.contentStream.moveTo((float)x, (float)y);
        this.contentStream.lineTo((float)(x + width), (float)y);
        this.contentStream.stroke();
    }

    @Override
    public void writeString(PDType0Font font, int fontSize, int x, int y, String text, Color color) throws IOException {
        this.contentStream.setFont((PDFont)font, (float)fontSize);
        this.contentStream.setNonStrokingColor(color);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)x, (float)y);
        this.contentStream.showText(Renderer.removeUnsupportedChars(text, this.resource));
        this.contentStream.endText();
    }

    @Override
    public void writeLabel(PDType0Font font, int fontSize, int x, int y, String text, Color color) throws IOException {
        this.contentStream.setNonStrokingColor(color != null ? color : Color.GRAY);
        this.contentStream.setFont((PDFont)font, (float)fontSize);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)x, (float)y);
        this.contentStream.showText(Renderer.removeUnsupportedChars(text, this.resource));
        this.contentStream.endText();
    }

    protected boolean checkBooleanValue(List<String> values, String text) {
        PdfBooleanFormat format = this.resource.getBooleanFormat();
        if (values.get(0).equals("true")) {
            if (!format.equals((Object)PdfBooleanFormat.SINGLE_BOX_EN) && !format.equals((Object)PdfBooleanFormat.SINGLE_BOX_SK)) {
                return format.getValue().get(0).equals(text);
            }
            return true;
        }
        if (format.equals((Object)PdfBooleanFormat.DOUBLE_BOX_WITH_TEXT_EN) || format.equals((Object)PdfBooleanFormat.DOUBLE_BOX_WITH_TEXT_SK)) {
            return format.getValue().get(1).equals(text);
        }
        return false;
    }

    protected void drawSvg(PDFormXObject resourceObject, int x, int y) throws IOException {
        this.contentStream.saveGraphicsState();
        AffineTransform transform = new AffineTransform(this.boxSize, 0.0f, 0.0f, this.boxSize, x, y - this.resource.getBoxPadding());
        this.contentStream.transform(new Matrix(transform));
        this.contentStream.drawForm(resourceObject);
        this.contentStream.restoreGraphicsState();
    }

    @Override
    @Generated
    public void setTemplatePdf(PDDocument templatePdf) {
        this.templatePdf = templatePdf;
    }
}

