/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfDataHelper;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfDrawer;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfGenerator;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.workflow.domain.Case;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import lombok.Generated;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;

@Service
public class PdfGenerator
implements IPdfGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfGenerator.class);
    private PDDocument pdf;
    @Autowired
    private IPdfDataHelper pdfDataHelper;
    @Autowired
    private IPdfDrawer pdfDrawer;

    @Override
    public void setupPdfGenerator(PdfResource pdfResource) throws IOException {
        this.setupPdfGenerator(pdfResource, 1.4f);
    }

    @Override
    public void setupPdfGenerator(PdfResource pdfResource, float version) throws IOException {
        log.info("Setting up PDF generator.");
        this.pdf = new PDDocument();
        this.pdf.setVersion(version);
        this.pdfDataHelper.setupDataHelper(pdfResource);
        this.pdfDrawer.setupDrawer(this.pdf, pdfResource);
        pdfResource.setTitleFont(PDType0Font.load((PDDocument)this.pdf, (InputStream)new FileInputStream(pdfResource.getFontTitleResource().getFile()), (boolean)true));
        pdfResource.setLabelFont(PDType0Font.load((PDDocument)this.pdf, (InputStream)new FileInputStream(pdfResource.getFontLabelResource().getFile()), (boolean)true));
        pdfResource.setValueFont(PDType0Font.load((PDDocument)this.pdf, (InputStream)new FileInputStream(pdfResource.getFontValueResource().getFile()), (boolean)true));
        pdfResource.setCheckboxChecked(this.getSvg(pdfResource.getCheckBoxCheckedResource()));
        pdfResource.setCheckboxUnchecked(this.getSvg(pdfResource.getCheckBoxUnCheckedResource()));
        pdfResource.setRadioChecked(this.getSvg(pdfResource.getRadioCheckedResource()));
        pdfResource.setRadioUnchecked(this.getSvg(pdfResource.getRadioUnCheckedResource()));
        pdfResource.setBooleanChecked(this.getSvg(pdfResource.getBooleanCheckedResource()));
        pdfResource.setBooleanUnchecked(this.getSvg(pdfResource.getBooleanUncheckedResource()));
    }

    @Override
    public void addCustomField(PdfField field, PdfResource pdfResource) {
        this.generateData(field, pdfResource);
    }

    @Override
    public File generatePdf(Case formCase, String transitionId, PdfResource pdfResource, List<String> excludedFields) {
        this.generateData(formCase.getPetriNet(), formCase, formCase.getPetriNet().getTransition(transitionId), pdfResource, excludedFields);
        return this.generatePdf(pdfResource);
    }

    @Override
    public File generatePdf(Case formCase, String transitionId, PdfResource pdfResource) {
        this.generateData(formCase.getPetriNet(), formCase, formCase.getPetriNet().getTransition(transitionId), pdfResource);
        return this.generatePdf(pdfResource);
    }

    @Override
    public File generatePdf(PdfResource pdfResource) {
        try {
            return this.transformRequestToPdf(this.pdfDataHelper.getPdfFields(), pdfResource);
        }
        catch (IOException e) {
            log.error("Error occurred while converting form data to PDF", (Throwable)e);
            return null;
        }
    }

    @Override
    public void generatePdf(Case formCase, String transitionId, PdfResource pdfResource, OutputStream stream) {
        Transition transition = formCase.getPetriNet().getTransition(transitionId);
        this.generatePdf(formCase, transition, pdfResource, stream);
    }

    @Override
    public void generatePdf(Case formCase, Transition transition, PdfResource pdfResource, OutputStream stream) {
        this.generateData(formCase.getPetriNet(), formCase, transition, pdfResource);
        try {
            this.transformRequestToPdf(this.pdfDataHelper.getPdfFields(), pdfResource, stream);
        }
        catch (IOException e) {
            log.error("Error occurred while converting form data to PDF", (Throwable)e);
        }
    }

    @Override
    public void generateData(PetriNet petriNet, Case useCase, Transition transition, PdfResource pdfResource, List<String> excludedFields) {
        this.pdfDataHelper.setExcludedFields(excludedFields);
        this.generateData(useCase.getPetriNet(), useCase, transition, pdfResource);
    }

    @Override
    public void generateData(PetriNet petriNet, Case useCase, Transition transition, PdfResource pdfResource) {
        this.pdfDataHelper.setPetriNet(petriNet);
        this.pdfDataHelper.setTaskId(useCase, transition);
        this.pdfDataHelper.generateTitleField();
        this.pdfDataHelper.generatePdfFields();
        this.pdfDataHelper.correctFieldsPosition();
        this.pdfDrawer.setupDrawer(this.pdf, pdfResource);
    }

    @Override
    public void generateData(PdfField pdfField, PdfResource pdfResource) {
        this.pdfDataHelper.getPdfFields().add(pdfField);
        this.pdfDataHelper.correctFieldsPosition();
    }

    protected File transformRequestToPdf(List<PdfField> pdfFields, PdfResource pdfResource) throws IOException {
        File output = new File(((ClassPathResource)pdfResource.getOutputResource()).getPath());
        this.transformRequestToPdf(pdfFields, pdfResource, new FileOutputStream(output));
        return output;
    }

    protected void transformRequestToPdf(List<PdfField> pdfFields, PdfResource pdfResource, OutputStream stream) throws IOException {
        if (pdfResource.getTemplateResource().exists()) {
            InputStream template = pdfResource.getTemplateResource().getInputStream();
            this.pdfDrawer.setTemplatePdf(PDDocument.load((InputStream)template));
        }
        this.pdfDrawer.newPage();
        this.drawTransitionForm(pdfFields);
        this.pdfDrawer.closeContentStream();
        this.pdf.save(stream);
        this.pdfDrawer.closeTemplate();
        this.pdf.close();
        stream.close();
        log.info("PDF is generated from transition.");
    }

    protected void drawTransitionForm(List<PdfField> pdfFields) throws IOException {
        log.info("Drawing form to PDF.");
        block6: for (PdfField pdfField : pdfFields) {
            if (pdfField.getFieldId().equals("titleField")) {
                this.pdfDrawer.drawTitleField(pdfField);
                continue;
            }
            if (!pdfField.isDgField()) {
                switch (pdfField.getType()) {
                    case MULTICHOICE_MAP: 
                    case MULTICHOICE: {
                        this.pdfDrawer.drawMultiChoiceField(pdfField);
                        continue block6;
                    }
                    case ENUMERATION_MAP: 
                    case ENUMERATION: {
                        this.pdfDrawer.drawEnumerationField(pdfField);
                        continue block6;
                    }
                    case BOOLEAN: {
                        this.pdfDrawer.drawBooleanField(pdfField);
                        continue block6;
                    }
                    case I18N: {
                        this.pdfDrawer.drawI18nDividerField(pdfField);
                        continue block6;
                    }
                }
                this.pdfDrawer.drawTextField(pdfField);
                continue;
            }
            this.pdfDrawer.drawDataGroupField(pdfField);
        }
        this.pdfDrawer.drawPageNumber();
    }

    protected PDFormXObject getSvg(Resource resource) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document document = f.createDocument(resource.getURI().toString(), resource.getInputStream());
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext context = new BridgeContext((UserAgent)userAgent, loader);
        context.setDynamicState(0);
        GVTBuilder builder = new GVTBuilder();
        GraphicsNode gvtRoot = builder.build(context, document);
        PdfBoxGraphics2D pdfBoxGraphics2D = new PdfBoxGraphics2D(this.pdf, 1, 1);
        pdfBoxGraphics2D.scale(1.0, 1.0);
        gvtRoot.paint((Graphics2D)pdfBoxGraphics2D);
        pdfBoxGraphics2D.dispose();
        return pdfBoxGraphics2D.getXFormObject();
    }
}

