/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.fieldbuilder;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldLayout;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import lombok.Generated;

public abstract class FieldBuilder {
    private static final String LEGACY = "legacy";
    private static final String FLOW = "flow";
    private static final String GRID = "grid";
    protected PdfResource resource;
    protected int lastX;
    protected int lastY;

    public FieldBuilder(PdfResource resource) {
        this.resource = resource;
    }

    public static int countTopPosY(PdfField field, PdfResource resource) {
        return field.getLayoutY() * resource.getFormGridRowHeight() + resource.getPadding();
    }

    public static int countBottomPosY(PdfField field, PdfResource resource) {
        return field.getLayoutY() * resource.getFormGridRowHeight() + field.getHeight() + resource.getPadding();
    }

    public static List<String> generateMultiLineText(List<String> values, float maxLineLength) {
        ArrayList<String> result = new ArrayList<String>();
        int lineLen = 0;
        for (String value : values) {
            StringTokenizer tokenizer = new StringTokenizer(value.trim(), " ");
            StringBuilder output = new StringBuilder(value.length());
            while (tokenizer.hasMoreTokens()) {
                String word = tokenizer.nextToken();
                if ((float)word.length() > maxLineLength - (float)lineLen && (float)word.length() > maxLineLength) {
                    FieldBuilder.breakLongWordToMultipleLine(output, word, lineLen, (int)maxLineLength);
                    lineLen = 0;
                    continue;
                }
                if ((float)(lineLen + word.length()) > maxLineLength) {
                    output.append("\n");
                    lineLen = 0;
                    output.append(word).append(" ");
                    lineLen += word.length() + 1;
                    continue;
                }
                output.append(word).append(" ");
                lineLen += word.length() + 1;
            }
            lineLen = 0;
            result.addAll(Arrays.asList(output.toString().split("\n")));
        }
        return result;
    }

    public static void breakLongWordToMultipleLine(StringBuilder output, String longWord, int lineLength, int maxLineLength) {
        if (maxLineLength - lineLength <= 0) {
            lineLength = 0;
        }
        while (longWord.length() > maxLineLength - lineLength) {
            output.append(longWord, 0, maxLineLength - lineLength - 4);
            output.append("\n");
            longWord = longWord.substring(maxLineLength - lineLength - 3);
            lineLength = 0;
        }
    }

    protected void setFieldParams(DataGroup dg, LocalisedField field, PdfField pdfField) {
        pdfField.setLayoutX(this.countFieldLayoutX(dg, field));
        pdfField.setLayoutY(this.countFieldLayoutY(dg, field));
        pdfField.setWidth(this.countFieldWidth(dg, field));
        pdfField.setHeight(this.countFieldHeight());
    }

    protected void setFieldPositions(PdfField pdfField, int fontSize) {
        pdfField.setX(this.countPosX(pdfField));
        pdfField.setOriginalTopY(FieldBuilder.countTopPosY(pdfField, this.resource));
        pdfField.setTopY(FieldBuilder.countTopPosY(pdfField, this.resource));
        pdfField.setOriginalBottomY(FieldBuilder.countBottomPosY(pdfField, this.resource));
        pdfField.setBottomY(FieldBuilder.countBottomPosY(pdfField, this.resource));
        pdfField.countMultiLineHeight(fontSize, this.resource);
    }

    private int countFieldLayoutX(DataGroup dataGroup, LocalisedField field) {
        int x = 0;
        if (this.isDgFlow(dataGroup)) {
            if (!this.isStretch(dataGroup)) {
                x = this.lastX < this.resource.getFormGridCols() ? this.lastX : 0;
            }
            this.lastX = x;
        } else if (this.isDgLegacy(dataGroup)) {
            this.lastX = this.isStretch(dataGroup) ? 0 : (this.lastX == 0 ? 2 : 0);
            x = this.lastX;
        } else if (field.getLayout() != null) {
            this.lastX = x = field.getLayout().getX();
        }
        return x;
    }

    private int countFieldLayoutY(DataGroup dataGroup, LocalisedField field) {
        int y;
        if (this.checkFullRow(dataGroup, field)) {
            y = ++this.lastY;
            this.resolveRowGridFree(dataGroup, field.getLayout());
        } else {
            if (this.lastX == 0) {
                y = ++this.lastY;
                this.resolveRowGridFree(dataGroup, field.getLayout());
            } else {
                y = this.lastY;
                this.resource.setRowGridFree(!this.checkCol(field.getLayout()) ? 2 : this.resource.getRowGridFree() - field.getLayout().getCols());
            }
            if (this.isDgFlow(dataGroup)) {
                ++this.lastX;
            }
        }
        return y;
    }

    public int countPosX(PdfField field) {
        return field.getLayoutX() * this.resource.getFormGridColWidth() + this.resource.getPadding();
    }

    private int countFieldWidth(DataGroup dataGroup, LocalisedField field) {
        if (this.isDgFlow(dataGroup)) {
            return this.resource.getFormGridColWidth() - this.resource.getPadding();
        }
        if (this.isDgLegacy(dataGroup)) {
            return (this.isStretch(dataGroup) ? this.resource.getFormGridColWidth() * this.resource.getFormGridCols() : this.resource.getFormGridColWidth() * this.resource.getFormGridCols() / 2) - this.resource.getPadding();
        }
        return field.getLayout().getCols() * this.resource.getFormGridColWidth() - this.resource.getPadding();
    }

    private int countFieldHeight() {
        return this.resource.getFormGridRowHeight() - this.resource.getPadding();
    }

    private boolean checkFullRow(DataGroup dataGroup, LocalisedField field) {
        return this.isStretch(dataGroup) || this.checkCol(field.getLayout()) && this.resource.getRowGridFree() < field.getLayout().getCols();
    }

    private boolean checkCol(FieldLayout layout) {
        return layout != null && layout.getCols() != null;
    }

    private boolean isStretch(DataGroup dataGroup) {
        return dataGroup.getStretch() != null && dataGroup.getStretch() != false;
    }

    private boolean isDgFlow(DataGroup dataGroup) {
        return dataGroup.getLayout() != null && dataGroup.getLayout().getType() != null && dataGroup.getLayout().getType().equals(FLOW);
    }

    private boolean isDgLegacy(DataGroup dataGroup) {
        return dataGroup.getLayout() == null || dataGroup.getLayout().getType() == null || dataGroup.getLayout().getType().equals(LEGACY);
    }

    private void resolveRowGridFree(DataGroup dataGroup, FieldLayout layout) {
        if (this.checkCol(layout)) {
            this.resource.setRowGridFree(this.resource.getFormGridCols() - layout.getCols());
        } else if (this.isStretch(dataGroup)) {
            this.resource.setRowGridFree(0);
        } else {
            this.resource.setRowGridFree(this.resource.getFormGridCols() - 2);
        }
    }

    @Generated
    public int getLastX() {
        return this.lastX;
    }

    @Generated
    public int getLastY() {
        return this.lastY;
    }
}

