/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.fieldbuilder;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfMultiChoiceField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.SelectionFieldBuilder;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedMultichoiceMapField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class MultiChoiceMapFieldBuilder
extends SelectionFieldBuilder {
    public MultiChoiceMapFieldBuilder(PdfResource resource) {
        super(resource);
    }

    public PdfField buildField(DataGroup dataGroup, LocalisedMultichoiceMapField field, int lastX, int lastY) {
        ArrayList<String> choices = new ArrayList();
        ArrayList<String> values = new ArrayList<String>();
        this.lastX = lastX;
        this.lastY = lastY;
        if (field.getOptions() != null) {
            choices = new ArrayList<String>(field.getOptions().values());
        }
        if (field.getValue() != null) {
            values.addAll(((Collection)field.getValue()).stream().map(value -> field.getOptions().get(value)).collect(Collectors.toList()));
        }
        String translatedTitle = field.getName();
        PdfMultiChoiceField pdfField = new PdfMultiChoiceField(field.getStringId(), dataGroup, field.getType(), translatedTitle, values, choices, this.resource);
        this.setFieldParams(dataGroup, field, pdfField);
        this.setFieldPositions(pdfField, this.resource.getFontLabelSize());
        return pdfField;
    }
}

