/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.fieldbuilder;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfTextField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.dataset.FileFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.FileListFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserFieldValue;
import com.netgrif.application.engine.petrinet.domain.dataset.UserListFieldValue;
import com.netgrif.application.engine.utils.DateUtils;
import com.netgrif.application.engine.workflow.web.responsebodies.LocalisedField;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;

public class TextFieldBuilder
extends FieldBuilder {
    public TextFieldBuilder(PdfResource resource) {
        super(resource);
    }

    public PdfField buildField(DataGroup dataGroup, LocalisedField field, int lastX, int lastY) {
        String value;
        this.lastX = lastX;
        this.lastY = lastY;
        switch (field.getType()) {
            case DATE: {
                value = field.getValue() != null ? this.formatDate(field) : "";
                break;
            }
            case DATETIME: {
                value = field.getValue() != null ? this.formatDateTime(field) : "";
                break;
            }
            case NUMBER: {
                double number;
                if (field.getValue() != null && this.isCurrencyField(field)) {
                    number = (Double)field.getValue();
                    Map<String, String> properties = field.getComponent().getProperties();
                    NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(new Locale(properties.get("locale")));
                    currencyFormat.setCurrency(Currency.getInstance(properties.get("code")));
                    currencyFormat.setMaximumFractionDigits(Integer.parseInt(properties.get("fractionSize")));
                    value = currencyFormat.format(number);
                    break;
                }
                if (field.getValue() != null) {
                    number = (Double)field.getValue();
                    NumberFormat nf2 = NumberFormat.getInstance(this.resource.getNumberFormat());
                    value = nf2.format(number);
                    break;
                }
                value = "";
                break;
            }
            case FILE: {
                value = field.getValue() != null ? this.shortenFileName(((FileFieldValue)field.getValue()).getName()) : "";
                break;
            }
            case FILELIST: {
                value = field.getValue() != null ? this.resolveFileListNames((FileListFieldValue)field.getValue()) : "";
                break;
            }
            case USER: {
                value = field.getValue() != null ? ((UserFieldValue)field.getValue()).getFullName() : "";
                break;
            }
            case USERLIST: {
                value = field.getValue() != null ? ((UserListFieldValue)field.getValue()).getUserValues().stream().map(UserFieldValue::getFullName).collect(Collectors.joining(", ")) : "";
                break;
            }
            default: {
                value = field.getValue() != null ? Jsoup.parse((String)field.getValue().toString()).text() : "";
            }
        }
        String translatedTitle = field.getName();
        PdfTextField pdfField = new PdfTextField(field.getStringId(), dataGroup, field.getType(), translatedTitle, value, this.resource);
        this.setFieldParams(dataGroup, field, pdfField);
        this.setFieldPositions(pdfField, this.resource.getFontLabelSize());
        return pdfField;
    }

    private String formatDate(LocalisedField field) {
        ZonedDateTime value = ZonedDateTime.now();
        if (field.getValue() != null) {
            if (field.getValue() instanceof LocalDate) {
                value = DateUtils.localDateToZonedDate((LocalDate)field.getValue(), this.resource.getDateZoneId());
            } else if (field.getValue() instanceof Date) {
                value = ((Date)field.getValue()).toInstant().atZone(this.resource.getDateZoneId());
            }
            return DateTimeFormatter.ofPattern(this.resource.getDateFormat().getValue()).format(value);
        }
        return "";
    }

    private String formatDateTime(LocalisedField field) {
        ZonedDateTime value = ZonedDateTime.now();
        if (field.getValue() != null) {
            if (field.getValue() instanceof LocalDateTime) {
                value = DateUtils.localDateTimeToZonedDateTime((LocalDateTime)field.getValue(), this.resource.getDateZoneId());
            } else if (field.getValue() instanceof Date) {
                value = ((Date)field.getValue()).toInstant().atZone(this.resource.getDateZoneId());
            }
            return DateTimeFormatter.ofPattern(this.resource.getDateTimeFormat().getValue()).format(value);
        }
        return "";
    }

    private String resolveFileListNames(FileListFieldValue files) {
        return files.getNamesPaths().stream().map(it -> this.shortenFileName(it.getName())).collect(Collectors.joining(", "));
    }

    private String shortenFileName(String fileName) {
        if (fileName.length() > 32) {
            return fileName.substring(0, 16) + "..." + fileName.substring(fileName.length() - 8);
        }
        return fileName;
    }

    private boolean isCurrencyField(LocalisedField field) {
        return field.getComponent() != null && Objects.equals(field.getComponent().getName(), "currency") && field.getComponent().getProperties() != null && field.getComponent().getProperties().containsKey("code") && field.getComponent().getProperties().get("code") != null && field.getComponent().getProperties().containsKey("locale") && field.getComponent().getProperties().get("locale") != null && field.getComponent().getProperties().containsKey("fractionSize") && field.getComponent().getProperties().get("fractionSize") != null;
    }
}

