/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.config.types.PdfBooleanFormat;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfTextField;
import com.netgrif.application.engine.pdf.generator.service.renderer.FieldRenderer;
import java.io.IOException;
import java.util.List;

public class BooleanFieldRenderer
extends FieldRenderer {
    private PdfBooleanFormat booleanFormat;

    public void setFieldParams(PdfField field) {
        this.helperField = new PdfTextField(field.getFieldId(), field.getLabel(), field.getValues(), field.getType(), this.resource.getBaseX() + field.getX(), this.resource.getBaseY() - field.getBottomY(), field.getWidth(), field.getHeight(), this.resource);
        this.booleanFormat = this.resource.getBooleanFormat();
    }

    @Override
    public int renderLabel(PdfField field) throws IOException {
        this.setFieldParams(field);
        return this.renderLabel(this.helperField, this.resource.getLabelFont(), this.fontLabelSize, this.colorLabelString);
    }

    @Override
    public void renderValue(PdfField field, int lineCounter) throws IOException {
        this.setFieldParams(field);
        this.renderValue(this.helperField, lineCounter, this.strokeWidth);
    }

    private void renderValue(PdfField field, int lineCounter, float strokeWidth) throws IOException {
        int x = field.getX() + this.padding;
        int y = this.renderLinePosY(field, lineCounter);
        ++lineCounter;
        lineCounter = this.renderPageBrake(field, lineCounter, y);
        y = this.renderLinePosY(field, lineCounter);
        if (this.resource.isBooleanFieldStroke()) {
            this.pdfDrawer.drawStroke(field.getX(), y, field.getBottomY(), field.getWidth(), 1, strokeWidth);
        }
        List<String> booleanValues = this.booleanFormat.getValue();
        for (String value : booleanValues) {
            this.pdfDrawer.drawBooleanBox(field.getValues(), value, x += booleanValues.indexOf(value) * (this.padding * 9), y);
            this.pdfDrawer.writeString(this.resource.getValueFont(), this.resource.getFontValueSize(), x + this.fontLabelSize + this.padding, y, value, this.colorString);
        }
        this.pdfDrawer.checkOpenPages();
    }
}

