/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.Renderer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public abstract class FieldRenderer
extends Renderer {
    PdfField helperField;

    public abstract void renderValue(PdfField var1, int var2) throws IOException;

    protected int renderLabel(final PdfField field, PDType0Font font, int fontSize, Color colorLabel) throws IOException {
        float textWidth = FieldRenderer.getTextWidth(Collections.singletonList(field.getLabel()), font, fontSize, this.resource);
        int maxLineSize = this.getMaxLabelLineSize(field.getWidth(), fontSize);
        List<String> multiLineText = new ArrayList<String>(){
            {
                this.add(field.getLabel());
            }
        };
        int linesOnPage = 0;
        int x = field.getX() + this.padding;
        int y = this.renderLinePosY(field, 1);
        if (textWidth > (float)(field.getWidth() - this.padding)) {
            multiLineText = FieldBuilder.generateMultiLineText(Collections.singletonList(field.getLabel()), maxLineSize);
        }
        for (String line : multiLineText) {
            ++linesOnPage;
            linesOnPage = this.renderPageBrake(field, linesOnPage, y);
            y = this.renderLinePosY(field, linesOnPage);
            this.pdfDrawer.writeString(font, fontSize, x, y, line, colorLabel);
        }
        this.pdfDrawer.checkOpenPages();
        return multiLineText.size();
    }

    protected int renderPageBrake(PdfField field, int linesOnPage, int y) throws IOException {
        if (y < this.marginBottom) {
            field.setHeight(this.renderHeight(field, linesOnPage));
            linesOnPage = 1;
            while (y < this.marginBottom) {
                this.pdfDrawer.newPage();
                field.setBottomY(this.renderBottomY(field));
                y = this.renderLinePosY(field, linesOnPage);
            }
        }
        return linesOnPage;
    }

    protected int renderPageBrake(PdfField field, int linesOnPage, int strokeLineCounter, int y) throws IOException {
        if (y < this.marginBottom) {
            if (this.resource.isTextFieldStroke()) {
                this.pdfDrawer.drawStroke(field.getX(), y, field.getBottomY(), field.getWidth(), strokeLineCounter, this.strokeWidth);
            }
            field.setHeight(this.renderHeight(field, linesOnPage));
            linesOnPage = 1;
            while (y < this.marginBottom) {
                this.pdfDrawer.newPage();
                field.setBottomY(this.renderBottomY(field));
                y = this.renderLinePosY(field, linesOnPage);
            }
        }
        return linesOnPage;
    }

    protected int renderLinePosY(PdfField field, int linesOnPage) {
        return field.getBottomY() + field.getHeight() - this.lineHeight * linesOnPage;
    }

    protected int renderBottomY(PdfField field) {
        return field.getBottomY() + this.pageHeight - this.marginTop - this.marginBottom - this.lineHeight;
    }

    protected int renderHeight(PdfField field, int linesOnPage) {
        return field.getHeight() - this.lineHeight * (linesOnPage - 1);
    }

    protected int getMaxValueLineSize(int fieldWidth) {
        return (int)((float)(fieldWidth - this.padding) * this.resource.getSizeMultiplier() / (float)this.fontValueSize);
    }

    @Generated
    public FieldRenderer() {
    }

    @Generated
    public PdfField getHelperField() {
        return this.helperField;
    }

    @Generated
    public void setHelperField(PdfField helperField) {
        this.helperField = helperField;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldRenderer)) {
            return false;
        }
        FieldRenderer other = (FieldRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PdfField this$helperField = this.getHelperField();
        PdfField other$helperField = other.getHelperField();
        return !(this$helperField == null ? other$helperField != null : !((Object)this$helperField).equals(other$helperField));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldRenderer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PdfField $helperField = this.getHelperField();
        result = result * 59 + ($helperField == null ? 43 : ((Object)$helperField).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FieldRenderer(helperField=" + this.getHelperField() + ")";
    }
}

