/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfTextField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.FieldRenderer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDType0Font;

public class I18nDividerFieldRenderer
extends FieldRenderer {
    public void setFieldParams(PdfField field) {
        this.helperField = new PdfTextField(field.getFieldId(), field.getLabel(), field.getValues(), field.getType(), this.resource.getBaseX() + field.getX(), this.resource.getBaseY() - field.getBottomY(), field.getWidth(), field.getHeight(), this.resource);
    }

    @Override
    public int renderLabel(PdfField field) throws IOException {
        return 0;
    }

    @Override
    public void renderValue(PdfField field, int lineCounter) throws IOException {
        this.setFieldParams(field);
        this.renderValue(this.helperField, this.resource.getLabelFont(), this.resource.getFontGroupSize(), this.colorDataGroupLabel);
    }

    private void renderValue(PdfField field, PDType0Font font, int fontSize, Color colorLabel) throws IOException {
        float textWidth = I18nDividerFieldRenderer.getTextWidth(Collections.singletonList(field.getLabel()), font, fontSize, this.resource);
        int maxLineSize = this.getMaxLabelLineSize(field.getWidth(), fontSize);
        List<String> multiLineText = new ArrayList<String>(field.getValues());
        int linesOnPage = 0;
        int x = field.getX() + this.padding;
        int y = this.renderLinePosY(field, 1);
        if (textWidth > (float)(field.getWidth() - this.padding)) {
            multiLineText = FieldBuilder.generateMultiLineText(field.getValues(), maxLineSize);
        }
        for (String line : multiLineText) {
            ++linesOnPage;
            linesOnPage = this.renderPageBrake(field, linesOnPage, y);
            y = this.renderLinePosY(field, linesOnPage);
            this.pdfDrawer.writeString(font, fontSize, x, y, line, colorLabel);
        }
        this.pdfDrawer.checkOpenPages();
    }
}

