/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.config.types.PdfPageNumberFormat;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.renderer.Renderer;
import java.io.IOException;
import lombok.Generated;

public class PageNumberRenderer
extends Renderer {
    private PdfPageNumberFormat format;

    public void renderPageNumber(int counter, int pageCount) throws IOException {
        String numberText = this.generateNumberText(counter, pageCount);
        this.pdfDrawer.writeString(this.resource.getValueFont(), this.fontValueSize, this.resource.getPageNumberPosition(), this.marginBottom - 2 * this.lineHeight, numberText, this.colorString);
    }

    private String generateNumberText(int counter, int pageCount) {
        return counter + (String)(!this.format.getFormat().equals("") ? this.format.getFormat() + pageCount : "");
    }

    @Override
    public int renderLabel(PdfField field) throws IOException {
        return 0;
    }

    @Generated
    public void setFormat(PdfPageNumberFormat format) {
        this.format = format;
    }
}

