/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.config.PdfResource;
import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.service.interfaces.IPdfDrawer;
import java.awt.Color;
import java.io.IOException;
import java.text.Normalizer;
import java.util.List;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.jsoup.Jsoup;

public abstract class Renderer {
    protected IPdfDrawer pdfDrawer;
    protected PdfResource resource;
    int marginLeft;
    int marginBottom;
    int marginTop;
    int lineHeight;
    int pageDrawableWidth;
    int padding;
    int pageHeight;
    int baseX;
    int fontValueSize;
    int fontLabelSize;
    int fontTitleSize;
    float strokeWidth;
    Color colorString;
    Color colorLabelString;
    Color colorDataGroupLabel;

    protected static int getTextWidth(List<String> values, PDType0Font font, int fontSize, PdfResource resource) throws IOException {
        int result = 0;
        for (String value : values) {
            String formattedValue = Renderer.removeUnsupportedChars(value, resource);
            if (!((float)result < font.getStringWidth(formattedValue) / 1000.0f * (float)fontSize)) continue;
            result = (int)(font.getStringWidth(formattedValue) / 1000.0f * (float)fontSize);
        }
        return result;
    }

    public static String removeUnsupportedChars(String input, PdfResource resource) {
        String value = Jsoup.parse((String)input.replaceAll("\\s{1,}", " ")).text();
        value = Normalizer.normalize(value, Normalizer.Form.NFC);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (Renderer.isCharEncodable(value.charAt(i), resource.getValueFont())) {
                b.append(value.charAt(i));
                continue;
            }
            if (Renderer.isCharEncodable(value.charAt(i), resource.getLabelFont())) {
                b.append(value.charAt(i));
                continue;
            }
            if (!Renderer.isCharEncodable(value.charAt(i), resource.getTitleFont())) continue;
            b.append(value.charAt(i));
        }
        return b.toString();
    }

    public static boolean isCharEncodable(char character, PDType0Font font) {
        try {
            font.encode(Character.toString(character));
            return true;
        }
        catch (IOException | IllegalArgumentException iae) {
            return false;
        }
    }

    public abstract int renderLabel(PdfField var1) throws IOException;

    public void setupRenderer(IPdfDrawer pdfDrawer, PdfResource resource) {
        this.pdfDrawer = pdfDrawer;
        this.resource = resource;
        this.marginLeft = resource.getMarginLeft();
        this.marginBottom = resource.getMarginBottom();
        this.marginTop = resource.getMarginTop();
        this.lineHeight = resource.getLineHeight();
        this.pageDrawableWidth = resource.getPageDrawableWidth();
        this.padding = resource.getPadding();
        this.colorString = Color.decode(resource.getColorString().toUpperCase());
        this.colorDataGroupLabel = Color.decode(resource.getColorDataGroup().toUpperCase());
        this.colorLabelString = Color.decode(resource.getColorLabelString().toUpperCase());
        this.baseX = resource.getBaseX();
        this.pageHeight = resource.getPageHeight();
        this.fontValueSize = resource.getFontValueSize();
        this.fontLabelSize = resource.getFontLabelSize();
        this.fontTitleSize = resource.getFontTitleSize();
        this.strokeWidth = resource.getStrokeWidth();
    }

    protected int getMaxLabelLineSize(int fieldWidth, int fontSize) {
        return (int)((float)(fieldWidth - this.padding) * this.resource.getSizeMultiplier() / (float)fontSize);
    }

    @Generated
    public Renderer() {
    }

    @Generated
    public IPdfDrawer getPdfDrawer() {
        return this.pdfDrawer;
    }

    @Generated
    public PdfResource getResource() {
        return this.resource;
    }

    @Generated
    public int getMarginLeft() {
        return this.marginLeft;
    }

    @Generated
    public int getMarginBottom() {
        return this.marginBottom;
    }

    @Generated
    public int getMarginTop() {
        return this.marginTop;
    }

    @Generated
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Generated
    public int getPageDrawableWidth() {
        return this.pageDrawableWidth;
    }

    @Generated
    public int getPadding() {
        return this.padding;
    }

    @Generated
    public int getPageHeight() {
        return this.pageHeight;
    }

    @Generated
    public int getBaseX() {
        return this.baseX;
    }

    @Generated
    public int getFontValueSize() {
        return this.fontValueSize;
    }

    @Generated
    public int getFontLabelSize() {
        return this.fontLabelSize;
    }

    @Generated
    public int getFontTitleSize() {
        return this.fontTitleSize;
    }

    @Generated
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Generated
    public Color getColorString() {
        return this.colorString;
    }

    @Generated
    public Color getColorLabelString() {
        return this.colorLabelString;
    }

    @Generated
    public Color getColorDataGroupLabel() {
        return this.colorDataGroupLabel;
    }

    @Generated
    public void setPdfDrawer(IPdfDrawer pdfDrawer) {
        this.pdfDrawer = pdfDrawer;
    }

    @Generated
    public void setResource(PdfResource resource) {
        this.resource = resource;
    }

    @Generated
    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    @Generated
    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    @Generated
    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    @Generated
    public void setLineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
    }

    @Generated
    public void setPageDrawableWidth(int pageDrawableWidth) {
        this.pageDrawableWidth = pageDrawableWidth;
    }

    @Generated
    public void setPadding(int padding) {
        this.padding = padding;
    }

    @Generated
    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    @Generated
    public void setBaseX(int baseX) {
        this.baseX = baseX;
    }

    @Generated
    public void setFontValueSize(int fontValueSize) {
        this.fontValueSize = fontValueSize;
    }

    @Generated
    public void setFontLabelSize(int fontLabelSize) {
        this.fontLabelSize = fontLabelSize;
    }

    @Generated
    public void setFontTitleSize(int fontTitleSize) {
        this.fontTitleSize = fontTitleSize;
    }

    @Generated
    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Generated
    public void setColorString(Color colorString) {
        this.colorString = colorString;
    }

    @Generated
    public void setColorLabelString(Color colorLabelString) {
        this.colorLabelString = colorLabelString;
    }

    @Generated
    public void setColorDataGroupLabel(Color colorDataGroupLabel) {
        this.colorDataGroupLabel = colorDataGroupLabel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Renderer)) {
            return false;
        }
        Renderer other = (Renderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMarginLeft() != other.getMarginLeft()) {
            return false;
        }
        if (this.getMarginBottom() != other.getMarginBottom()) {
            return false;
        }
        if (this.getMarginTop() != other.getMarginTop()) {
            return false;
        }
        if (this.getLineHeight() != other.getLineHeight()) {
            return false;
        }
        if (this.getPageDrawableWidth() != other.getPageDrawableWidth()) {
            return false;
        }
        if (this.getPadding() != other.getPadding()) {
            return false;
        }
        if (this.getPageHeight() != other.getPageHeight()) {
            return false;
        }
        if (this.getBaseX() != other.getBaseX()) {
            return false;
        }
        if (this.getFontValueSize() != other.getFontValueSize()) {
            return false;
        }
        if (this.getFontLabelSize() != other.getFontLabelSize()) {
            return false;
        }
        if (this.getFontTitleSize() != other.getFontTitleSize()) {
            return false;
        }
        if (Float.compare(this.getStrokeWidth(), other.getStrokeWidth()) != 0) {
            return false;
        }
        IPdfDrawer this$pdfDrawer = this.getPdfDrawer();
        IPdfDrawer other$pdfDrawer = other.getPdfDrawer();
        if (this$pdfDrawer == null ? other$pdfDrawer != null : !this$pdfDrawer.equals(other$pdfDrawer)) {
            return false;
        }
        PdfResource this$resource = this.getResource();
        PdfResource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        Color this$colorString = this.getColorString();
        Color other$colorString = other.getColorString();
        if (this$colorString == null ? other$colorString != null : !((Object)this$colorString).equals(other$colorString)) {
            return false;
        }
        Color this$colorLabelString = this.getColorLabelString();
        Color other$colorLabelString = other.getColorLabelString();
        if (this$colorLabelString == null ? other$colorLabelString != null : !((Object)this$colorLabelString).equals(other$colorLabelString)) {
            return false;
        }
        Color this$colorDataGroupLabel = this.getColorDataGroupLabel();
        Color other$colorDataGroupLabel = other.getColorDataGroupLabel();
        return !(this$colorDataGroupLabel == null ? other$colorDataGroupLabel != null : !((Object)this$colorDataGroupLabel).equals(other$colorDataGroupLabel));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Renderer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMarginLeft();
        result = result * 59 + this.getMarginBottom();
        result = result * 59 + this.getMarginTop();
        result = result * 59 + this.getLineHeight();
        result = result * 59 + this.getPageDrawableWidth();
        result = result * 59 + this.getPadding();
        result = result * 59 + this.getPageHeight();
        result = result * 59 + this.getBaseX();
        result = result * 59 + this.getFontValueSize();
        result = result * 59 + this.getFontLabelSize();
        result = result * 59 + this.getFontTitleSize();
        result = result * 59 + Float.floatToIntBits(this.getStrokeWidth());
        IPdfDrawer $pdfDrawer = this.getPdfDrawer();
        result = result * 59 + ($pdfDrawer == null ? 43 : $pdfDrawer.hashCode());
        PdfResource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        Color $colorString = this.getColorString();
        result = result * 59 + ($colorString == null ? 43 : ((Object)$colorString).hashCode());
        Color $colorLabelString = this.getColorLabelString();
        result = result * 59 + ($colorLabelString == null ? 43 : ((Object)$colorLabelString).hashCode());
        Color $colorDataGroupLabel = this.getColorDataGroupLabel();
        result = result * 59 + ($colorDataGroupLabel == null ? 43 : ((Object)$colorDataGroupLabel).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Renderer(pdfDrawer=" + this.getPdfDrawer() + ", resource=" + this.getResource() + ", marginLeft=" + this.getMarginLeft() + ", marginBottom=" + this.getMarginBottom() + ", marginTop=" + this.getMarginTop() + ", lineHeight=" + this.getLineHeight() + ", pageDrawableWidth=" + this.getPageDrawableWidth() + ", padding=" + this.getPadding() + ", pageHeight=" + this.getPageHeight() + ", baseX=" + this.getBaseX() + ", fontValueSize=" + this.getFontValueSize() + ", fontLabelSize=" + this.getFontLabelSize() + ", fontTitleSize=" + this.getFontTitleSize() + ", strokeWidth=" + this.getStrokeWidth() + ", colorString=" + this.getColorString() + ", colorLabelString=" + this.getColorLabelString() + ", colorDataGroupLabel=" + this.getColorDataGroupLabel() + ")";
    }
}

