/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.domain.PdfSelectionField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.FieldRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SelectionFieldRenderer
extends FieldRenderer {
    public void renderValue(PdfSelectionField field, int lineCounter) throws IOException {
        int maxLineSize = this.getMaxValueLineSize(field.getWidth() - 3 * this.padding);
        int x = field.getX() + 4 * this.padding;
        int y = this.renderLinePosY(field, lineCounter);
        for (final String choice : field.getChoices()) {
            boolean buttonDrawn = false;
            float textWidth = SelectionFieldRenderer.getTextWidth(Collections.singletonList(choice), this.resource.getValueFont(), this.fontValueSize, this.resource);
            List<String> multiLineText = new ArrayList<String>(){
                {
                    this.add(choice);
                }
            };
            if (textWidth > (float)(field.getWidth() - 4 * this.padding)) {
                multiLineText = FieldBuilder.generateMultiLineText(Collections.singletonList(choice), maxLineSize);
            }
            for (String line : multiLineText) {
                ++lineCounter;
                lineCounter = this.renderPageBrake(field, lineCounter, y);
                y = this.renderLinePosY(field, lineCounter);
                this.pdfDrawer.writeString(this.resource.getValueFont(), this.fontValueSize, x, y, line, this.colorString);
                if (buttonDrawn) continue;
                buttonDrawn = this.pdfDrawer.drawSelectionButton(field.getValues(), choice, field.getX() + this.padding, y, field.getType());
            }
        }
        this.pdfDrawer.checkOpenPages();
    }
}

