/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfTextField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.FieldRenderer;
import java.io.IOException;
import java.util.List;

public class TextFieldRenderer
extends FieldRenderer {
    public void setFieldParams(PdfField field) {
        this.helperField = new PdfTextField(field.getFieldId(), field.getLabel(), field.getValues(), field.getType(), this.resource.getBaseX() + field.getX(), this.resource.getBaseY() - field.getBottomY(), field.getWidth(), field.getHeight(), this.resource);
    }

    @Override
    public int renderLabel(PdfField field) throws IOException {
        this.setFieldParams(field);
        return this.renderLabel(this.helperField, this.resource.getLabelFont(), this.fontLabelSize, this.colorLabelString);
    }

    @Override
    public void renderValue(PdfField field, int lineCounter) throws IOException {
        this.setFieldParams(field);
        this.renderValue(this.helperField, lineCounter, this.strokeWidth);
    }

    private void renderValue(PdfField field, int lineCounter, float strokeWidth) throws IOException {
        float textWidth = TextFieldRenderer.getTextWidth(field.getValues(), this.resource.getValueFont(), this.fontValueSize, this.resource);
        int maxLineSize = this.getMaxValueLineSize(field.getWidth() - 3 * this.padding);
        List<String> multiLineText = field.getValues();
        int x = field.getX() + this.padding;
        int y = this.renderLinePosY(field, lineCounter);
        int strokeLineCounter = 0;
        if (textWidth > (float)(field.getWidth() - 3 * this.padding)) {
            multiLineText = FieldBuilder.generateMultiLineText(field.getValues(), maxLineSize);
        }
        for (String line : multiLineText) {
            ++lineCounter;
            strokeLineCounter = (lineCounter = this.renderPageBrake(field, lineCounter, strokeLineCounter, y)) == 1 ? 0 : strokeLineCounter;
            y = this.renderLinePosY(field, lineCounter);
            ++strokeLineCounter;
            this.pdfDrawer.writeString(this.resource.getValueFont(), this.fontValueSize, x, y, line, this.colorString);
        }
        if (this.resource.isTextFieldStroke()) {
            this.pdfDrawer.drawStroke(field.getX(), y, field.getBottomY(), field.getWidth(), strokeLineCounter, strokeWidth);
        }
        this.pdfDrawer.checkOpenPages();
    }
}

