/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.pdf.generator.service.renderer;

import com.netgrif.application.engine.pdf.generator.domain.PdfField;
import com.netgrif.application.engine.pdf.generator.domain.PdfTitleField;
import com.netgrif.application.engine.pdf.generator.service.fieldbuilder.FieldBuilder;
import com.netgrif.application.engine.pdf.generator.service.renderer.Renderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TitleRenderer
extends Renderer {
    private int fieldY;
    private int fieldWidth;
    private String label;

    public void setFieldParams(PdfTitleField field) {
        this.fieldY = field.getBottomY();
        this.fieldWidth = field.getWidth();
        this.label = field.getLabel();
    }

    @Override
    public int renderLabel(PdfField field) throws IOException {
        this.setFieldParams((PdfTitleField)field);
        this.renderTitle(this.label, this.fieldY, this.fieldWidth);
        return 0;
    }

    private void renderTitle(String title, int fieldY, int fieldWidth) throws IOException {
        float textWidth = TitleRenderer.getTextWidth(Collections.singletonList(title), this.resource.getTitleFont(), this.fontTitleSize, this.resource);
        List<String> multiLineText = new ArrayList<String>();
        int lineCounter = 0;
        int x = (int)((float)this.baseX + ((float)this.pageDrawableWidth - textWidth) / 2.0f);
        int maxLineSize = this.getMaxLabelLineSize(fieldWidth, this.fontTitleSize);
        multiLineText.add(title);
        if (textWidth > (float)(fieldWidth - 2 * this.padding)) {
            x = this.baseX;
            multiLineText = FieldBuilder.generateMultiLineText(Collections.singletonList(title), maxLineSize);
        }
        for (String line : multiLineText) {
            int y = this.pageHeight - this.resource.getMarginTitle() - fieldY - this.lineHeight * lineCounter;
            this.pdfDrawer.writeString(this.resource.getTitleFont(), this.fontTitleSize, x, y, line, this.colorString);
            ++lineCounter;
        }
    }
}

