/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netgrif.application.engine.petrinet.domain.Component;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldLayout;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.events.DataEvent;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class DataFieldLogic
implements Serializable {
    private static final long serialVersionUID = 6561411252131004710L;
    private Set<FieldBehavior> behavior = new HashSet<FieldBehavior>();
    private Map<DataEventType, DataEvent> events = new HashMap<DataEventType, DataEvent>();
    private FieldLayout layout = new FieldLayout();
    private Component component;

    public DataFieldLogic() {
    }

    public DataFieldLogic(Set<FieldBehavior> behavior, Map<DataEventType, DataEvent> events, FieldLayout layout, Component component) {
        this();
        this.behavior.addAll(behavior);
        this.events = events;
        this.layout = layout;
        if (component != null) {
            this.component = component;
        }
    }

    public static List<Action> getEventAction(DataEvent event, EventPhase phase) {
        if (phase == null) {
            phase = event.getDefaultPhase();
        }
        if (phase.equals((Object)EventPhase.PRE)) {
            return event.getPreActions();
        }
        return event.getPostActions();
    }

    public ObjectNode applyBehavior(ObjectNode jsonNode) {
        this.behavior.forEach(fieldBehavior -> jsonNode.put(fieldBehavior.toString(), true));
        return jsonNode;
    }

    public ObjectNode applyBehavior() {
        return this.applyBehavior(JsonNodeFactory.instance.objectNode());
    }

    public boolean isDisplayable() {
        return this.behavior.contains((Object)FieldBehavior.EDITABLE) || this.behavior.contains((Object)FieldBehavior.VISIBLE) || this.behavior.contains((Object)FieldBehavior.HIDDEN);
    }

    public boolean isDisplayableForCase() {
        return this.behavior.contains((Object)FieldBehavior.EDITABLE) || this.behavior.contains((Object)FieldBehavior.VISIBLE) || this.behavior.contains((Object)FieldBehavior.HIDDEN);
    }

    public boolean isRequired() {
        return this.behavior.contains((Object)FieldBehavior.REQUIRED);
    }

    public String toString() {
        return this.behavior.stream().map(FieldBehavior::toString).collect(Collectors.joining(", "));
    }

    public boolean isForbidden() {
        return this.behavior.contains((Object)FieldBehavior.FORBIDDEN);
    }

    public boolean layoutExist() {
        return this.layout != null;
    }

    public DataFieldLogic clone() {
        DataFieldLogic clone = new DataFieldLogic();
        clone.setBehavior(new HashSet<FieldBehavior>(this.behavior));
        clone.setLayout(this.layout == null ? null : this.layout.clone());
        clone.setEvents(this.events == null ? null : this.events.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DataEvent)e.getValue()).clone())));
        clone.setComponent(this.component == null ? null : this.component.clone());
        return clone;
    }

    @Generated
    public Set<FieldBehavior> getBehavior() {
        return this.behavior;
    }

    @Generated
    public void setBehavior(Set<FieldBehavior> behavior) {
        this.behavior = behavior;
    }

    @Generated
    public Map<DataEventType, DataEvent> getEvents() {
        return this.events;
    }

    @Generated
    public void setEvents(Map<DataEventType, DataEvent> events) {
        this.events = events;
    }

    @Generated
    public FieldLayout getLayout() {
        return this.layout;
    }

    @Generated
    public void setLayout(FieldLayout layout) {
        this.layout = layout;
    }

    @Generated
    public Component getComponent() {
        return this.component;
    }

    @Generated
    public void setComponent(Component component) {
        this.component = component;
    }
}

