/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNetObject;
import com.netgrif.application.engine.petrinet.domain.layout.DataGroupLayout;
import com.netgrif.application.engine.workflow.web.responsebodies.DataFieldsResource;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class DataGroup
extends PetriNetObject {
    @JsonIgnore
    private Set<String> data;
    @Transient
    private DataFieldsResource fields;
    private DataGroupLayout layout;
    private I18nString title;
    private String alignment;
    private Boolean stretch;
    @Transient
    private String parentTaskId;
    @Transient
    private String parentTransitionId;
    @Transient
    private String parentCaseId;
    @Transient
    private String parentTaskRefId;
    @Transient
    private int nestingLevel;

    public DataGroup() {
        this._id = new ObjectId();
        this.data = new LinkedHashSet<String>();
    }

    public void addData(String dataId) {
        this.data.add(dataId);
    }

    public void setTitle(I18nString title) {
        this.title = title;
    }

    public String getTranslatedTitle(Locale locale) {
        if (this.title == null) {
            return null;
        }
        return this.title.getTranslation(locale);
    }

    public DataGroup clone() {
        DataGroup group = new DataGroup();
        group.setImportId(this.getImportId());
        group.setTitle(this.getTitle());
        group.setData(this.getData());
        group.setLayout(this.getLayout());
        group.setAlignment(this.getAlignment());
        group.setStretch(this.getStretch());
        return group;
    }

    @Generated
    public Set<String> getData() {
        return this.data;
    }

    @JsonIgnore
    @Generated
    public void setData(Set<String> data) {
        this.data = data;
    }

    @Generated
    public DataFieldsResource getFields() {
        return this.fields;
    }

    @Generated
    public void setFields(DataFieldsResource fields) {
        this.fields = fields;
    }

    @Generated
    public DataGroupLayout getLayout() {
        return this.layout;
    }

    @Generated
    public void setLayout(DataGroupLayout layout) {
        this.layout = layout;
    }

    @Generated
    public I18nString getTitle() {
        return this.title;
    }

    @Generated
    public String getAlignment() {
        return this.alignment;
    }

    @Generated
    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    @Generated
    public Boolean getStretch() {
        return this.stretch;
    }

    @Generated
    public void setStretch(Boolean stretch) {
        this.stretch = stretch;
    }

    @Generated
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Generated
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Generated
    public String getParentTransitionId() {
        return this.parentTransitionId;
    }

    @Generated
    public void setParentTransitionId(String parentTransitionId) {
        this.parentTransitionId = parentTransitionId;
    }

    @Generated
    public String getParentCaseId() {
        return this.parentCaseId;
    }

    @Generated
    public void setParentCaseId(String parentCaseId) {
        this.parentCaseId = parentCaseId;
    }

    @Generated
    public String getParentTaskRefId() {
        return this.parentTaskRefId;
    }

    @Generated
    public void setParentTaskRefId(String parentTaskRefId) {
        this.parentTaskRefId = parentTaskRefId;
    }

    @Generated
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Generated
    public void setNestingLevel(int nestingLevel) {
        this.nestingLevel = nestingLevel;
    }
}

