/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public class I18nString
implements Serializable {
    private static final long serialVersionUID = 3815235231390109824L;
    private String defaultValue;
    private String key;
    private Map<String, String> translations = new HashMap<String, String>();

    public I18nString() {
    }

    public I18nString(String defaultValue) {
        this();
        this.defaultValue = defaultValue;
    }

    public I18nString(String key, String defaultValue) {
        this(defaultValue);
        this.key = key;
    }

    public I18nString(I18nString other) {
        this(other.defaultValue);
        this.key = other.key;
        this.translations.putAll(other.translations);
    }

    public I18nString(String defaultValue, Map<String, String> translations) {
        this(defaultValue);
        this.translations = translations;
    }

    public void addTranslation(String locale, String translation) {
        this.translations.put(locale, translation);
    }

    public String getTranslation(String locale) {
        return this.translations.getOrDefault(locale, this.defaultValue);
    }

    public String getTranslation(Locale locale) {
        if (locale == null) {
            return this.defaultValue;
        }
        return this.getTranslation(locale.getLanguage());
    }

    public String toString() {
        return this.defaultValue;
    }

    public boolean equals(String string) {
        if (this.defaultValue == null) {
            return false;
        }
        return this.defaultValue.equals(string);
    }

    public boolean contains(String value) {
        if (this.defaultValue != null && this.defaultValue.equals(value)) {
            return true;
        }
        for (String s : this.translations.values()) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            return o.equals(this.defaultValue);
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I18nString that = (I18nString)o;
        return (this.key == null ? that.key == null : this.key.equals(that.key)) && (this.defaultValue == null ? that.defaultValue == null : this.defaultValue.equals(that.defaultValue)) && this.translations.equals(that.translations);
    }

    public I18nString clone() {
        I18nString clone = new I18nString();
        clone.setKey(this.key);
        clone.setDefaultValue(this.defaultValue);
        clone.setTranslations(new HashMap<String, String>(this.translations));
        return clone;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Map<String, String> getTranslations() {
        return this.translations;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setTranslations(Map<String, String> translations) {
        this.translations = translations;
    }
}

