/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import java.io.IOException;
import java.util.HashMap;

public class I18nStringDeserializer
extends StdDeserializer<I18nString> {
    public I18nStringDeserializer() {
        this(null);
    }

    public I18nStringDeserializer(Class<?> vc) {
        super(vc);
    }

    public I18nString deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.isTextual()) {
            return new I18nString(node.asText());
        }
        String defaultValue = node.get("defaultValue").asText();
        I18nString text = new I18nString(defaultValue);
        if (!node.get("key").isNull()) {
            text.setKey(node.get("key").asText());
        }
        if (!node.get("translations").isNull()) {
            HashMap<String, String> translations = new HashMap<String, String>();
            node.get("translations").fields().forEachRemaining(entry -> translations.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText()));
            text.setTranslations(translations);
        }
        return text;
    }
}

