/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.netgrif.application.engine.auth.domain.Author;
import com.netgrif.application.engine.petrinet.domain.Function;
import com.netgrif.application.engine.petrinet.domain.FunctionScope;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.Node;
import com.netgrif.application.engine.petrinet.domain.PetriNetObject;
import com.netgrif.application.engine.petrinet.domain.Place;
import com.netgrif.application.engine.petrinet.domain.Transaction;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.VersionType;
import com.netgrif.application.engine.petrinet.domain.arcs.Arc;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Referencable;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Type;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.Expression;
import com.netgrif.application.engine.petrinet.domain.events.CaseEvent;
import com.netgrif.application.engine.petrinet.domain.events.CaseEventType;
import com.netgrif.application.engine.petrinet.domain.events.ProcessEvent;
import com.netgrif.application.engine.petrinet.domain.events.ProcessEventType;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.version.Version;
import com.netgrif.application.engine.workflow.domain.DataField;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class PetriNet
extends PetriNetObject {
    private String identifier;
    private String uriNodeId;
    private I18nString title;
    private boolean defaultRoleEnabled;
    private boolean anonymousRoleEnabled;
    private I18nString defaultCaseName;
    private Expression defaultCaseNameExpression;
    private String initials;
    private String icon;
    private LocalDateTime creationDate;
    private Version version;
    private Author author;
    @org.springframework.data.mongodb.core.mapping.Field(value="places")
    private LinkedHashMap<String, Place> places;
    @org.springframework.data.mongodb.core.mapping.Field(value="transitions")
    private LinkedHashMap<String, Transition> transitions;
    @org.springframework.data.mongodb.core.mapping.Field(value="arcs")
    private LinkedHashMap<String, List<Arc>> arcs;
    @org.springframework.data.mongodb.core.mapping.Field(value="dataset")
    private LinkedHashMap<String, Field> dataSet;
    @org.springframework.data.mongodb.core.mapping.Field(value="roles")
    @DBRef
    private LinkedHashMap<String, ProcessRole> roles;
    @org.springframework.data.mongodb.core.mapping.Field(value="transactions")
    private LinkedHashMap<String, Transaction> transactions;
    private Map<ProcessEventType, ProcessEvent> processEvents;
    private Map<CaseEventType, CaseEvent> caseEvents;
    private Map<String, Map<String, Boolean>> permissions;
    private List<String> negativeViewRoles;
    private Map<String, Map<String, Boolean>> userRefs;
    private List<Function> functions;
    @Transient
    private boolean initialized;
    private String importXmlPath;
    private Map<String, String> tags;

    public PetriNet() {
        this._id = new ObjectId();
        this.identifier = "Default";
        this.initials = "";
        this.title = new I18nString("");
        this.importId = "";
        this.version = new Version();
        this.defaultCaseName = new I18nString("");
        this.initialized = false;
        this.creationDate = LocalDateTime.now();
        this.places = new LinkedHashMap();
        this.transitions = new LinkedHashMap();
        this.arcs = new LinkedHashMap();
        this.dataSet = new LinkedHashMap();
        this.roles = new LinkedHashMap();
        this.negativeViewRoles = new LinkedList<String>();
        this.transactions = new LinkedHashMap();
        this.processEvents = new LinkedHashMap<ProcessEventType, ProcessEvent>();
        this.caseEvents = new LinkedHashMap<CaseEventType, CaseEvent>();
        this.permissions = new HashMap<String, Map<String, Boolean>>();
        this.userRefs = new HashMap<String, Map<String, Boolean>>();
        this.functions = new LinkedList<Function>();
        this.tags = new HashMap<String, String>();
    }

    public void addPlace(Place place) {
        this.places.put(place.getStringId(), place);
    }

    public void addTransition(Transition transition) {
        this.transitions.put(transition.getStringId(), transition);
    }

    public void addRole(ProcessRole role) {
        this.roles.put(role.getStringId(), role);
    }

    public void addPermission(String roleId, Map<String, Boolean> permissions) {
        if (this.permissions.containsKey(roleId) && this.permissions.get(roleId) != null) {
            this.permissions.get(roleId).putAll(permissions);
        } else {
            this.permissions.put(roleId, permissions);
        }
    }

    public void addNegativeViewRole(String roleId) {
        this.negativeViewRoles.add(roleId);
    }

    public void addFunction(Function function) {
        this.functions.add(function);
    }

    public void addUserPermission(String usersRefId, Map<String, Boolean> permissions) {
        if (this.userRefs.containsKey(usersRefId) && this.userRefs.get(usersRefId) != null) {
            this.userRefs.get(usersRefId).putAll(permissions);
        } else {
            this.userRefs.put(usersRefId, permissions);
        }
    }

    public List<Arc> getArcsOfTransition(Transition transition) {
        return this.getArcsOfTransition(transition.getStringId());
    }

    public List<Arc> getArcsOfTransition(String transitionId) {
        if (this.arcs.containsKey(transitionId)) {
            return this.arcs.get(transitionId);
        }
        return new LinkedList<Arc>();
    }

    public void addDataSetField(Field field) {
        this.dataSet.put(field.getStringId(), field);
    }

    public boolean isNotInitialized() {
        return !this.initialized;
    }

    public void addArc(Arc arc) {
        String transitionId = arc.getTransition().getStringId();
        if (this.arcs.containsKey(transitionId)) {
            this.arcs.get(transitionId).add(arc);
        } else {
            LinkedList<Arc> arcList = new LinkedList<Arc>();
            arcList.add(arc);
            this.arcs.put(transitionId, arcList);
        }
    }

    public Node getNode(String importId) {
        if (this.places.containsKey(importId)) {
            return this.getPlace(importId);
        }
        if (this.transitions.containsKey(importId)) {
            return this.getTransition(importId);
        }
        return null;
    }

    public Optional<Field> getField(String id) {
        return Optional.ofNullable(this.dataSet.get(id));
    }

    public Place getPlace(String id) {
        return this.places.get(id);
    }

    public Transition getTransition(String id) {
        return this.transitions.get(id);
    }

    public void initializeArcs() {
        this.arcs.values().forEach(list -> list.forEach(arc -> {
            arc.setSource(this.getNode(arc.getSourceId()));
            arc.setDestination(this.getNode(arc.getDestinationId()));
        }));
        this.initialized = true;
    }

    public void initializeTokens(Map<String, Integer> activePlaces) {
        this.places.values().forEach(place -> place.setTokens(activePlaces.getOrDefault(place.getStringId(), 0)));
    }

    public void initializeArcs(Map<String, DataField> dataSet) {
        this.arcs.values().stream().flatMap(Collection::stream).filter(arc -> arc.getReference() != null).forEach(arc -> {
            String referenceId = arc.getReference().getReference();
            arc.getReference().setReferencable(this.getArcReference(referenceId, arc.getReference().getType(), dataSet));
        });
    }

    private Referencable getArcReference(String referenceId, Type type, Map<String, DataField> dataSet) {
        if (type == Type.PLACE) {
            return this.places.get(referenceId);
        }
        return dataSet.get(referenceId);
    }

    public Map<String, Integer> getActivePlaces() {
        HashMap<String, Integer> activePlaces = new HashMap<String, Integer>();
        for (Place place : this.places.values()) {
            if (place.getTokens() <= 0) continue;
            activePlaces.put(place.getStringId(), place.getTokens());
        }
        return activePlaces;
    }

    public void addTransaction(Transaction transaction) {
        this.transactions.put(transaction.getStringId(), transaction);
    }

    public Transaction getTransactionByTransition(Transition transition) {
        return this.transactions.values().stream().filter(transaction -> transaction.getTransitions().contains(transition.getStringId())).findAny().orElse(null);
    }

    public List<Field> getImmediateFields() {
        return this.dataSet.values().stream().filter(Field::isImmediate).collect(Collectors.toList());
    }

    public boolean isDisplayableInAnyTransition(String fieldId) {
        return ((Stream)this.transitions.values().stream().parallel()).anyMatch(trans -> trans.isDisplayable(fieldId));
    }

    public void incrementVersion(VersionType type) {
        this.version.increment(type);
    }

    public String toString() {
        return this.title.toString();
    }

    public void setTitle(I18nString title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.setTitle(new I18nString(title));
    }

    public String getTranslatedDefaultCaseName(Locale locale) {
        if (this.defaultCaseName == null) {
            return "";
        }
        return this.defaultCaseName.getTranslation(locale);
    }

    public String getTranslatedTitle(Locale locale) {
        if (this.title == null) {
            return "";
        }
        return this.title.getTranslation(locale);
    }

    public List<Function> getFunctions(FunctionScope scope) {
        return this.functions.stream().filter(function -> function.getScope().equals((Object)scope)).collect(Collectors.toList());
    }

    public List<Action> getPreCreateActions() {
        return this.getPreCaseActions(CaseEventType.CREATE);
    }

    public List<Action> getPostCreateActions() {
        return this.getPostCaseActions(CaseEventType.CREATE);
    }

    public List<Action> getPreDeleteActions() {
        return this.getPreCaseActions(CaseEventType.DELETE);
    }

    public List<Action> getPostDeleteActions() {
        return this.getPostCaseActions(CaseEventType.DELETE);
    }

    public List<Action> getPreUploadActions() {
        return this.getPreProcessActions(ProcessEventType.UPLOAD);
    }

    public List<Action> getPostUploadActions() {
        return this.getPostProcessActions(ProcessEventType.UPLOAD);
    }

    private List<Action> getPreCaseActions(CaseEventType type) {
        if (this.caseEvents.containsKey((Object)type)) {
            return this.caseEvents.get((Object)type).getPreActions();
        }
        return new LinkedList<Action>();
    }

    private List<Action> getPostCaseActions(CaseEventType type) {
        if (this.caseEvents.containsKey((Object)type)) {
            return this.caseEvents.get((Object)type).getPostActions();
        }
        return new LinkedList<Action>();
    }

    private List<Action> getPreProcessActions(ProcessEventType type) {
        if (this.processEvents.containsKey((Object)type)) {
            return this.processEvents.get((Object)type).getPreActions();
        }
        return new LinkedList<Action>();
    }

    private List<Action> getPostProcessActions(ProcessEventType type) {
        if (this.processEvents.containsKey((Object)type)) {
            return this.processEvents.get((Object)type).getPostActions();
        }
        return new LinkedList<Action>();
    }

    public boolean hasDynamicCaseName() {
        return this.defaultCaseNameExpression != null;
    }

    @Override
    public String getStringId() {
        return this._id.toString();
    }

    public PetriNet clone() {
        PetriNet clone = new PetriNet();
        clone.setIdentifier(this.identifier);
        clone.setUriNodeId(this.uriNodeId);
        clone.setInitials(this.initials);
        clone.setTitle(this.title.clone());
        clone.setDefaultRoleEnabled(this.defaultRoleEnabled);
        clone.setDefaultCaseName(this.defaultCaseName == null ? null : this.defaultCaseName.clone());
        clone.setDefaultCaseNameExpression(this.defaultCaseNameExpression == null ? null : this.defaultCaseNameExpression.clone());
        clone.setIcon(this.icon);
        clone.setCreationDate(this.creationDate);
        clone.setVersion(this.version == null ? null : this.version.clone());
        clone.setAuthor(this.author == null ? null : this.author.clone());
        clone.setTransitions(this.transitions == null ? null : this.transitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Transition)e.getValue()).clone(), (v1, v2) -> v1, LinkedHashMap::new)));
        clone.setRoles(this.roles == null ? null : this.roles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProcessRole)e.getValue()).clone(), (v1, v2) -> v1, LinkedHashMap::new)));
        clone.setTransactions(this.transactions == null ? null : this.transactions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Transaction)e.getValue()).clone(), (v1, v2) -> v1, LinkedHashMap::new)));
        clone.setImportXmlPath(this.importXmlPath);
        clone.setImportId(this.importId);
        clone.setObjectId(this._id);
        clone.setDataSet(this.dataSet.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Field)e.getValue()).clone(), (x, y) -> y, LinkedHashMap::new)));
        clone.setPlaces(this.places.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Place)e.getValue()).clone(), (x, y) -> y, LinkedHashMap::new)));
        clone.setArcs(this.arcs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(Arc::clone).collect(Collectors.toList()), (x, y) -> y, LinkedHashMap::new)));
        clone.initializeArcs();
        clone.setCaseEvents(this.caseEvents == null ? null : this.caseEvents.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((CaseEvent)e.getValue()).clone())));
        clone.setProcessEvents(this.processEvents == null ? null : this.processEvents.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ProcessEvent)e.getValue()).clone())));
        clone.setPermissions(this.permissions == null ? null : this.permissions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue()))));
        clone.setUserRefs(this.userRefs == null ? null : this.userRefs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue()))));
        this.getNegativeViewRoles().forEach(clone::addNegativeViewRole);
        this.getFunctions().forEach(clone::addFunction);
        clone.setTags(new HashMap<String, String>(this.tags));
        return clone;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public String getUriNodeId() {
        return this.uriNodeId;
    }

    @Generated
    public void setUriNodeId(String uriNodeId) {
        this.uriNodeId = uriNodeId;
    }

    @Generated
    public I18nString getTitle() {
        return this.title;
    }

    @Generated
    public boolean isDefaultRoleEnabled() {
        return this.defaultRoleEnabled;
    }

    @Generated
    public void setDefaultRoleEnabled(boolean defaultRoleEnabled) {
        this.defaultRoleEnabled = defaultRoleEnabled;
    }

    @Generated
    public boolean isAnonymousRoleEnabled() {
        return this.anonymousRoleEnabled;
    }

    @Generated
    public void setAnonymousRoleEnabled(boolean anonymousRoleEnabled) {
        this.anonymousRoleEnabled = anonymousRoleEnabled;
    }

    @Generated
    public I18nString getDefaultCaseName() {
        return this.defaultCaseName;
    }

    @Generated
    public void setDefaultCaseName(I18nString defaultCaseName) {
        this.defaultCaseName = defaultCaseName;
    }

    @Generated
    public Expression getDefaultCaseNameExpression() {
        return this.defaultCaseNameExpression;
    }

    @Generated
    public void setDefaultCaseNameExpression(Expression defaultCaseNameExpression) {
        this.defaultCaseNameExpression = defaultCaseNameExpression;
    }

    @Generated
    public String getInitials() {
        return this.initials;
    }

    @Generated
    public void setInitials(String initials) {
        this.initials = initials;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    @Generated
    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(Version version) {
        this.version = version;
    }

    @Generated
    public Author getAuthor() {
        return this.author;
    }

    @Generated
    public void setAuthor(Author author) {
        this.author = author;
    }

    @Generated
    public LinkedHashMap<String, Place> getPlaces() {
        return this.places;
    }

    @Generated
    public void setPlaces(LinkedHashMap<String, Place> places) {
        this.places = places;
    }

    @Generated
    public LinkedHashMap<String, Transition> getTransitions() {
        return this.transitions;
    }

    @Generated
    public void setTransitions(LinkedHashMap<String, Transition> transitions) {
        this.transitions = transitions;
    }

    @Generated
    public LinkedHashMap<String, List<Arc>> getArcs() {
        return this.arcs;
    }

    @Generated
    public void setArcs(LinkedHashMap<String, List<Arc>> arcs) {
        this.arcs = arcs;
    }

    @Generated
    public LinkedHashMap<String, Field> getDataSet() {
        return this.dataSet;
    }

    @Generated
    public void setDataSet(LinkedHashMap<String, Field> dataSet) {
        this.dataSet = dataSet;
    }

    @Generated
    public LinkedHashMap<String, ProcessRole> getRoles() {
        return this.roles;
    }

    @Generated
    public void setRoles(LinkedHashMap<String, ProcessRole> roles) {
        this.roles = roles;
    }

    @Generated
    public LinkedHashMap<String, Transaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public void setTransactions(LinkedHashMap<String, Transaction> transactions) {
        this.transactions = transactions;
    }

    @Generated
    public Map<ProcessEventType, ProcessEvent> getProcessEvents() {
        return this.processEvents;
    }

    @Generated
    public void setProcessEvents(Map<ProcessEventType, ProcessEvent> processEvents) {
        this.processEvents = processEvents;
    }

    @Generated
    public Map<CaseEventType, CaseEvent> getCaseEvents() {
        return this.caseEvents;
    }

    @Generated
    public void setCaseEvents(Map<CaseEventType, CaseEvent> caseEvents) {
        this.caseEvents = caseEvents;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setPermissions(Map<String, Map<String, Boolean>> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public List<String> getNegativeViewRoles() {
        return this.negativeViewRoles;
    }

    @Generated
    public void setNegativeViewRoles(List<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUserRefs() {
        return this.userRefs;
    }

    @Generated
    public void setUserRefs(Map<String, Map<String, Boolean>> userRefs) {
        this.userRefs = userRefs;
    }

    @Generated
    public List<Function> getFunctions() {
        return this.functions;
    }

    @Generated
    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    @Generated
    public String getImportXmlPath() {
        return this.importXmlPath;
    }

    @Generated
    public void setImportXmlPath(String importXmlPath) {
        this.importXmlPath = importXmlPath;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

