/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.netgrif.application.engine.petrinet.domain.Node;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Referencable;
import lombok.Generated;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Place
extends Node
implements Referencable {
    private Integer tokens;
    private Boolean isStatic;

    public void addTokens(int tokens) {
        this.tokens = this.tokens + tokens;
    }

    public void removeTokens(Integer tokens) throws IllegalArgumentException {
        if (this.tokens - tokens < 0) {
            throw new IllegalArgumentException("Place can not have negative number of tokens.");
        }
        this.tokens = this.tokens - tokens;
    }

    public void removeAllTokens() {
        this.tokens = 0;
    }

    public String toString() {
        return this.getTitle() + " (" + this.tokens + ")";
    }

    public Place clone() {
        Place clone = new Place();
        clone.setTokens(this.tokens);
        clone.setIsStatic(this.isStatic);
        clone.setTitle(this.getTitle());
        clone.setPosition(this.getPosition());
        clone.setObjectId(this.getObjectId());
        clone.setImportId(this.getImportId());
        return clone;
    }

    @Override
    public int getMultiplicity() {
        return this.tokens;
    }

    @Generated
    public Integer getTokens() {
        return this.tokens;
    }

    @Generated
    public void setTokens(Integer tokens) {
        this.tokens = tokens;
    }

    @Generated
    public Boolean getIsStatic() {
        return this.isStatic;
    }

    @Generated
    public void setIsStatic(Boolean isStatic) {
        this.isStatic = isStatic;
    }
}

