/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.PetriNetObject;
import com.netgrif.application.engine.petrinet.domain.Transition;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Transaction
extends PetriNetObject {
    private List<String> transitions;
    private I18nString title;

    public Transaction() {
        this._id = new ObjectId();
        this.transitions = new LinkedList<String>();
    }

    public void addTransition(Transition transition) {
        this.transitions.add(transition.getStringId());
    }

    public void setTitle(I18nString title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.setTitle(new I18nString(title));
    }

    public String toString() {
        return this.title.getDefaultValue();
    }

    public Transaction clone() {
        Transaction clone = new Transaction();
        clone.setTransitions(new ArrayList<String>(this.transitions));
        clone.setTitle(this.title == null ? null : this.title.clone());
        return clone;
    }

    @Generated
    public List<String> getTransitions() {
        return this.transitions;
    }

    @Generated
    public void setTransitions(List<String> transitions) {
        this.transitions = transitions;
    }

    @Generated
    public I18nString getTitle() {
        return this.title;
    }
}

