/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.netgrif.application.engine.petrinet.domain.Component;
import com.netgrif.application.engine.petrinet.domain.DataFieldLogic;
import com.netgrif.application.engine.petrinet.domain.DataGroup;
import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.Node;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldLayout;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.events.DataEvent;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.Event;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.layout.TaskLayout;
import com.netgrif.application.engine.petrinet.domain.policies.AssignPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.DataFocusPolicy;
import com.netgrif.application.engine.petrinet.domain.policies.FinishPolicy;
import com.netgrif.application.engine.workflow.domain.triggers.AutoTrigger;
import com.netgrif.application.engine.workflow.domain.triggers.Trigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document
public class Transition
extends Node {
    @Field(value="dataGroups")
    private Map<String, DataGroup> dataGroups;
    @Field(value="dataSet")
    private LinkedHashMap<String, DataFieldLogic> dataSet = new LinkedHashMap();
    @Field(value="roles")
    private Map<String, Map<String, Boolean>> roles = new HashMap<String, Map<String, Boolean>>();
    private List<String> negativeViewRoles;
    @Field(value="users")
    private Map<String, Map<String, Boolean>> userRefs = new HashMap<String, Map<String, Boolean>>();
    @Field(value="triggers")
    private List<Trigger> triggers = new LinkedList<Trigger>();
    private TaskLayout layout;
    private Integer priority;
    private AssignPolicy assignPolicy;
    private String icon;
    private DataFocusPolicy dataFocusPolicy;
    private FinishPolicy finishPolicy;
    private Map<EventType, Event> events;
    private Map<String, Boolean> assignedUserPolicy;
    private String defaultRoleId;
    @Transient
    private Boolean hasAutoTrigger;
    private Map<String, String> tags;

    public Transition() {
        this.negativeViewRoles = new LinkedList<String>();
        this.dataGroups = new LinkedHashMap<String, DataGroup>();
        this.assignPolicy = AssignPolicy.MANUAL;
        this.dataFocusPolicy = DataFocusPolicy.MANUAL;
        this.finishPolicy = FinishPolicy.MANUAL;
        this.events = new HashMap<EventType, Event>();
        this.assignedUserPolicy = new HashMap<String, Boolean>();
        this.tags = new HashMap<String, String>();
    }

    public void addDataSet(String field, Set<FieldBehavior> behavior, Map<DataEventType, DataEvent> events, FieldLayout layout, Component component) {
        if (this.dataSet.containsKey(field) && this.dataSet.get(field) != null) {
            if (behavior != null) {
                this.dataSet.get(field).getBehavior().addAll(behavior);
            }
            if (events != null) {
                this.dataSet.get(field).setEvents(events);
            }
            if (layout != null) {
                this.dataSet.get(field).setLayout(layout);
            }
            if (component != null) {
                this.dataSet.get(field).setComponent(component);
            }
        } else {
            this.dataSet.put(field, new DataFieldLogic(behavior, events, layout, component));
        }
    }

    public void setDataEvents(String field, Map<DataEventType, DataEvent> events) {
        if (this.dataSet.containsKey(field)) {
            this.dataSet.get(field).setEvents(events);
        }
    }

    public void addRole(String roleId, Map<String, Boolean> permissions) {
        if (this.roles.containsKey(roleId) && this.roles.get(roleId) != null) {
            this.roles.get(roleId).putAll(permissions);
        } else {
            this.roles.put(roleId, permissions);
        }
    }

    public void addNegativeViewRole(String roleId) {
        this.negativeViewRoles.add(roleId);
    }

    public void addUserRef(String userRefId, Map<String, Boolean> permissions) {
        if (this.userRefs.containsKey(userRefId) && this.userRefs.get(userRefId) != null) {
            this.userRefs.get(userRefId).putAll(permissions);
        } else {
            this.userRefs.put(userRefId, permissions);
        }
    }

    public void addDataGroup(DataGroup dataGroup) {
        this.dataGroups.put(dataGroup.getStringId(), dataGroup);
    }

    public void addTrigger(Trigger trigger) {
        this.triggers.add(trigger);
    }

    public boolean isDisplayable(String fieldId) {
        DataFieldLogic logic = this.dataSet.get(fieldId);
        return logic != null && logic.isDisplayable();
    }

    public List<String> getImmediateData() {
        return this.dataSet.entrySet().stream().filter(entry -> ((DataFieldLogic)entry.getValue()).getBehavior().contains((Object)FieldBehavior.IMMEDIATE)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Action> getPreFinishActions() {
        return this.getPreActions(EventType.FINISH);
    }

    public List<Action> getPostFinishActions() {
        return this.getPostActions(EventType.FINISH);
    }

    public List<Action> getPreAssignActions() {
        return this.getPreActions(EventType.ASSIGN);
    }

    public List<Action> getPostAssignActions() {
        return this.getPostActions(EventType.ASSIGN);
    }

    public List<Action> getPreCancelActions() {
        return this.getPreActions(EventType.CANCEL);
    }

    public List<Action> getPostCancelActions() {
        return this.getPostActions(EventType.CANCEL);
    }

    public List<Action> getPreDelegateActions() {
        return this.getPreActions(EventType.DELEGATE);
    }

    public List<Action> getPostDelegateActions() {
        return this.getPostActions(EventType.DELEGATE);
    }

    private List<Action> getPreActions(EventType type) {
        if (this.events.containsKey((Object)type)) {
            return this.events.get((Object)type).getPreActions();
        }
        return new LinkedList<Action>();
    }

    private List<Action> getPostActions(EventType type) {
        if (this.events.containsKey((Object)type)) {
            return this.events.get((Object)type).getPostActions();
        }
        return new LinkedList<Action>();
    }

    public I18nString getFinishMessage() {
        return this.getMessage(EventType.FINISH);
    }

    public I18nString getAssignMessage() {
        return this.getMessage(EventType.ASSIGN);
    }

    public I18nString getCancelMessage() {
        return this.getMessage(EventType.CANCEL);
    }

    public I18nString getDelegateMessage() {
        return this.getMessage(EventType.DELEGATE);
    }

    private I18nString getMessage(EventType type) {
        if (this.events.containsKey((Object)type)) {
            return this.events.get((Object)type).getMessage();
        }
        return null;
    }

    public String toString() {
        return this.getTitle().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition that = (Transition)o;
        return this.importId.equals(that.importId);
    }

    public void addEvent(Event event) {
        this.events.put(event.getType(), event);
    }

    public boolean hasAutoTrigger() {
        if (this.hasAutoTrigger == null) {
            this.hasAutoTrigger = this.getTriggers().stream().anyMatch(trigger -> trigger instanceof AutoTrigger);
        }
        return this.hasAutoTrigger;
    }

    public Transition clone() {
        Transition clone = new Transition();
        clone.setTitle(this.getTitle() == null ? null : this.getTitle().clone());
        clone.setPosition(this.getPosition().getX(), this.getPosition().getY());
        clone.setImportId(this.importId);
        clone.setDataGroups(this.dataGroups == null ? null : (Map)this.dataGroups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y.clone(), LinkedHashMap::new)));
        clone.setDataSet(this.dataSet == null ? null : this.dataSet.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y.clone(), LinkedHashMap::new)));
        clone.setRoles(this.roles == null ? null : this.roles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue()))));
        clone.setNegativeViewRoles(new ArrayList<String>(this.negativeViewRoles));
        clone.setUserRefs(this.userRefs == null ? null : this.userRefs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue()))));
        clone.setTriggers(this.triggers == null ? null : this.triggers.stream().map(Trigger::clone).collect(Collectors.toList()));
        clone.setLayout(this.layout == null ? null : this.layout.clone());
        clone.setPriority(this.priority);
        clone.setAssignPolicy(this.assignPolicy);
        clone.setIcon(this.icon);
        clone.setDataFocusPolicy(this.dataFocusPolicy);
        clone.setFinishPolicy(this.finishPolicy);
        clone.setEvents(this.events == null ? null : this.events.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Event)e.getValue()).clone())));
        clone.setAssignedUserPolicy(new HashMap<String, Boolean>(this.assignedUserPolicy));
        clone.setTags(new HashMap<String, String>(this.tags));
        clone.setDefaultRoleId(this.defaultRoleId);
        return clone;
    }

    @Generated
    public Map<String, DataGroup> getDataGroups() {
        return this.dataGroups;
    }

    @Generated
    public void setDataGroups(Map<String, DataGroup> dataGroups) {
        this.dataGroups = dataGroups;
    }

    @Generated
    public LinkedHashMap<String, DataFieldLogic> getDataSet() {
        return this.dataSet;
    }

    @Generated
    public void setDataSet(LinkedHashMap<String, DataFieldLogic> dataSet) {
        this.dataSet = dataSet;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getRoles() {
        return this.roles;
    }

    @Generated
    public void setRoles(Map<String, Map<String, Boolean>> roles) {
        this.roles = roles;
    }

    @Generated
    public List<String> getNegativeViewRoles() {
        return this.negativeViewRoles;
    }

    @Generated
    public void setNegativeViewRoles(List<String> negativeViewRoles) {
        this.negativeViewRoles = negativeViewRoles;
    }

    @Generated
    public Map<String, Map<String, Boolean>> getUserRefs() {
        return this.userRefs;
    }

    @Generated
    public void setUserRefs(Map<String, Map<String, Boolean>> userRefs) {
        this.userRefs = userRefs;
    }

    @Generated
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    @Generated
    public void setTriggers(List<Trigger> triggers) {
        this.triggers = triggers;
    }

    @Generated
    public TaskLayout getLayout() {
        return this.layout;
    }

    @Generated
    public void setLayout(TaskLayout layout) {
        this.layout = layout;
    }

    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Generated
    public AssignPolicy getAssignPolicy() {
        return this.assignPolicy;
    }

    @Generated
    public void setAssignPolicy(AssignPolicy assignPolicy) {
        this.assignPolicy = assignPolicy;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public DataFocusPolicy getDataFocusPolicy() {
        return this.dataFocusPolicy;
    }

    @Generated
    public void setDataFocusPolicy(DataFocusPolicy dataFocusPolicy) {
        this.dataFocusPolicy = dataFocusPolicy;
    }

    @Generated
    public FinishPolicy getFinishPolicy() {
        return this.finishPolicy;
    }

    @Generated
    public void setFinishPolicy(FinishPolicy finishPolicy) {
        this.finishPolicy = finishPolicy;
    }

    @Generated
    public Map<EventType, Event> getEvents() {
        return this.events;
    }

    @Generated
    public void setEvents(Map<EventType, Event> events) {
        this.events = events;
    }

    @Generated
    public Map<String, Boolean> getAssignedUserPolicy() {
        return this.assignedUserPolicy;
    }

    @Generated
    public void setAssignedUserPolicy(Map<String, Boolean> assignedUserPolicy) {
        this.assignedUserPolicy = assignedUserPolicy;
    }

    @Generated
    public String getDefaultRoleId() {
        return this.defaultRoleId;
    }

    @Generated
    public void setDefaultRoleId(String defaultRoleId) {
        this.defaultRoleId = defaultRoleId;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

