/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain;

import com.netgrif.application.engine.petrinet.domain.UriContentType;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class UriNode {
    @Id
    private ObjectId _id;
    private String uriPath;
    private String name;
    private String parentId;
    @Transient
    private UriNode parent;
    private Set<String> childrenId;
    @Transient
    private Set<UriNode> children;
    private int level;
    private Set<UriContentType> contentTypes;

    public UriNode() {
        this.childrenId = new HashSet<String>();
        this.children = new HashSet<UriNode>();
        this.contentTypes = new HashSet<UriContentType>();
    }

    public boolean containsCase() {
        return this.contentTypes.contains((Object)UriContentType.CASE);
    }

    public void addContentType(UriContentType contentType) {
        if (this.contentTypes == null) {
            this.contentTypes = new HashSet<UriContentType>();
        }
        this.contentTypes.add(contentType);
    }

    public boolean containsNet() {
        return this.contentTypes.contains((Object)UriContentType.PROCESS);
    }

    public String getStringId() {
        return this._id.toString();
    }

    @Generated
    public UriNode(ObjectId _id, String uriPath, String name, String parentId, UriNode parent, Set<String> childrenId, Set<UriNode> children, int level, Set<UriContentType> contentTypes) {
        this._id = _id;
        this.uriPath = uriPath;
        this.name = name;
        this.parentId = parentId;
        this.parent = parent;
        this.childrenId = childrenId;
        this.children = children;
        this.level = level;
        this.contentTypes = contentTypes;
    }

    @Generated
    public ObjectId get_id() {
        return this._id;
    }

    @Generated
    public String getUriPath() {
        return this.uriPath;
    }

    @Generated
    public void setUriPath(String uriPath) {
        this.uriPath = uriPath;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public UriNode getParent() {
        return this.parent;
    }

    @Generated
    public void setParent(UriNode parent) {
        this.parent = parent;
    }

    @Generated
    public Set<String> getChildrenId() {
        return this.childrenId;
    }

    @Generated
    public void setChildrenId(Set<String> childrenId) {
        this.childrenId = childrenId;
    }

    @Generated
    public Set<UriNode> getChildren() {
        return this.children;
    }

    @Generated
    public void setChildren(Set<UriNode> children) {
        this.children = children;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public Set<UriContentType> getContentTypes() {
        return this.contentTypes;
    }

    @Generated
    public void setContentTypes(Set<UriContentType> contentTypes) {
        this.contentTypes = contentTypes;
    }
}

