/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain.arcs;

import com.netgrif.application.engine.petrinet.domain.Node;
import com.netgrif.application.engine.petrinet.domain.PetriNetObject;
import com.netgrif.application.engine.petrinet.domain.Place;
import com.netgrif.application.engine.petrinet.domain.Position;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.arcs.reference.Reference;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;

public class Arc
extends PetriNetObject {
    @Transient
    protected Node source;
    protected String sourceId;
    @Transient
    protected Node destination;
    protected String destinationId;
    protected Integer multiplicity;
    protected Reference reference;
    protected List<Position> breakpoints;

    public Arc() {
        this.setObjectId(new ObjectId());
        this.breakpoints = new ArrayList<Position>();
    }

    public Arc(Node source, Node destination, int multiplicity) {
        this();
        this.setSource(source);
        this.setDestination(destination);
        this.multiplicity = multiplicity;
    }

    public Place getPlace() {
        return this.source instanceof Place ? (Place)this.source : (Place)this.destination;
    }

    public Transition getTransition() {
        return this.source instanceof Transition ? (Transition)this.source : (Transition)this.destination;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
        this.sourceId = source.getImportId();
    }

    public Node getDestination() {
        return this.destination;
    }

    public void setDestination(Node destination) {
        this.destination = destination;
        this.destinationId = destination.getImportId();
    }

    public String toString() {
        return this.source.getTitle() + " -(" + this.multiplicity + ")> " + this.destination.getTitle();
    }

    public boolean isExecutable() {
        if (this.source instanceof Transition) {
            return true;
        }
        if (this.reference != null) {
            this.multiplicity = this.reference.getMultiplicity();
        }
        return ((Place)this.source).getTokens() >= this.multiplicity;
    }

    public void execute() {
        if (this.reference != null) {
            this.multiplicity = this.reference.getMultiplicity();
        }
        if (this.source instanceof Transition) {
            ((Place)this.destination).addTokens(this.multiplicity);
        } else {
            ((Place)this.source).removeTokens(this.multiplicity);
        }
    }

    public void rollbackExecution(Integer tokensConsumed) {
        if (tokensConsumed == null && this.reference != null) {
            throw new IllegalArgumentException("Cannot rollback variable arc, because it was never executed");
        }
        if (this.reference == null) {
            tokensConsumed = this.multiplicity;
        }
        ((Place)this.source).addTokens(tokensConsumed);
    }

    public Arc clone() {
        Arc clone = new Arc();
        clone.setSourceId(this.sourceId);
        clone.setDestinationId(this.destinationId);
        clone.setMultiplicity(this.multiplicity);
        clone.setBreakpoints(this.breakpoints);
        clone.setObjectId(this.getObjectId());
        clone.setImportId(this.importId);
        clone.setReference(this.reference == null ? null : this.reference.clone());
        return clone;
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @Generated
    public String getDestinationId() {
        return this.destinationId;
    }

    @Generated
    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    @Generated
    public Integer getMultiplicity() {
        return this.multiplicity;
    }

    @Generated
    public void setMultiplicity(Integer multiplicity) {
        this.multiplicity = multiplicity;
    }

    @Generated
    public Reference getReference() {
        return this.reference;
    }

    @Generated
    public void setReference(Reference reference) {
        this.reference = reference;
    }

    @Generated
    public List<Position> getBreakpoints() {
        return this.breakpoints;
    }

    @Generated
    public void setBreakpoints(List<Position> breakpoints) {
        this.breakpoints = breakpoints;
    }
}

