/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain.dataset.factory;

import com.netgrif.application.engine.files.IStorageResolverService;
import com.netgrif.application.engine.files.interfaces.IStorageService;
import com.netgrif.application.engine.importer.model.Data;
import com.netgrif.application.engine.petrinet.domain.dataset.Storage;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageFactory.class);

    public static Storage createStorage(Data data, IStorageResolverService storageResolverService, String defaultStorageType) {
        Storage storage;
        if (data == null) {
            return null;
        }
        String storageType = data.getStorage() == null || data.getStorage().getType() == null ? defaultStorageType : data.getStorage().getType().toLowerCase();
        Set<String> storageTypes = storageResolverService.availableStorageTypes();
        if (storageTypes.contains(storageType)) {
            IStorageService storageService = storageResolverService.resolve(storageType);
            storage = storageService.createStorage(data);
        } else {
            log.warn("Storage of type [" + storageType + "] is not enabled. Fallback to " + defaultStorageType);
            storage = new Storage(defaultStorageType);
        }
        return storage;
    }
}

