/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain.dataset.logic;

import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.FieldBehavior;
import com.netgrif.application.engine.workflow.domain.Task;
import com.querydsl.core.annotations.QueryExclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

@QueryExclude
public class ChangedField
implements Serializable {
    private static final long serialVersionUID = 5299918326436828485L;
    private String id;
    private List<TaskPair> changedOn;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public ChangedField() {
        this.changedOn = new ArrayList<TaskPair>();
    }

    public ChangedField(String id) {
        this();
        this.id = id;
    }

    public void wasChangedOn(Task task) {
        this.wasChangedOn(task.getStringId(), task.getTransitionId());
    }

    public void wasChangedOn(String taskId, String transition) {
        if (!this.isChangedOn(taskId)) {
            this.changedOn.add(new TaskPair(taskId, transition));
        }
    }

    public boolean isChangedOn(String taskId) {
        return this.changedOn.stream().anyMatch(taskPair -> Objects.equals(taskPair.taskId, taskId));
    }

    public void addAttribute(String name, Object value) {
        if (value instanceof I18nString) {
            this.attributes.put(name, ((I18nString)value).getDefaultValue());
        } else {
            this.attributes.put(name, value);
        }
    }

    public void addBehavior(Map<String, Set<FieldBehavior>> behavior) {
        HashMap behs = new HashMap();
        behavior.forEach((trans, fieldBehaviors) -> {
            HashMap b = new HashMap();
            fieldBehaviors.forEach(fieldBehavior -> b.put(fieldBehavior.toString(), true));
            behs.put(trans, b);
        });
        this.attributes.put("behavior", behs);
    }

    public void merge(ChangedField changedField) {
        changedField.changedOn.forEach(taskPair -> this.wasChangedOn(taskPair.taskId, taskPair.transition));
        this.attributes.putAll(changedField.attributes);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ChangedField that = (ChangedField)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.attributes.toString();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public List<TaskPair> getChangedOn() {
        return this.changedOn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setChangedOn(List<TaskPair> changedOn) {
        this.changedOn = changedOn;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    static class TaskPair
    implements Serializable {
        private static final long serialVersionUID = 5299918326444428485L;
        public String taskId;
        public String transition;

        public TaskPair() {
        }

        public TaskPair(String taskId, String transition) {
            this.taskId = taskId;
            this.transition = transition;
        }
    }
}

