/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain.events;

import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.events.BaseEvent;
import com.netgrif.application.engine.petrinet.domain.events.DataEventType;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEvent
extends BaseEvent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataEvent.class);
    private DataEventType type;

    public DataEvent() {
        this.initActions();
    }

    public DataEvent(String id) {
        this();
        this.setId(id);
    }

    public DataEvent(String id, String type) {
        this(id);
        this.type = DataEventType.fromString(type);
    }

    public EventPhase getDefaultPhase() {
        try {
            if (this.type.equals((Object)DataEventType.GET)) {
                return EventPhase.PRE;
            }
            if (this.type.equals((Object)DataEventType.SET)) {
                return EventPhase.POST;
            }
        }
        catch (NullPointerException e) {
            log.error("Trigger for event [" + this.getId() + "] is not set", (Throwable)e);
        }
        return null;
    }

    private void initActions() {
        this.setPreActions(new ArrayList<Action>());
        this.setPostActions(new ArrayList<Action>());
    }

    public void addToActionsByDefaultPhase(List<Action> actionList) {
        actionList.forEach(this::addToActionsByDefaultPhase);
    }

    public void addToActionsByDefaultPhase(Action action) {
        if (this.getDefaultPhase() == EventPhase.PRE) {
            this.getPreActions().add(action);
        } else {
            this.getPostActions().add(action);
        }
    }

    public DataEvent clone() {
        DataEvent clone = new DataEvent();
        clone.setId(this.getId());
        clone.setTitle(this.getTitle() == null ? null : this.getTitle().clone());
        clone.setMessage(this.getMessage() == null ? null : this.getMessage().clone());
        clone.setPreActions(this.getPreActions() == null ? null : this.getPreActions().stream().map(Action::clone).collect(Collectors.toList()));
        clone.setPostActions(this.getPostActions() == null ? null : this.getPostActions().stream().map(Action::clone).collect(Collectors.toList()));
        clone.setType(this.type);
        return clone;
    }

    @Generated
    public DataEventType getType() {
        return this.type;
    }

    @Generated
    public void setType(DataEventType type) {
        this.type = type;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEvent)) {
            return false;
        }
        DataEvent other = (DataEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataEventType this$type = this.getType();
        DataEventType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataEventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataEvent(type=" + this.getType() + ")";
    }
}

