/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.domain.roles;

import com.netgrif.application.engine.petrinet.domain.I18nString;
import com.netgrif.application.engine.petrinet.domain.Imported;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.events.Event;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class ProcessRole
extends Imported {
    public static final String DEFAULT_ROLE = "default";
    public static final String ANONYMOUS_ROLE = "anonymous";
    public static final String GLOBAL = "global_";
    private boolean global;
    @Id
    private ObjectId _id;
    private I18nString name;
    private String netId;
    private String description;
    private Map<EventType, Event> events;

    public ProcessRole() {
        this._id = new ObjectId();
    }

    public ProcessRole(String id) {
        this._id = new ObjectId(id);
    }

    public String getStringId() {
        return this._id.toString();
    }

    public ObjectId get_id() {
        return this._id;
    }

    public void set_id(ObjectId _id) {
        this._id = _id;
    }

    public void set_id(String id) {
        this._id = new ObjectId(id);
    }

    public I18nString getName() {
        return this.name;
    }

    public void setName(String name) {
        this.setName(new I18nString(name));
    }

    public void setName(I18nString name) {
        this.name = name;
    }

    public String getLocalisedName(Locale locale) {
        if (this.name == null) {
            return null;
        }
        return this.name.getTranslation(locale);
    }

    public List<Action> getPreAssignActions() {
        return this.getPreActions(EventType.ASSIGN);
    }

    public List<Action> getPostAssignActions() {
        return this.getPostActions(EventType.ASSIGN);
    }

    public List<Action> getPreCancelActions() {
        return this.getPreActions(EventType.CANCEL);
    }

    public List<Action> getPostCancelActions() {
        return this.getPostActions(EventType.CANCEL);
    }

    private List<Action> getPreActions(EventType type) {
        if (this.events != null && this.events.containsKey((Object)type)) {
            return this.events.get((Object)type).getPreActions();
        }
        return new LinkedList<Action>();
    }

    private List<Action> getPostActions(EventType type) {
        if (this.events != null && this.events.containsKey((Object)type)) {
            return this.events.get((Object)type).getPostActions();
        }
        return new LinkedList<Action>();
    }

    public String toString() {
        return this.name.getDefaultValue();
    }

    public ProcessRole clone() {
        ProcessRole clone = new ProcessRole();
        clone.set_id(this._id);
        clone.setImportId(this.importId);
        clone.setName(this.name == null ? null : this.name.clone());
        clone.setNetId(this.netId);
        clone.setDescription(this.description);
        return clone;
    }

    @Generated
    public boolean isGlobal() {
        return this.global;
    }

    @Generated
    public String getNetId() {
        return this.netId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<EventType, Event> getEvents() {
        return this.events;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRole)) {
            return false;
        }
        ProcessRole other = (ProcessRole)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$$getStringId = this.getStringId();
        String other$$getStringId = other.getStringId();
        return !(this$$getStringId == null ? other$$getStringId != null : !this$$getStringId.equals(other$$getStringId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessRole;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $$getStringId = this.getStringId();
        result = result * 59 + ($$getStringId == null ? 43 : $$getStringId.hashCode());
        return result;
    }

    @Generated
    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Generated
    public void setNetId(String netId) {
        this.netId = netId;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setEvents(Map<EventType, Event> events) {
        this.events = events;
    }
}

