/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.configuration.properties.CacheProperties;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticPetriNetMappingService;
import com.netgrif.application.engine.elastic.service.interfaces.IElasticPetriNetService;
import com.netgrif.application.engine.history.domain.petrinetevents.DeletePetriNetEventLog;
import com.netgrif.application.engine.history.domain.petrinetevents.ImportPetriNetEventLog;
import com.netgrif.application.engine.history.domain.taskevents.TaskEventLog;
import com.netgrif.application.engine.history.service.IHistoryService;
import com.netgrif.application.engine.importer.service.Importer;
import com.netgrif.application.engine.importer.service.throwable.MissingIconKeyException;
import com.netgrif.application.engine.ldap.service.interfaces.ILdapGroupRefService;
import com.netgrif.application.engine.orgstructure.groups.interfaces.INextGroupService;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.Place;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.VersionType;
import com.netgrif.application.engine.petrinet.domain.arcs.Arc;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.FieldActionsRunner;
import com.netgrif.application.engine.petrinet.domain.events.EventPhase;
import com.netgrif.application.engine.petrinet.domain.events.ProcessEventType;
import com.netgrif.application.engine.petrinet.domain.repositories.PetriNetRepository;
import com.netgrif.application.engine.petrinet.domain.throwable.MissingPetriNetMetaDataException;
import com.netgrif.application.engine.petrinet.domain.version.Version;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.petrinet.service.interfaces.IUriService;
import com.netgrif.application.engine.petrinet.web.responsebodies.ArcImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.DataFieldReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PlaceImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReference;
import com.netgrif.application.engine.rules.domain.facts.NetImportedFact;
import com.netgrif.application.engine.rules.service.interfaces.IRuleEngine;
import com.netgrif.application.engine.workflow.domain.Case;
import com.netgrif.application.engine.workflow.domain.FileStorageConfiguration;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.petrinetoutcomes.ImportPetriNetEventOutcome;
import com.netgrif.application.engine.workflow.service.interfaces.IEventService;
import com.netgrif.application.engine.workflow.service.interfaces.IFieldActionsCacheService;
import com.netgrif.application.engine.workflow.service.interfaces.IWorkflowService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;
import javax.inject.Provider;
import lombok.Generated;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PetriNetService
implements IPetriNetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PetriNetService.class);
    @Autowired
    private IProcessRoleService processRoleService;
    @Autowired
    private PetriNetRepository repository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private FileStorageConfiguration fileStorageConfiguration;
    @Autowired
    private IRuleEngine ruleEngine;
    @Autowired
    private IWorkflowService workflowService;
    @Autowired
    private INextGroupService groupService;
    @Autowired
    private Provider<Importer> importerProvider;
    @Autowired
    private FieldActionsRunner actionsRunner;
    @Autowired(required=false)
    private ILdapGroupRefService ldapGroupService;
    @Autowired
    private IFieldActionsCacheService functionCacheService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IEventService eventService;
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheProperties cacheProperties;
    @Resource
    private IPetriNetService self;
    @Autowired
    private IElasticPetriNetMappingService petriNetMappingService;
    @Autowired
    private IUriService uriService;
    private IElasticPetriNetService elasticPetriNetService;

    @Autowired
    public void setElasticPetriNetService(IElasticPetriNetService elasticPetriNetService) {
        this.elasticPetriNetService = elasticPetriNetService;
    }

    protected Importer getImporter() {
        return (Importer)this.importerProvider.get();
    }

    @Override
    public void evictAllCaches() {
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetById()), this.cacheProperties.getPetriNetById()).clear();
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetNewest()), this.cacheProperties.getPetriNetNewest()).clear();
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetCache()), this.cacheProperties.getPetriNetCache()).clear();
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetByIdentifier()), this.cacheProperties.getPetriNetByIdentifier()).clear();
    }

    @Override
    public void evictCache(PetriNet net) {
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetById()), this.cacheProperties.getPetriNetById()).evict((Object)net.getStringId());
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetNewest()), this.cacheProperties.getPetriNetNewest()).evict((Object)net.getIdentifier());
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetCache()), this.cacheProperties.getPetriNetCache()).evict((Object)net.getObjectId());
        this.requireNonNull(this.cacheManager.getCache(this.cacheProperties.getPetriNetByIdentifier()), this.cacheProperties.getPetriNetByIdentifier()).evict((Object)(net.getIdentifier() + net.getVersion().toString()));
    }

    @Override
    @Cacheable(value={"petriNetCache"})
    public PetriNet get(ObjectId petriNetId) {
        Optional optional = this.repository.findById(petriNetId.toString());
        if (optional.isEmpty()) {
            throw new IllegalArgumentException("Petri net with id [" + petriNetId + "] not found");
        }
        return (PetriNet)optional.get();
    }

    @Override
    public List<PetriNet> get(Collection<ObjectId> petriNetIds) {
        return petriNetIds.stream().map(id -> this.self.get((ObjectId)id)).collect(Collectors.toList());
    }

    @Override
    public List<PetriNet> get(List<String> petriNetIds) {
        return this.self.get(petriNetIds.stream().map(ObjectId::new).collect(Collectors.toList()));
    }

    @Override
    public PetriNet clone(ObjectId petriNetId) {
        return this.self.get(petriNetId).clone();
    }

    @Override
    @Deprecated
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, String releaseType, LoggedUser author) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        return this.importPetriNet(xmlFile, VersionType.valueOf(releaseType.trim().toUpperCase()), author, this.uriService.getRoot().getStringId());
    }

    @Override
    @Deprecated
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, String releaseType, LoggedUser author, String uriNodeId) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        return this.importPetriNet(xmlFile, VersionType.valueOf(releaseType.trim().toUpperCase()), author, uriNodeId);
    }

    @Override
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, VersionType releaseType, LoggedUser author) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        return this.importPetriNet(xmlFile, releaseType, author, this.uriService.getRoot().getStringId());
    }

    @Override
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, VersionType releaseType, LoggedUser author, Map<String, String> params) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        return this.importPetriNet(xmlFile, releaseType, author, this.uriService.getRoot().getStringId(), params);
    }

    @Override
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, VersionType releaseType, LoggedUser author, String uriNodeId) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        return this.importPetriNet(xmlFile, releaseType, author, uriNodeId, new HashMap<String, String>());
    }

    @Override
    public ImportPetriNetEventOutcome importPetriNet(InputStream xmlFile, VersionType releaseType, LoggedUser author, String uriNodeId, Map<String, String> params) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException {
        ImportPetriNetEventOutcome outcome = new ImportPetriNetEventOutcome();
        ByteArrayOutputStream xmlCopy = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)xmlFile, (OutputStream)xmlCopy);
        Optional<PetriNet> imported = this.getImporter().importPetriNet(new ByteArrayInputStream(xmlCopy.toByteArray()));
        if (imported.isEmpty()) {
            return outcome;
        }
        PetriNet net = imported.get();
        net.setUriNodeId(uriNodeId);
        PetriNet existingNet = this.getNewestVersionByIdentifier(net.getIdentifier());
        if (existingNet != null) {
            net.setVersion(existingNet.getVersion());
            net.incrementVersion(releaseType);
        }
        this.processRoleService.saveAll(net.getRoles().values());
        net.setAuthor(author.transformToAuthor());
        this.functionCacheService.cachePetriNetFunctions(net);
        Path savedPath = this.getImporter().saveNetFile(net, new ByteArrayInputStream(xmlCopy.toByteArray()));
        xmlCopy.close();
        log.info("Petri net " + net.getTitle() + " (" + net.getInitials() + " v" + net.getVersion() + ") imported successfully and saved in a folder: " + savedPath.toString());
        outcome.setOutcomes(this.eventService.runActions(net.getPreUploadActions(), null, Optional.empty(), params));
        this.evaluateRules(net, EventPhase.PRE);
        this.historyService.save(new ImportPetriNetEventLog(null, EventPhase.PRE, net.getObjectId()));
        this.save(net);
        outcome.setOutcomes(this.eventService.runActions(net.getPostUploadActions(), null, Optional.empty(), params));
        this.evaluateRules(net, EventPhase.POST);
        this.historyService.save(new ImportPetriNetEventLog(null, EventPhase.POST, net.getObjectId()));
        this.addMessageToOutcome(net, ProcessEventType.UPLOAD, outcome);
        outcome.setNet(imported.get());
        return outcome;
    }

    private ImportPetriNetEventOutcome addMessageToOutcome(PetriNet net, ProcessEventType type, ImportPetriNetEventOutcome outcome) {
        if (net.getProcessEvents().containsKey((Object)type)) {
            outcome.setMessage(net.getProcessEvents().get((Object)type).getMessage());
        }
        return outcome;
    }

    protected void evaluateRules(PetriNet net, EventPhase phase) {
        int rulesExecuted = this.ruleEngine.evaluateRules(net, new NetImportedFact(net.getStringId(), phase));
        if (rulesExecuted > 0) {
            this.save(net);
        }
    }

    @Override
    public Optional<PetriNet> save(PetriNet petriNet) {
        petriNet.initializeArcs();
        this.evictCache(petriNet);
        petriNet = (PetriNet)this.repository.save(petriNet);
        try {
            this.elasticPetriNetService.indexNow(this.petriNetMappingService.transform(petriNet));
        }
        catch (Exception e) {
            log.error("Indexing failed [" + petriNet.getStringId() + "]", (Throwable)e);
        }
        return Optional.of(petriNet);
    }

    @Override
    @Cacheable(value={"petriNetById"})
    public PetriNet getPetriNet(String id) {
        Optional net = this.repository.findById(id);
        if (net.isEmpty()) {
            throw new IllegalArgumentException("No Petri net with id: " + id + " was found.");
        }
        ((PetriNet)net.get()).initializeArcs();
        return (PetriNet)net.get();
    }

    @Override
    @Cacheable(value={"petriNetByIdentifier"}, key="#identifier+#version.toString()", unless="#result == null")
    public PetriNet getPetriNet(String identifier, Version version) {
        PetriNet net = this.repository.findByIdentifierAndVersion(identifier, version);
        if (net == null) {
            return null;
        }
        net.initializeArcs();
        return net;
    }

    @Override
    public List<PetriNet> getByIdentifier(String identifier) {
        List<PetriNet> nets = this.repository.findAllByIdentifier(identifier);
        nets.forEach(PetriNet::initializeArcs);
        return nets;
    }

    @Override
    public List<PetriNet> findAllByUriNodeId(String uriNodeId) {
        List<PetriNet> nets = this.elasticPetriNetService.findAllByUriNodeId(uriNodeId);
        nets.forEach(PetriNet::initializeArcs);
        return nets;
    }

    @Override
    public List<PetriNet> findAllById(List<String> ids) {
        return StreamSupport.stream(this.repository.findAllById(ids).spliterator(), false).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"petriNetNewest"}, unless="#result == null")
    public PetriNet getNewestVersionByIdentifier(String identifier) {
        List nets = this.repository.findByIdentifier(identifier, (Pageable)PageRequest.of((int)0, (int)1, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"version.major", "version.minor", "version.patch"})).getContent();
        if (nets.isEmpty()) {
            return null;
        }
        return (PetriNet)nets.get(0);
    }

    @Override
    public List<String> getExistingPetriNetIdentifiersFromIdentifiersList(List<String> identifiers) {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"identifier").in(identifiers)), Aggregation.group((String[])new String[]{"identifier"}), Aggregation.project((String[])new String[]{"identifier"}).and("identifier").previousOperation()});
        AggregationResults groupResults = this.mongoTemplate.aggregate(agg, PetriNet.class, TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<Map<String, String>>(){}).getRawClass());
        List result = groupResults.getMappedResults();
        return result.stream().flatMap(v -> v.values().stream()).collect(Collectors.toList());
    }

    @Override
    public PetriNetImportReference getNetFromCase(String caseId) {
        Case useCase = this.workflowService.findOne(caseId);
        PetriNetImportReference pn = new PetriNetImportReference();
        useCase.getPetriNet().getTransitions().forEach((key, value) -> pn.getTransitions().add(new TransitionImportReference((Transition)value)));
        useCase.getPetriNet().getPlaces().forEach((key, value) -> pn.getPlaces().add(new PlaceImportReference((Place)value)));
        useCase.getPetriNet().getArcs().forEach((key, arcs) -> arcs.forEach(arc -> pn.getArcs().add(new ArcImportReference((Arc)arc))));
        pn.getAssignedTasks().addAll(this.historyService.findAllAssignTaskEventLogsByCaseId(caseId).stream().map(TaskEventLog::getTransitionId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        pn.getFinishedTasks().addAll(this.historyService.findAllFinishTaskEventLogsByCaseId(caseId).stream().map(TaskEventLog::getTransitionId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        return pn;
    }

    @Override
    public List<PetriNet> getAll() {
        List nets = this.repository.findAll();
        nets.forEach(PetriNet::initializeArcs);
        return nets;
    }

    @Override
    public FileSystemResource getFile(String netId, String title) {
        if (title == null || title.length() == 0) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(netId)));
            query.fields().include("_id").include("title");
            List nets = this.mongoTemplate.find(query, PetriNet.class);
            if (nets.isEmpty()) {
                return null;
            }
            title = ((PetriNet)nets.get(0)).getTitle().getDefaultValue();
        }
        return new FileSystemResource(this.fileStorageConfiguration.getStorageArchived() + netId + "-" + title + ".xml");
    }

    @Override
    public List<PetriNetReference> getReferences(LoggedUser user, Locale locale) {
        return this.getAll().stream().map(net -> IPetriNetService.transformToReference(net, locale)).collect(Collectors.toList());
    }

    @Override
    public List<PetriNetReference> getReferencesByIdentifier(String identifier, LoggedUser user, Locale locale) {
        return this.getByIdentifier(identifier).stream().map(net -> IPetriNetService.transformToReference(net, locale)).collect(Collectors.toList());
    }

    @Override
    public List<PetriNetReference> getReferencesByVersion(Version version, LoggedUser user, Locale locale) {
        List<PetriNetReference> references;
        if (version == null) {
            GroupOperation groupByIdentifier = Aggregation.group((String[])new String[]{"identifier"}).max("version").as("version");
            Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{groupByIdentifier});
            AggregationResults results = this.mongoTemplate.aggregate(aggregation, "petriNet", Document.class);
            references = results.getMappedResults().stream().map(doc -> {
                Document versionDoc = (Document)doc.get((Object)"version", Document.class);
                Version refVersion = new Version(versionDoc.getLong((Object)"major"), versionDoc.getLong((Object)"minor"), versionDoc.getLong((Object)"patch"));
                return this.getReference(doc.getString((Object)"_id"), refVersion, user, locale);
            }).collect(Collectors.toList());
        } else {
            references = this.repository.findAllByVersion(version).stream().map(net -> IPetriNetService.transformToReference(net, locale)).collect(Collectors.toList());
        }
        return references;
    }

    @Override
    public List<PetriNetReference> getReferencesByUsersProcessRoles(LoggedUser user, Locale locale) {
        Query query = Query.query((CriteriaDefinition)this.getProcessRolesCriteria(user));
        return this.mongoTemplate.find(query, PetriNet.class).stream().map(net -> IPetriNetService.transformToReference(net, locale)).collect(Collectors.toList());
    }

    @Override
    public PetriNetReference getReference(String identifier, Version version, LoggedUser user, Locale locale) {
        PetriNet net = version == null ? this.getNewestVersionByIdentifier(identifier) : this.getPetriNet(identifier, version);
        return net != null ? IPetriNetService.transformToReference(net, locale) : new PetriNetReference();
    }

    @Override
    public List<TransitionReference> getTransitionReferences(List<String> netIds, LoggedUser user, Locale locale) {
        List<PetriNet> nets = this.get(netIds);
        ArrayList<TransitionReference> references = new ArrayList<TransitionReference>();
        nets.forEach(net -> references.addAll(net.getTransitions().entrySet().stream().map(entry -> IPetriNetService.transformToReference(net, (Transition)entry.getValue(), locale)).collect(Collectors.toList())));
        return references;
    }

    @Override
    public List<DataFieldReference> getDataFieldReferences(List<TransitionReference> transitions, Locale locale) {
        Iterable nets = this.repository.findAllById(transitions.stream().map(TransitionReference::getPetriNetId).collect(Collectors.toList()));
        ArrayList<DataFieldReference> dataRefs = new ArrayList<DataFieldReference>();
        Map<String, List<TransitionReference>> transitionReferenceMap = transitions.stream().collect(Collectors.groupingBy(TransitionReference::getPetriNetId));
        nets.forEach(net -> ((List)transitionReferenceMap.get(net.getStringId())).forEach(transition -> {
            Transition trans = net.getTransition(transition.getStringId());
            if (trans != null) {
                dataRefs.addAll(trans.getDataSet().entrySet().stream().map(entry -> IPetriNetService.transformToReference(net, trans, net.getDataSet().get(entry.getKey()), locale)).collect(Collectors.toList()));
            }
        }));
        return dataRefs;
    }

    @Override
    public Optional<PetriNet> findByImportId(String id) {
        return Optional.of(this.repository.findByImportId(id));
    }

    @Override
    public Page<PetriNetReference> search(PetriNetSearch criteriaClass, LoggedUser user, Pageable pageable, Locale locale) {
        Query query = new Query();
        Query queryTotal = new Query();
        if (!user.getSelfOrImpersonated().isAdmin()) {
            query.addCriteria((CriteriaDefinition)this.getProcessRolesCriteria(user.getSelfOrImpersonated()));
        }
        if (criteriaClass.getIdentifier() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"identifier").regex(criteriaClass.getIdentifier(), "i"));
        }
        if (criteriaClass.getTitle() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"title.defaultValue").regex(criteriaClass.getTitle(), "i"));
        }
        if (criteriaClass.getInitials() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"initials").regex(criteriaClass.getInitials(), "i"));
        }
        if (criteriaClass.getDefaultCaseName() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"defaultCaseName.defaultValue").regex(criteriaClass.getDefaultCaseName(), "i"));
        }
        if (criteriaClass.getGroup() != null) {
            if (criteriaClass.getGroup().size() == 1) {
                this.addValueCriteria(query, queryTotal, Criteria.where((String)"author.email").is((Object)this.groupService.getGroupOwnerEmail(criteriaClass.getGroup().get(0))));
            } else {
                this.addValueCriteria(query, queryTotal, Criteria.where((String)"author.email").in(this.groupService.getGroupsOwnerEmails(criteriaClass.getGroup())));
            }
        }
        if (criteriaClass.getVersion() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"version").is((Object)criteriaClass.getVersion()));
        }
        if (criteriaClass.getAuthor() != null) {
            if (criteriaClass.getAuthor().getEmail() != null) {
                this.addValueCriteria(query, queryTotal, Criteria.where((String)"author.email").is((Object)criteriaClass.getAuthor().getEmail()));
            }
            if (criteriaClass.getAuthor().getId() != null) {
                this.addValueCriteria(query, queryTotal, Criteria.where((String)"author.id").is((Object)criteriaClass.getAuthor().getId()));
            }
            if (criteriaClass.getAuthor().getFullName() != null) {
                this.addValueCriteria(query, queryTotal, Criteria.where((String)"author.fullName").is((Object)criteriaClass.getAuthor().getFullName()));
            }
        }
        if (criteriaClass.getNegativeViewRoles() != null) {
            this.addValueCriteria(query, queryTotal, Criteria.where((String)"negativeViewRoles").in(criteriaClass.getNegativeViewRoles()));
        }
        if (criteriaClass.getTags() != null) {
            criteriaClass.getTags().entrySet().forEach(stringStringEntry -> this.addValueCriteria(query, queryTotal, Criteria.where((String)("tags." + (String)stringStringEntry.getKey())).is(stringStringEntry.getValue())));
        }
        query.with(pageable);
        List nets = this.mongoTemplate.find(query, PetriNet.class);
        return new PageImpl(nets.stream().map(net -> new PetriNetReference((PetriNet)net, locale)).collect(Collectors.toList()), pageable, this.mongoTemplate.count(queryTotal, PetriNet.class));
    }

    private void addValueCriteria(Query query, Query queryTotal, Criteria criteria) {
        query.addCriteria((CriteriaDefinition)criteria);
        queryTotal.addCriteria((CriteriaDefinition)criteria);
    }

    @Override
    @Transactional
    public void deletePetriNet(String processId, LoggedUser loggedUser) {
        Optional petriNetOptional = this.repository.findById(processId);
        if (!petriNetOptional.isPresent()) {
            throw new IllegalArgumentException("Could not find process with id [" + processId + "]");
        }
        PetriNet petriNet = (PetriNet)petriNetOptional.get();
        log.info("[" + processId + "]: Initiating deletion of Petri net " + petriNet.getIdentifier() + " version " + petriNet.getVersion().toString());
        this.userService.removeRoleOfDeletedPetriNet(petriNet);
        this.workflowService.deleteInstancesOfPetriNet(petriNet);
        this.processRoleService.deleteRolesOfNet(petriNet, loggedUser);
        try {
            this.ldapGroupService.deleteProcessRoleByPetrinet(petriNet.getStringId());
        }
        catch (NullPointerException e) {
            log.info("LdapGroup and ProcessRole mapping are not activated...");
        }
        catch (Exception ex) {
            log.error("LdapGroup", (Throwable)ex);
        }
        log.info("[" + processId + "]: User [" + this.userService.getLoggedOrSystem().getStringId() + "] is deleting Petri net " + petriNet.getIdentifier() + " version " + petriNet.getVersion().toString());
        this.repository.deleteBy_id(petriNet.getObjectId());
        this.evictCache(petriNet);
        this.functionCacheService.reloadCachedFunctions(petriNet);
        this.historyService.save(new DeletePetriNetEventLog(null, EventPhase.PRE, petriNet.getObjectId()));
    }

    private Criteria getProcessRolesCriteria(LoggedUser user) {
        return new Criteria().orOperator((Criteria[])user.getProcessRoles().stream().map(role -> Criteria.where((String)("permissions." + role)).exists(true)).toArray(Criteria[]::new));
    }

    @Override
    public void runActions(List<Action> actions, PetriNet petriNet) {
        log.info("Running actions of net [" + petriNet.getStringId() + "]");
        actions.forEach(action -> this.actionsRunner.run((Action)action, null, (Map<String, String>)new HashMap<String, String>(), petriNet.getFunctions()));
    }

    protected <T> T requireNonNull(T obj, Object ... item) {
        if (obj == null) {
            if (item.length > 0) {
                log.error("Null Pointer Exception", item);
            }
            throw new NullPointerException();
        }
        return obj;
    }
}

