/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.service;

import com.netgrif.application.engine.auth.domain.IUser;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.event.events.user.UserRoleChangeEvent;
import com.netgrif.application.engine.importer.model.EventPhaseType;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.context.RoleContext;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.runner.RoleActionsRunner;
import com.netgrif.application.engine.petrinet.domain.events.Event;
import com.netgrif.application.engine.petrinet.domain.events.EventType;
import com.netgrif.application.engine.petrinet.domain.repositories.PetriNetRepository;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRole;
import com.netgrif.application.engine.petrinet.domain.roles.ProcessRoleRepository;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.security.service.ISecurityContextService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ProcessRoleService
implements IProcessRoleService {
    private static final Logger log = LoggerFactory.getLogger(ProcessRoleService.class);
    private final IUserService userService;
    private final ProcessRoleRepository processRoleRepository;
    private final PetriNetRepository netRepository;
    private final ApplicationEventPublisher publisher;
    private final RoleActionsRunner roleActionsRunner;
    private final IPetriNetService petriNetService;
    private final ISecurityContextService securityContextService;
    private ProcessRole defaultRole;
    private ProcessRole anonymousRole;

    public ProcessRoleService(ProcessRoleRepository processRoleRepository, PetriNetRepository netRepository, ApplicationEventPublisher publisher, RoleActionsRunner roleActionsRunner, @Lazy IPetriNetService petriNetService, @Lazy IUserService userService, ISecurityContextService securityContextService) {
        this.processRoleRepository = processRoleRepository;
        this.netRepository = netRepository;
        this.publisher = publisher;
        this.roleActionsRunner = roleActionsRunner;
        this.petriNetService = petriNetService;
        this.userService = userService;
        this.securityContextService = securityContextService;
    }

    @Override
    public List<ProcessRole> saveAll(Iterable<ProcessRole> entities) {
        return StreamSupport.stream(entities.spliterator(), false).map(processRole -> {
            if (!processRole.isGlobal() || this.processRoleRepository.findAllByImportId(processRole.getImportId()).isEmpty()) {
                return (ProcessRole)this.processRoleRepository.save(processRole);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Set<ProcessRole> findByIds(Set<String> ids) {
        return StreamSupport.stream(this.processRoleRepository.findAllById(ids).spliterator(), false).collect(Collectors.toSet());
    }

    @Override
    public void assignRolesToUser(String userId, Set<String> requestedRolesIds, LoggedUser loggedUser) {
        this.assignRolesToUser(userId, requestedRolesIds, loggedUser, new HashMap<String, String>());
    }

    @Override
    public void assignRolesToUser(String userId, Set<String> requestedRolesIds, LoggedUser loggedUser, Map<String, String> params) {
        IUser user = this.userService.resolveById(userId, true);
        Set<ProcessRole> requestedRoles = this.findByIds(requestedRolesIds);
        if (requestedRoles.isEmpty() && !requestedRolesIds.isEmpty()) {
            throw new IllegalArgumentException("No process roles found.");
        }
        if (requestedRoles.size() != requestedRolesIds.size()) {
            throw new IllegalArgumentException("Not all process roles were found!");
        }
        Set<ProcessRole> userOldRoles = user.getProcessRoles();
        Set<ProcessRole> rolesNewToUser = this.getRolesNewToUser(userOldRoles, requestedRoles);
        Set<ProcessRole> rolesRemovedFromUser = this.getRolesRemovedFromUser(userOldRoles, requestedRoles);
        String idOfPetriNetContainingRole = this.getPetriNetIdRoleBelongsTo(rolesNewToUser, rolesRemovedFromUser);
        if (!this.isGlobalFromFirstRole(rolesNewToUser) && !this.isGlobalFromFirstRole(rolesRemovedFromUser) && idOfPetriNetContainingRole == null) {
            return;
        }
        PetriNet petriNet = null;
        if (idOfPetriNetContainingRole != null) {
            petriNet = this.petriNetService.getPetriNet(idOfPetriNetContainingRole);
        }
        Set<String> rolesNewToUserIds = this.mapUserRolesToIds(rolesNewToUser);
        Set<String> rolesRemovedFromUserIds = this.mapUserRolesToIds(rolesRemovedFromUser);
        Set<ProcessRole> newRoles = this.findByIds(rolesNewToUserIds);
        Set<ProcessRole> removedRoles = this.findByIds(rolesRemovedFromUserIds);
        if (petriNet != null) {
            this.runAllPreActions(newRoles, removedRoles, user, petriNet, params);
        }
        requestedRoles = this.updateRequestedRoles(user, rolesNewToUser, rolesRemovedFromUser);
        this.replaceUserRolesAndPublishEvent(requestedRolesIds, user, requestedRoles);
        if (petriNet != null) {
            this.runAllPostActions(newRoles, removedRoles, user, petriNet, params);
        }
        this.securityContextService.saveToken(userId);
        if (Objects.equals(userId, loggedUser.getId())) {
            loggedUser.getProcessRoles().clear();
            loggedUser.parseProcessRoles(user.getProcessRoles());
            this.securityContextService.reloadSecurityContext(loggedUser);
        }
    }

    private Set<ProcessRole> updateRequestedRoles(IUser user, Set<ProcessRole> rolesNewToUser, Set<ProcessRole> rolesRemovedFromUser) {
        Set<ProcessRole> userRolesAfterPreActions = user.getProcessRoles();
        userRolesAfterPreActions.addAll(rolesNewToUser);
        userRolesAfterPreActions.removeAll(rolesRemovedFromUser);
        return new HashSet<ProcessRole>(userRolesAfterPreActions);
    }

    private String getPetriNetIdRoleBelongsTo(Set<ProcessRole> newRoles, Set<ProcessRole> removedRoles) {
        if (!newRoles.isEmpty()) {
            return this.getPetriNetIdFromFirstRole(newRoles);
        }
        if (!removedRoles.isEmpty()) {
            return this.getPetriNetIdFromFirstRole(removedRoles);
        }
        return null;
    }

    private boolean isGlobalFromFirstRole(Set<ProcessRole> roles) {
        if (roles.isEmpty()) {
            return false;
        }
        ProcessRole role = roles.iterator().next();
        return role.isGlobal();
    }

    private String getPetriNetIdFromFirstRole(Set<ProcessRole> newRoles) {
        return newRoles.iterator().next().getNetId();
    }

    private void replaceUserRolesAndPublishEvent(Set<String> requestedRolesIds, IUser user, Set<ProcessRole> requestedRoles) {
        this.removeOldAndAssignNewRolesToUser(user, requestedRoles);
        this.publisher.publishEvent((ApplicationEvent)new UserRoleChangeEvent(user, this.findByIds(requestedRolesIds)));
    }

    private Set<ProcessRole> getRolesNewToUser(Set<ProcessRole> userOldRoles, Set<ProcessRole> newRequestedRoles) {
        HashSet<ProcessRole> rolesNewToUser = new HashSet<ProcessRole>(newRequestedRoles);
        rolesNewToUser.removeAll(userOldRoles);
        return rolesNewToUser;
    }

    private Set<ProcessRole> getRolesRemovedFromUser(Set<ProcessRole> userOldRoles, Set<ProcessRole> newRequestedRoles) {
        HashSet<ProcessRole> rolesRemovedFromUser = new HashSet<ProcessRole>(userOldRoles);
        rolesRemovedFromUser.removeAll(newRequestedRoles);
        return rolesRemovedFromUser;
    }

    private Set<String> mapUserRolesToIds(Collection<ProcessRole> processRoles) {
        return processRoles.stream().map(ProcessRole::getStringId).collect(Collectors.toSet());
    }

    private void runAllPreActions(Set<ProcessRole> newRoles, Set<ProcessRole> removedRoles, IUser user, PetriNet petriNet, Map<String, String> params) {
        this.runAllSuitableActionsOnRoles(newRoles, EventType.ASSIGN, EventPhaseType.PRE, user, petriNet, params);
        this.runAllSuitableActionsOnRoles(removedRoles, EventType.CANCEL, EventPhaseType.PRE, user, petriNet, params);
    }

    private void runAllPostActions(Set<ProcessRole> newRoles, Set<ProcessRole> removedRoles, IUser user, PetriNet petriNet, Map<String, String> params) {
        this.runAllSuitableActionsOnRoles(newRoles, EventType.ASSIGN, EventPhaseType.POST, user, petriNet, params);
        this.runAllSuitableActionsOnRoles(removedRoles, EventType.CANCEL, EventPhaseType.POST, user, petriNet, params);
    }

    private void runAllSuitableActionsOnRoles(Set<ProcessRole> roles, EventType requiredEventType, EventPhaseType requiredPhase, IUser user, PetriNet petriNet, Map<String, String> params) {
        roles.forEach(role -> {
            RoleContext<IUser> roleContext = new RoleContext<IUser>(user, (ProcessRole)role, petriNet);
            this.runAllSuitableActionsOnOneRole(role.getEvents(), requiredEventType, requiredPhase, roleContext, params);
        });
    }

    private void runAllSuitableActionsOnOneRole(Map<EventType, Event> eventMap, EventType requiredEventType, EventPhaseType requiredPhase, RoleContext roleContext, Map<String, String> params) {
        if (eventMap == null) {
            return;
        }
        eventMap.forEach((eventType, event) -> {
            if (eventType != requiredEventType) {
                return;
            }
            this.runActionsBasedOnPhase((Event)event, requiredPhase, roleContext, params);
        });
    }

    private void runActionsBasedOnPhase(Event event, EventPhaseType requiredPhase, RoleContext roleContext, Map<String, String> params) {
        switch (requiredPhase) {
            case PRE: {
                this.runActions(event.getPreActions(), roleContext, params);
                break;
            }
            case POST: {
                this.runActions(event.getPostActions(), roleContext, params);
            }
        }
    }

    private void runActions(List<Action> actions, RoleContext roleContext, Map<String, String> params) {
        actions.forEach(action -> this.roleActionsRunner.run((Action)action, roleContext, params));
    }

    private void removeOldAndAssignNewRolesToUser(IUser user, Set<ProcessRole> requestedRoles) {
        user.getProcessRoles().clear();
        user.getProcessRoles().addAll(requestedRoles);
        this.userService.save(user);
    }

    @Override
    public List<ProcessRole> findAll() {
        return this.processRoleRepository.findAll();
    }

    @Override
    public Set<ProcessRole> findAllGlobalRoles() {
        return this.processRoleRepository.findAllByGlobalIsTrue();
    }

    @Override
    public List<ProcessRole> findAll(String netId) {
        Optional netOptional = this.netRepository.findById(netId);
        if (netOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find model with id [" + netId + "]");
        }
        return this.findAll((PetriNet)netOptional.get());
    }

    private List<ProcessRole> findAll(PetriNet net) {
        return new LinkedList<ProcessRole>(net.getRoles().values());
    }

    @Override
    public ProcessRole defaultRole() {
        if (this.defaultRole == null) {
            Set<ProcessRole> roles = this.processRoleRepository.findAllByName_DefaultValue("default");
            if (roles.isEmpty()) {
                throw new IllegalStateException("No default process role has been found!");
            }
            if (roles.size() > 1) {
                throw new IllegalStateException("More than 1 default process role exists!");
            }
            this.defaultRole = roles.stream().findFirst().orElse(null);
        }
        return this.defaultRole;
    }

    @Override
    public ProcessRole anonymousRole() {
        if (this.anonymousRole == null) {
            Set<ProcessRole> roles = this.processRoleRepository.findAllByImportId("anonymous");
            if (roles.isEmpty()) {
                throw new IllegalStateException("No anonymous process role has been found!");
            }
            if (roles.size() > 1) {
                throw new IllegalStateException("More than 1 anonymous process role exists!");
            }
            this.anonymousRole = roles.stream().findFirst().orElse(null);
        }
        return this.anonymousRole;
    }

    @Override
    @Deprecated(forRemoval=true, since="6.2.0")
    public ProcessRole findByImportId(String importId) {
        return this.processRoleRepository.findAllByImportId(importId).stream().findFirst().orElse(null);
    }

    @Override
    public Set<ProcessRole> findAllByImportId(String importId) {
        return this.processRoleRepository.findAllByImportId(importId);
    }

    @Override
    public Set<ProcessRole> findAllByDefaultName(String name) {
        return this.processRoleRepository.findAllByName_DefaultValue(name);
    }

    @Override
    public ProcessRole findById(String id) {
        return this.processRoleRepository.findById(id).orElse(null);
    }

    @Override
    public void deleteRolesOfNet(PetriNet net, LoggedUser loggedUser) {
        log.info("[" + net.getStringId() + "]: Initiating deletion of all roles of Petri net " + net.getIdentifier() + " version " + net.getVersion().toString());
        List<ObjectId> deletedRoleIds = this.findAll(net.getStringId()).stream().filter(processRole -> processRole.getNetId() != null).map(ProcessRole::get_id).collect(Collectors.toList());
        Set<String> deletedRoleStringIds = deletedRoleIds.stream().map(ObjectId::toString).collect(Collectors.toSet());
        List<IUser> usersWithRemovedRoles = this.userService.findAllByProcessRoles(deletedRoleStringIds, false);
        for (IUser user : usersWithRemovedRoles) {
            log.info("[" + net.getStringId() + "]: Removing deleted roles of Petri net " + net.getIdentifier() + " version " + net.getVersion().toString() + " from user " + user.getFullName() + " with id " + user.getStringId());
            if (user.getProcessRoles().size() == 0) continue;
            Set<String> newRoles = user.getProcessRoles().stream().filter(role -> !deletedRoleStringIds.contains(role.getStringId())).map(ProcessRole::getStringId).collect(Collectors.toSet());
            this.assignRolesToUser(user.getStringId(), newRoles, loggedUser);
        }
        log.info("[" + net.getStringId() + "]: Deleting all roles of Petri net " + net.getIdentifier() + " version " + net.getVersion().toString());
        this.processRoleRepository.deleteAllBy_idIn(deletedRoleIds);
    }

    public void clearCache() {
        this.defaultRole = null;
        this.anonymousRole = null;
    }
}

