/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.service;

import com.netgrif.application.engine.configuration.properties.UriProperties;
import com.netgrif.application.engine.petrinet.domain.UriContentType;
import com.netgrif.application.engine.petrinet.domain.UriNode;
import com.netgrif.application.engine.petrinet.domain.repository.UriNodeRepository;
import com.netgrif.application.engine.petrinet.service.interfaces.IUriService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UriService
implements IUriService {
    private static final int FIRST_LEVEL = 0;
    private final UriNodeRepository uriNodeRepository;
    private final UriProperties uriProperties;

    public UriService(UriNodeRepository uriNodeRepository, UriProperties uriProperties) {
        this.uriNodeRepository = uriNodeRepository;
        this.uriProperties = uriProperties;
    }

    @Override
    public UriNode save(UriNode uriNode) {
        return (UriNode)this.uriNodeRepository.save(uriNode);
    }

    @Override
    public List<UriNode> findAllByParent(String parentId) {
        return this.uriNodeRepository.findAllByParentId(parentId);
    }

    @Override
    public UriNode getRoot() {
        List<UriNode> nodes = this.uriNodeRepository.findAllByLevel(0);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exactly one root uri node must exist!");
        }
        return nodes.get(0);
    }

    @Override
    public List<UriNode> findByLevel(int level) {
        return this.uriNodeRepository.findAllByLevel(level);
    }

    @Override
    public UriNode findById(String id) {
        Optional navNodeOptional = this.uriNodeRepository.findById(id);
        if (navNodeOptional.isEmpty()) {
            throw new IllegalArgumentException("Could not find NavNode with id [" + id + "]");
        }
        return (UriNode)navNodeOptional.get();
    }

    @Override
    public UriNode findByUri(String uri) {
        return this.uriNodeRepository.findByUriPath(uri);
    }

    @Override
    public UriNode populateDirectRelatives(UriNode uriNode) {
        if (uriNode == null) {
            return null;
        }
        if (uriNode.getLevel() != 0) {
            UriNode parent = this.findById(uriNode.getParentId());
            uriNode.setParent(parent);
        }
        Set<UriNode> children = StreamSupport.stream(this.uriNodeRepository.findAllById(uriNode.getChildrenId()).spliterator(), false).collect(Collectors.toSet());
        uriNode.setChildren(children);
        return uriNode;
    }

    @Override
    public UriNode move(String uri, String destUri) {
        UriNode uriNode = this.findByUri(uri);
        return this.move(uriNode, destUri);
    }

    @Override
    public UriNode move(UriNode node, String destUri) {
        if (this.isPathCycle(node.getUriPath(), (String)destUri)) {
            throw new IllegalArgumentException("Uri node with path " + node.getUriPath() + " cannot be moved to path " + (String)destUri + " due to cyclic paths");
        }
        UriNode newParent = this.getOrCreate((String)destUri, null);
        UriNode oldParent = this.findById(node.getParentId());
        if (((String)destUri).indexOf(this.uriProperties.getSeparator()) != 0) {
            destUri = this.uriProperties.getSeparator() + (String)destUri;
        }
        String oldNodePath = node.getUriPath();
        String newNodePath = (String)destUri + (((String)destUri).equals(this.uriProperties.getSeparator()) ? "" : this.uriProperties.getSeparator()) + node.getName();
        node.setUriPath(newNodePath);
        node.setParentId(newParent.getStringId());
        node.setLevel(newParent.getLevel() + 1);
        oldParent.getChildrenId().remove(node.getStringId());
        newParent.getChildrenId().add(node.getStringId());
        ArrayList<UriNode> childrenToSave = new ArrayList<UriNode>();
        if (!node.getChildrenId().isEmpty()) {
            node = this.populateDirectRelatives(node);
            childrenToSave.addAll(this.moveChildrenRecursive(oldNodePath, newNodePath, node.getChildren()));
        }
        this.uriNodeRepository.saveAll(List.of(oldParent, newParent, node));
        this.uriNodeRepository.saveAll(childrenToSave);
        return node;
    }

    private boolean isPathCycle(String picked, String dest) {
        return dest.startsWith(picked);
    }

    private List<UriNode> moveChildrenRecursive(String oldParentPath, String newParentPath, Set<UriNode> nodes) {
        ArrayList<UriNode> updated = new ArrayList<UriNode>();
        if (nodes == null || nodes.isEmpty()) {
            return new ArrayList<UriNode>();
        }
        for (UriNode node : nodes) {
            String oldPath = node.getUriPath();
            String diff = this.calcPathDifference(oldPath, oldParentPath);
            String newPath = newParentPath + diff;
            node.setUriPath(newPath);
            updated.add(node);
            node = this.populateDirectRelatives(node);
            updated.addAll(this.moveChildrenRecursive(oldPath, newPath, node.getChildren()));
        }
        return updated;
    }

    private String calcPathDifference(String path1, String path2) {
        return StringUtils.difference((String)path2, (String)path1);
    }

    @Override
    public UriNode getOrCreate(String uri, UriContentType contentType) {
        if (!((String)uri).startsWith(this.uriProperties.getSeparator())) {
            uri = this.uriProperties.getSeparator() + (String)uri;
        }
        LinkedList<UriNode> uriNodeList = new LinkedList<UriNode>();
        String[] uriComponents = ((String)uri).split(this.uriProperties.getSeparator());
        if (uriComponents.length == 0) {
            uriComponents = new String[]{this.uriProperties.getSeparator()};
        } else {
            uriComponents[0] = this.uriProperties.getSeparator();
        }
        StringBuilder uriBuilder = new StringBuilder();
        int pathLength = uriComponents.length;
        UriNode parent = null;
        for (int i = 0; i < pathLength; ++i) {
            uriBuilder.append(uriComponents[i]);
            UriNode uriNode = this.findByUri(uriBuilder.toString());
            if (uriNode == null) {
                uriNode = new UriNode();
                uriNode.setName(uriComponents[i]);
                uriNode.setLevel(i);
                uriNode.setUriPath(uriBuilder.toString());
                uriNode.setParentId(parent != null ? parent.getStringId() : null);
            }
            if (i == pathLength - 1 && contentType != null) {
                uriNode.addContentType(contentType);
            }
            uriNode = (UriNode)this.uriNodeRepository.save(uriNode);
            if (parent != null) {
                parent.getChildrenId().add(uriNode.getStringId());
                this.uriNodeRepository.save(parent);
            }
            if (i > 0) {
                uriBuilder.append(this.uriProperties.getSeparator());
            }
            uriNodeList.add(uriNode);
            parent = uriNode;
        }
        return (UriNode)uriNodeList.getLast();
    }

    @Override
    public UriNode createDefault() {
        UriNode uriNode = this.uriNodeRepository.findByUriPath(this.uriProperties.getSeparator());
        if (uriNode == null) {
            uriNode = new UriNode();
            uriNode.setName(this.uriProperties.getName());
            uriNode.setLevel(0);
            uriNode.setUriPath(this.uriProperties.getSeparator());
            uriNode.setParentId(null);
            uriNode.addContentType(UriContentType.DEFAULT);
            uriNode = (UriNode)this.uriNodeRepository.save(uriNode);
        }
        return uriNode;
    }

    @Override
    public String getUriSeparator() {
        return this.uriProperties.getSeparator();
    }
}

