/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.service.interfaces;

import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.importer.service.throwable.MissingIconKeyException;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.Transition;
import com.netgrif.application.engine.petrinet.domain.VersionType;
import com.netgrif.application.engine.petrinet.domain.dataset.Field;
import com.netgrif.application.engine.petrinet.domain.dataset.logic.action.Action;
import com.netgrif.application.engine.petrinet.domain.throwable.MissingPetriNetMetaDataException;
import com.netgrif.application.engine.petrinet.domain.version.Version;
import com.netgrif.application.engine.petrinet.web.responsebodies.DataFieldReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReference;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.petrinetoutcomes.ImportPetriNetEventOutcome;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bson.types.ObjectId;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface IPetriNetService {
    public static PetriNetReference transformToReference(PetriNet net, Locale locale) {
        return new PetriNetReference(net, locale);
    }

    public static TransitionReference transformToReference(PetriNet net, Transition transition, Locale locale) {
        ArrayList<com.netgrif.application.engine.workflow.web.responsebodies.DataFieldReference> list = new ArrayList<com.netgrif.application.engine.workflow.web.responsebodies.DataFieldReference>();
        transition.getImmediateData().forEach(fieldId -> list.add(new com.netgrif.application.engine.workflow.web.responsebodies.DataFieldReference(net.getDataSet().get(fieldId), locale)));
        return new TransitionReference(transition.getStringId(), transition.getTitle().getTranslation(locale), net.getStringId(), list);
    }

    public static DataFieldReference transformToReference(PetriNet net, Transition transition, Field field, Locale locale) {
        return new DataFieldReference(field.getStringId(), field.getName().getTranslation(locale), net.getStringId(), transition.getStringId());
    }

    public PetriNet clone(ObjectId var1);

    @Deprecated
    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, String var2, LoggedUser var3) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    @Deprecated
    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, String var2, LoggedUser var3, String var4) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, VersionType var2, LoggedUser var3) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, VersionType var2, LoggedUser var3, Map<String, String> var4) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, VersionType var2, LoggedUser var3, String var4) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    public ImportPetriNetEventOutcome importPetriNet(InputStream var1, VersionType var2, LoggedUser var3, String var4, Map<String, String> var5) throws IOException, MissingPetriNetMetaDataException, MissingIconKeyException;

    public Optional<PetriNet> save(PetriNet var1);

    public PetriNet getPetriNet(String var1);

    public PetriNet getPetriNet(String var1, Version var2);

    public List<PetriNet> getByIdentifier(String var1);

    public List<PetriNet> findAllByUriNodeId(String var1);

    public List<PetriNet> findAllById(List<String> var1);

    public PetriNet getNewestVersionByIdentifier(String var1);

    public List<PetriNet> getAll();

    public FileSystemResource getFile(String var1, String var2);

    public List<PetriNetReference> getReferences(LoggedUser var1, Locale var2);

    public List<PetriNetReference> getReferencesByIdentifier(String var1, LoggedUser var2, Locale var3);

    public List<PetriNetReference> getReferencesByVersion(Version var1, LoggedUser var2, Locale var3);

    public List<PetriNetReference> getReferencesByUsersProcessRoles(LoggedUser var1, Locale var2);

    public PetriNetReference getReference(String var1, Version var2, LoggedUser var3, Locale var4);

    public List<TransitionReference> getTransitionReferences(List<String> var1, LoggedUser var2, Locale var3);

    public List<DataFieldReference> getDataFieldReferences(List<TransitionReference> var1, Locale var2);

    public Page<PetriNetReference> search(PetriNetSearch var1, LoggedUser var2, Pageable var3, Locale var4);

    public Optional<PetriNet> findByImportId(String var1);

    public void evictAllCaches();

    public void evictCache(PetriNet var1);

    public PetriNet get(ObjectId var1);

    public List<PetriNet> get(Collection<ObjectId> var1);

    public List<PetriNet> get(List<String> var1);

    public void deletePetriNet(String var1, LoggedUser var2);

    public void runActions(List<Action> var1, PetriNet var2);

    public List<String> getExistingPetriNetIdentifiersFromIdentifiersList(List<String> var1);

    public PetriNetImportReference getNetFromCase(String var1);
}

