/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.web;

import com.netgrif.application.engine.AsyncRunner;
import com.netgrif.application.engine.auth.domain.LoggedUser;
import com.netgrif.application.engine.eventoutcomes.LocalisedEventOutcomeFactory;
import com.netgrif.application.engine.importer.service.throwable.MissingIconKeyException;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.VersionType;
import com.netgrif.application.engine.petrinet.domain.throwable.MissingPetriNetMetaDataException;
import com.netgrif.application.engine.petrinet.domain.version.StringToVersionConverter;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.petrinet.web.responsebodies.DataFieldReferencesResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetImportReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReferenceResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReferenceResourceAssembler;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReferenceResources;
import com.netgrif.application.engine.petrinet.web.responsebodies.ProcessRolesResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransactionsResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReferencesResource;
import com.netgrif.application.engine.workflow.domain.FileStorageConfiguration;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.petrinetoutcomes.ImportPetriNetEventOutcome;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessage;
import com.netgrif.application.engine.workflow.domain.eventoutcomes.response.EventOutcomeWithMessageResource;
import com.netgrif.application.engine.workflow.web.responsebodies.MessageResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/petrinet"})
@ConditionalOnProperty(value={"nae.petrinet.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="PetriNet")
public class PetriNetController {
    private static final Logger log = LoggerFactory.getLogger(PetriNetController.class);
    @Autowired
    private FileStorageConfiguration fileStorageConfiguration;
    @Autowired
    private IPetriNetService service;
    @Autowired
    private IProcessRoleService roleService;
    @Autowired
    private StringToVersionConverter converter;
    @Autowired
    private AsyncRunner asyncRunner;

    public static String decodeUrl(String s1) {
        try {
            if (s1 == null) {
                return null;
            }
            return URLDecoder.decode(s1, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error("Decoding URL failed: ", (Throwable)e);
            return "";
        }
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Import new process", description="Caller must have the ADMIN role. Imports an entirely new process or a new version of an existing process.", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Process model is invalid"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    @PostMapping(value={"/import"}, produces={"application/hal+json"})
    public EntityModel<EventOutcomeWithMessage> importPetriNet(@RequestParam(value="file", required=true) MultipartFile multipartFile, @RequestParam(value="uriNodeId", required=true) String uriNodeId, @RequestParam(value="meta", required=false) String releaseType, Authentication auth, Locale locale) throws MissingPetriNetMetaDataException, MissingIconKeyException {
        try {
            VersionType release = releaseType == null ? VersionType.MAJOR : VersionType.valueOf(releaseType.trim().toUpperCase());
            ImportPetriNetEventOutcome importPetriNetOutcome = this.service.importPetriNet(multipartFile.getInputStream(), release, (LoggedUser)((Object)auth.getPrincipal()), uriNodeId);
            return EventOutcomeWithMessageResource.successMessage("Petri net " + multipartFile.getOriginalFilename() + " imported successfully", LocalisedEventOutcomeFactory.from(importPetriNetOutcome, locale));
        }
        catch (IOException e) {
            log.error("Importing Petri net failed: ", (Throwable)e);
            return EventOutcomeWithMessageResource.errorMessage("IO error while importing Petri net");
        }
    }

    @Operation(summary="Get all processes", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(produces={"application/hal+json"})
    public PetriNetReferenceResources getAll(@RequestParam(value="indentifier", required=false) String identifier, @RequestParam(value="version", required=false) String version, Authentication auth, Locale locale) {
        LoggedUser user = (LoggedUser)((Object)auth.getPrincipal());
        if (identifier != null && version == null) {
            return new PetriNetReferenceResources(this.service.getReferencesByIdentifier(identifier, user, locale));
        }
        if (identifier == null && version != null) {
            return new PetriNetReferenceResources(this.service.getReferencesByVersion(this.converter.convert(version), user, locale));
        }
        if (identifier != null && version != null) {
            return new PetriNetReferenceResources(Collections.singletonList(this.service.getReference(identifier, this.converter.convert(version), user, locale)));
        }
        return new PetriNetReferenceResources(this.service.getReferences(user, locale));
    }

    @Operation(summary="Get process by id", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    public PetriNetReferenceResource getOne(@PathVariable(value="id") String id, Authentication auth, Locale locale) {
        return new PetriNetReferenceResource(IPetriNetService.transformToReference(this.service.getPetriNet(PetriNetController.decodeUrl(id)), locale));
    }

    @Operation(summary="Get process by identifier and version", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{identifier}/{version}"}, produces={"application/hal+json"})
    public PetriNetReferenceResource getOne(@PathVariable(value="identifier") String identifier, @PathVariable(value="version") String version, Authentication auth, Locale locale) {
        String resolvedIdentifier = Base64.isBase64((String)identifier) ? new String(Base64.decodeBase64((String)identifier)) : identifier;
        return new PetriNetReferenceResource(this.service.getReference(resolvedIdentifier, this.converter.convert(version), (LoggedUser)((Object)auth.getPrincipal()), locale));
    }

    @Operation(summary="Get transitions of processes", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/transitions"}, produces={"application/hal+json"})
    public TransitionReferencesResource getTransitionReferences(@RequestParam List<String> ids, Authentication auth, Locale locale) {
        ids.forEach(id -> {
            id = PetriNetController.decodeUrl(id);
        });
        return new TransitionReferencesResource(this.service.getTransitionReferences(ids, (LoggedUser)((Object)auth.getPrincipal()), locale));
    }

    @Operation(summary="Get data fields of transitions", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/data"}, consumes={"application/json"}, produces={"application/hal+json"})
    public DataFieldReferencesResource getDataFieldReferences(@RequestBody List<TransitionReference> referenceBody, Locale locale) {
        return new DataFieldReferencesResource(this.service.getDataFieldReferences(referenceBody, locale));
    }

    @Operation(summary="Get roles of process", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{netId}/roles"}, produces={"application/hal+json"})
    public ProcessRolesResource getRoles(@PathVariable(value="netId") String netId, Locale locale) {
        netId = PetriNetController.decodeUrl(netId);
        return new ProcessRolesResource(this.roleService.findAll(netId), this.service.getPetriNet(PetriNetController.decodeUrl(netId)).getPermissions(), netId, locale);
    }

    @Operation(summary="Get transactions of process", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{netId}/transactions"}, produces={"application/hal+json"})
    public TransactionsResource getTransactions(@PathVariable(value="netId") String netId, Locale locale) {
        PetriNet net = this.service.getPetriNet(PetriNetController.decodeUrl(netId));
        return new TransactionsResource(net.getTransactions().values(), netId, locale);
    }

    @PreAuthorize(value="@authorizationService.hasAuthority('ADMIN')")
    @Operation(summary="Download process model", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/{netId}/file"}, produces={"application/octet-stream"})
    public FileSystemResource getNetFile(@PathVariable(value="netId") String netId, @RequestParam(value="title", required=false) String title, Authentication auth, HttpServletResponse response) {
        FileSystemResource fileResource = this.service.getFile(PetriNetController.decodeUrl(netId), PetriNetController.decodeUrl(title));
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileResource.getFilename() + ".xml\"");
        response.setHeader("Content-Length", String.valueOf(fileResource.getFile().length()));
        log.info("Downloading Petri net file: " + fileResource.getFilename() + " [" + netId + "]");
        return fileResource;
    }

    @Operation(summary="Search processes", security={@SecurityRequirement(name="BasicAuth")})
    @PostMapping(value={"/search"}, produces={"application/hal+json"})
    @ResponseBody
    public PagedModel<PetriNetReferenceResource> searchPetriNets(@RequestBody PetriNetSearch criteria, Authentication auth, Pageable pageable, PagedResourcesAssembler<PetriNetReference> assembler, Locale locale) {
        LoggedUser user = (LoggedUser)((Object)auth.getPrincipal());
        Page<PetriNetReference> nets = this.service.search(criteria, user, pageable, locale);
        Link selfLink = WebMvcLinkBuilder.linkTo(((PetriNetController)WebMvcLinkBuilder.methodOn(PetriNetController.class, (Object[])new Object[0])).searchPetriNets(criteria, auth, pageable, assembler, locale)).withRel("search");
        PagedModel resources = assembler.toModel(nets, (RepresentationModelAssembler)new PetriNetReferenceResourceAssembler(), selfLink);
        PetriNetReferenceResourceAssembler.buildLinks((CollectionModel)resources);
        return resources;
    }

    @PreAuthorize(value="@petriNetAuthorizationService.canCallProcessDelete(#auth.getPrincipal(), #processId)")
    @Operation(summary="Delete process", description="Caller must have the ADMIN role. Removes the specified process, along with it's cases, tasks and process roles.", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="403", description="Caller doesn't fulfill the authorisation requirements")})
    @DeleteMapping(value={"/{id}"}, produces={"application/hal+json"})
    public MessageResource deletePetriNet(@PathVariable(value="id") String processId, Authentication auth) {
        String decodedProcessId = PetriNetController.decodeUrl(processId);
        if (Objects.equals(decodedProcessId, "")) {
            log.error("Deleting Petri net [" + processId + "] failed: could not decode process ID from URL");
            return MessageResource.errorMessage("Deleting Petri net " + processId + " failed!");
        }
        LoggedUser user = (LoggedUser)((Object)auth.getPrincipal());
        this.asyncRunner.execute(() -> this.service.deletePetriNet(decodedProcessId, user));
        return MessageResource.successMessage("Petri net " + decodedProcessId + " is being deleted");
    }

    @Operation(summary="Get net by case id", security={@SecurityRequirement(name="BasicAuth")})
    @GetMapping(value={"/case/{id}"}, produces={"application/hal+json"})
    public PetriNetImportReference getOne(@PathVariable(value="id") String caseId) {
        return this.service.getNetFromCase(PetriNetController.decodeUrl(caseId));
    }
}

