/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.web;

import com.netgrif.application.engine.auth.service.interfaces.IUserService;
import com.netgrif.application.engine.petrinet.domain.PetriNet;
import com.netgrif.application.engine.petrinet.domain.PetriNetSearch;
import com.netgrif.application.engine.petrinet.domain.version.StringToVersionConverter;
import com.netgrif.application.engine.petrinet.service.interfaces.IPetriNetService;
import com.netgrif.application.engine.petrinet.service.interfaces.IProcessRoleService;
import com.netgrif.application.engine.petrinet.web.PetriNetController;
import com.netgrif.application.engine.petrinet.web.responsebodies.DataFieldReferencesResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReferenceResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.PetriNetReferenceResourceAssembler;
import com.netgrif.application.engine.petrinet.web.responsebodies.ProcessRolesResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransactionsResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReference;
import com.netgrif.application.engine.petrinet.web.responsebodies.TransitionReferencesResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(value={"nae.public.petrinet.web.enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="Public PetriNet Controller")
@RequestMapping(value={"/api/public/petrinet"})
public class PublicPetriNetController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicPetriNetController.class);
    private final IPetriNetService petriNetService;
    private final IProcessRoleService roleService;
    private final IUserService userService;
    private final StringToVersionConverter converter;

    public PublicPetriNetController(IPetriNetService petriNetService, IUserService userService, StringToVersionConverter converter, IProcessRoleService roleService) {
        this.petriNetService = petriNetService;
        this.converter = converter;
        this.userService = userService;
        this.roleService = roleService;
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @Operation(summary="Get process by id")
    public PetriNetReferenceResource getOne(@PathVariable(value="id") String id, Locale locale) {
        return new PetriNetReferenceResource(IPetriNetService.transformToReference(this.petriNetService.getPetriNet(PetriNetController.decodeUrl(id)), locale));
    }

    @Operation(summary="Get process by identifier and version")
    @GetMapping(value={"/{identifier}/{version}"}, produces={"application/hal+json"})
    @ResponseBody
    public PetriNetReferenceResource getOne(@PathVariable(value="identifier") String identifier, @PathVariable(value="version") String version, Locale locale) {
        String resolvedIdentifier = Base64.isBase64((String)identifier) ? new String(Base64.decodeBase64((String)identifier)) : identifier;
        return new PetriNetReferenceResource(this.petriNetService.getReference(resolvedIdentifier, this.converter.convert(version), this.userService.getAnonymousLogged(), locale));
    }

    @Operation(summary="Search processes")
    @PostMapping(value={"/search"}, consumes={"application/json"}, produces={"application/hal+json"})
    public PagedModel<PetriNetReferenceResource> searchPetriNets(@RequestBody PetriNetSearch criteria, Pageable pageable, PagedResourcesAssembler<PetriNetReference> assembler, Locale locale) {
        Page<PetriNetReference> nets = this.petriNetService.search(criteria, this.userService.getAnonymousLogged(), pageable, locale);
        Link selfLink = WebMvcLinkBuilder.linkTo(((PublicPetriNetController)WebMvcLinkBuilder.methodOn(PublicPetriNetController.class, (Object[])new Object[0])).searchPetriNets(criteria, pageable, assembler, locale)).withRel("search");
        PagedModel resources = assembler.toModel(nets, (RepresentationModelAssembler)new PetriNetReferenceResourceAssembler(), selfLink);
        PetriNetReferenceResourceAssembler.buildLinks((CollectionModel)resources);
        return resources;
    }

    @Operation(summary="Get roles of process")
    @GetMapping(value={"/{netId}/roles"}, produces={"application/hal+json"})
    public ProcessRolesResource getRoles(@PathVariable(value="netId") String netId, Locale locale) {
        netId = PetriNetController.decodeUrl(netId);
        return new ProcessRolesResource(this.roleService.findAll(netId), this.petriNetService.getPetriNet(netId).getPermissions(), netId, locale);
    }

    @Operation(summary="Get transactions of process")
    @GetMapping(value={"/{netId}/transactions"}, produces={"application/hal+json"})
    public TransactionsResource getTransactions(@PathVariable(value="netId") String netId, Locale locale) {
        PetriNet net = this.petriNetService.getPetriNet(PetriNetController.decodeUrl(netId));
        return new TransactionsResource(net.getTransactions().values(), netId, locale);
    }

    @Operation(summary="Get data fields of transitions")
    @PostMapping(value={"/data"}, consumes={"application/json"}, produces={"application/hal+json"})
    public DataFieldReferencesResource getDataFieldReferences(@RequestBody List<TransitionReference> referenceBody, Locale locale) {
        return new DataFieldReferencesResource(this.petriNetService.getDataFieldReferences(referenceBody, locale));
    }

    @Operation(summary="Get transitions of processes")
    @GetMapping(value={"/transitions"}, produces={"application/hal+json"})
    public TransitionReferencesResource getTransitionReferences(@RequestParam List<String> ids, Locale locale) {
        ids.forEach(PetriNetController::decodeUrl);
        return new TransitionReferencesResource(this.petriNetService.getTransitionReferences(ids, this.userService.getAnonymousLogged(), locale));
    }
}

