/*
 * Decompiled with CFR 0.152.
 */
package com.netgrif.application.engine.petrinet.web;

import com.netgrif.application.engine.petrinet.domain.UriNode;
import com.netgrif.application.engine.petrinet.service.interfaces.IUriService;
import com.netgrif.application.engine.petrinet.web.responsebodies.UriNodeResource;
import com.netgrif.application.engine.petrinet.web.responsebodies.UriNodeResources;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Base64;
import java.util.List;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/uri"})
@Tag(name="Process URI")
public class UriController {
    private final IUriService uriService;

    public UriController(IUriService uriService) {
        this.uriService = uriService;
    }

    @Operation(summary="Get root UriNodes", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/root"}, produces={"application/hal+json"})
    public EntityModel<UriNode> getRoot() {
        UriNode uriNode = this.uriService.getRoot();
        this.uriService.populateDirectRelatives(uriNode);
        return new UriNodeResource(uriNode);
    }

    @Operation(summary="Get one UriNode by URI path", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/{uri}"}, produces={"application/hal+json"})
    public EntityModel<UriNode> getOne(@PathVariable(value="uri") String uri) {
        uri = new String(Base64.getDecoder().decode(uri));
        UriNode uriNode = this.uriService.findByUri(uri);
        uriNode = this.uriService.populateDirectRelatives(uriNode);
        return new UriNodeResource(uriNode);
    }

    @Operation(summary="Get UriNodes by parent id", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/parent/{parentId}"}, produces={"application/hal+json"})
    public CollectionModel<UriNode> getByParent(@PathVariable(value="parentId") String parentId) {
        List<UriNode> uriNodes = this.uriService.findAllByParent(parentId);
        uriNodes.forEach(this.uriService::populateDirectRelatives);
        return new UriNodeResources(uriNodes);
    }

    @Operation(summary="Get UriNodes by on the same level", security={@SecurityRequirement(name="BasicAuth")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/level/{level}"}, produces={"application/hal+json"})
    public CollectionModel<UriNode> getByLevel(@PathVariable(value="level") int level) {
        List<UriNode> uriNodes = this.uriService.findByLevel(level);
        uriNodes.forEach(this.uriService::populateDirectRelatives);
        return new UriNodeResources(uriNodes);
    }
}

